/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformerKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0004J\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bJ\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bJ\f\u0010\u0019\u001a\u00020\u0005*\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\u0005*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\u0005*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleFragmentToExternalName;", "", "jsOutputNamesMapping", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "(Ljava/util/Map;)V", "outputName", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getOutputName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Ljava/lang/String;", "stableFileName", "getStableFileName", "getExternalNameFor", "fileName", "packageFqn", "moduleName", "file", "module", "getExternalNameForExporterFile", "getFileStableName", "getPackageFqn", "externalName", "getSafeNameExporterFor", "getSafeNameFor", "getJsOutputName", "backend.js"})
public final class ModuleFragmentToExternalName {
    @NotNull
    private final Map<IrModuleFragment, String> jsOutputNamesMapping;

    public ModuleFragmentToExternalName(@NotNull Map<IrModuleFragment, String> jsOutputNamesMapping) {
        Intrinsics.checkNotNullParameter(jsOutputNamesMapping, (String)"jsOutputNamesMapping");
        this.jsOutputNamesMapping = jsOutputNamesMapping;
    }

    @NotNull
    public final String getExternalNameFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string2 = this.getOutputName(file2);
        String string3 = file2.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        return this.getExternalNameFor(string2, string3, this.getJsOutputName(file2.getModule()));
    }

    @NotNull
    public final String getExternalNameFor(@NotNull String fileName, @NotNull String packageFqn, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)packageFqn, (String)"packageFqn");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return moduleName + '/' + this.getFileStableName(fileName, packageFqn);
    }

    @NotNull
    public final String getExternalNameForExporterFile(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string2 = this.getOutputName(file2);
        String string3 = file2.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        return this.getExternalNameForExporterFile(string2, string3, this.getJsOutputName(file2.getModule()));
    }

    @NotNull
    public final String getExternalNameForExporterFile(@NotNull String fileName, @NotNull String packageFqn, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)packageFqn, (String)"packageFqn");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return this.getExternalNameFor(fileName, packageFqn, moduleName) + ".export";
    }

    @NotNull
    public final String getSafeNameFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return IrModuleToJsTransformerKt.getSafeName(file2.getModule()) + '/' + this.getStableFileName(file2);
    }

    @NotNull
    public final String getSafeNameExporterFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getSafeNameFor(file2) + ".export";
    }

    @NotNull
    public final String getExternalNameFor(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.getJsOutputName(module2);
    }

    private final String getJsOutputName(IrModuleFragment $this$getJsOutputName) {
        String string2 = this.jsOutputNamesMapping.get($this$getJsOutputName);
        if (string2 == null) {
            string2 = NameTablesKt.sanitizeName$default(IrModuleToJsTransformerKt.getSafeName($this$getJsOutputName), false, 2, null);
        }
        return string2;
    }

    private final String getFileStableName(String fileName, String packageFqn) {
        String prefix = StringsKt.replace$default((String)packageFqn, (char)'.', (char)'/', (boolean)false, (int)4, null);
        return prefix + (((CharSequence)prefix).length() > 0 ? "/" : "") + fileName;
    }

    @NotNull
    public final String getPackageFqn(@NotNull String externalName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        int endOfModuleNamePart = StringsKt.indexOf$default((CharSequence)externalName, (char)'/', (int)0, (boolean)false, (int)6, null);
        int startOfFileNamePart = StringsKt.lastIndexOf$default((CharSequence)externalName, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (endOfModuleNamePart == startOfFileNamePart) {
            string2 = "";
        } else {
            String string3 = externalName.substring(endOfModuleNamePart + 1, startOfFileNamePart);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string2 = StringsKt.replace$default((String)string3, (char)'/', (char)'.', (boolean)false, (int)4, null);
        }
        return string2;
    }

    private final String getOutputName(IrFile $this$outputName) {
        String string2 = AnnotationUtilsKt.getJsFileName($this$outputName);
        if (string2 == null) {
            string2 = IrJsUtilsKt.getNameWithoutExtension($this$outputName);
        }
        return string2;
    }

    private final String getStableFileName(IrFile $this$stableFileName) {
        String string2 = this.getOutputName($this$stableFileName);
        String string3 = $this$stableFileName.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        return this.getFileStableName(string2, string3);
    }
}

