/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.clean.WhileConditionFolding;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\bJ\u001a\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/WhileConditionFolding;", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "getBody", "()Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "changed", "", "apply", "hasContinue", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "label", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
public final class WhileConditionFolding {
    @NotNull
    private final JsBlock body;
    private boolean changed;

    public WhileConditionFolding(@NotNull JsBlock body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this.body = body2;
    }

    @NotNull
    public final JsBlock getBody() {
        return this.body;
    }

    public final boolean apply() {
        this.body.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ WhileConditionFolding this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitLabel(JsLabel x) {
                JsStatement innerStatement;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = innerStatement = x.getStatement();
                if (jsStatement instanceof JsWhile) {
                    Intrinsics.checkNotNull((Object)innerStatement);
                    this.process((JsWhile)innerStatement, x.getName());
                } else if (jsStatement instanceof JsDoWhile) {
                    Intrinsics.checkNotNull((Object)innerStatement);
                    this.process((JsDoWhile)innerStatement, x.getName());
                } else {
                    super.visitLabel(x);
                }
            }

            public void visitWhile(JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.process(x, null);
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.process(x, null);
            }

            private final void process(JsWhile statement2, JsName name2) {
                this.process(statement2, name2, (Function1<? super JsStatement, ? extends JsStatement>)((Function1)new Function1<JsStatement, JsStatement>(this){
                    final /* synthetic */ apply.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final JsStatement invoke(JsStatement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return apply.1.access$first(this.this$0, it);
                    }
                }), (Function1<? super JsStatement, ? extends JsStatement>)((Function1)new Function1<JsStatement, JsStatement>(this){
                    final /* synthetic */ apply.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final JsStatement invoke(JsStatement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return apply.1.access$removeFirst(this.this$0, it);
                    }
                }), (Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function2)apply.process.3.INSTANCE));
            }

            private final void process(JsDoWhile statement2, JsName name2) {
                JsStatement jsStatement = statement2.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getBody(...)");
                if (!WhileConditionFolding.access$hasContinue(this.this$0, jsStatement, name2)) {
                    this.process(statement2, name2, (Function1<? super JsStatement, ? extends JsStatement>)((Function1)new Function1<JsStatement, JsStatement>(this){
                        final /* synthetic */ apply.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final JsStatement invoke(JsStatement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return apply.1.access$last(this.this$0, it);
                        }
                    }), (Function1<? super JsStatement, ? extends JsStatement>)((Function1)new Function1<JsStatement, JsStatement>(this){
                        final /* synthetic */ apply.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final JsStatement invoke(JsStatement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return apply.1.access$removeLast(this.this$0, it);
                        }
                    }), (Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function2)apply.process.6.INSTANCE));
                }
            }

            private final void process(JsWhile statement2, JsName name2, Function1<? super JsStatement, ? extends JsStatement> find, Function1<? super JsStatement, ? extends JsStatement> remove, Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression> combine) {
                boolean optimized;
                statement2.getBody().accept(this);
                do {
                    JsExpression jsExpression;
                    optimized = false;
                    JsStatement jsStatement = statement2.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getBody(...)");
                    JsStatement first = (JsStatement)find.invoke((Object)jsStatement);
                    JsExpression condition = this.extractCondition(first, name2);
                    if (condition == null) continue;
                    JsStatement jsStatement2 = statement2.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getBody(...)");
                    statement2.setBody((JsStatement)remove.invoke((Object)jsStatement2));
                    JsExpression existingCondition = statement2.getCondition();
                    if (JsBooleanLiteral.isTrue(existingCondition)) {
                        jsExpression = condition;
                    } else {
                        Intrinsics.checkNotNull((Object)existingCondition);
                        jsExpression = (JsExpression)combine.invoke((Object)existingCondition, (Object)condition);
                    }
                    statement2.setCondition(jsExpression);
                    WhileConditionFolding.access$setChanged$p(this.this$0, true);
                    optimized = true;
                } while (optimized);
            }

            private final JsExpression extractCondition(JsStatement statement2, JsName label) {
                JsExpression jsExpression;
                JsStatement jsStatement = statement2;
                if (jsStatement instanceof JsBreak) {
                    JsNameRef jsNameRef = ((JsBreak)statement2).getLabel();
                    JsName target = jsNameRef != null ? jsNameRef.getName() : null;
                    jsExpression = Intrinsics.areEqual((Object)label, (Object)target) ? new JsBooleanLiteral(false) : null;
                } else if (jsStatement instanceof JsIf) {
                    JsStatement jsStatement2 = ((JsIf)statement2).getThenStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getThenStatement(...)");
                    JsStatement then = jsStatement2;
                    if (((JsIf)statement2).getElseStatement() == null) {
                        JsExpression result2;
                        JsExpression nextCondition = this.extractCondition(then, label);
                        jsExpression = result2 = nextCondition == null ? null : (JsBooleanLiteral.isFalse(nextCondition) ? JsAstUtils.notOptimized(((JsIf)statement2).getIfExpression()) : (JsExpression)JsAstUtils.or(JsAstUtils.notOptimized(((JsIf)statement2).getIfExpression()), nextCondition));
                    } else {
                        jsExpression = null;
                    }
                } else if (jsStatement instanceof JsBlock) {
                    if (((JsBlock)statement2).getStatements().size() == 1) {
                        JsStatement jsStatement3 = ((JsBlock)statement2).getStatements().get(0);
                        Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"get(...)");
                        jsExpression = this.extractCondition(jsStatement3, label);
                    } else {
                        jsExpression = null;
                    }
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }

            private final JsStatement first(JsStatement statement2) {
                JsStatement jsStatement;
                if (statement2 instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
                    jsStatement = (JsStatement)CollectionsKt.firstOrNull(list2);
                    if (jsStatement == null) {
                        jsStatement = statement2;
                    }
                } else {
                    jsStatement = statement2;
                }
                return jsStatement;
            }

            private final JsBlock removeFirst(JsStatement statement2) {
                JsBlock jsBlock;
                if (statement2 instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
                    List<JsStatement> statements = list2;
                    if (!((Collection)statements).isEmpty()) {
                        statements.remove(0);
                    }
                    jsBlock = (JsBlock)statement2;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            private final JsStatement last(JsStatement statement2) {
                JsStatement jsStatement;
                if (statement2 instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
                    jsStatement = (JsStatement)CollectionsKt.lastOrNull(list2);
                    if (jsStatement == null) {
                        jsStatement = statement2;
                    }
                } else {
                    jsStatement = statement2;
                }
                return jsStatement;
            }

            private final JsBlock removeLast(JsStatement statement2) {
                JsBlock jsBlock;
                if (statement2 instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
                    List<JsStatement> statements = list2;
                    if (!((Collection)statements).isEmpty()) {
                        statements.remove(CollectionsKt.getLastIndex(statements));
                    }
                    jsBlock = (JsBlock)statement2;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public static final /* synthetic */ JsStatement access$first(apply.1 $this, JsStatement statement2) {
                return $this.first(statement2);
            }

            public static final /* synthetic */ JsBlock access$removeFirst(apply.1 $this, JsStatement statement2) {
                return $this.removeFirst(statement2);
            }

            public static final /* synthetic */ JsStatement access$last(apply.1 $this, JsStatement statement2) {
                return $this.last(statement2);
            }

            public static final /* synthetic */ JsBlock access$removeLast(apply.1 $this, JsStatement statement2) {
                return $this.removeLast(statement2);
            }
        });
        return this.changed;
    }

    private final boolean hasContinue(JsStatement statement2, JsName label) {
        Ref.BooleanRef found = new Ref.BooleanRef();
        statement2.accept(new RecursiveJsVisitor(found, label){
            private int level;
            final /* synthetic */ Ref.BooleanRef $found;
            final /* synthetic */ JsName $label;
            {
                this.$found = $found;
                this.$label = $label;
            }

            public void visitContinue(JsContinue x) {
                JsName name2;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = name2 = jsNameRef != null ? jsNameRef.getName() : null;
                if (name2 == null) {
                    if (this.level == 0) {
                        this.$found.element = true;
                    }
                } else if (Intrinsics.areEqual((Object)name2, (Object)this.$label)) {
                    this.$found.element = true;
                }
            }

            public void visitFor(JsFor x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitFor(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitWhile(JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitDoWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitForIn(JsForIn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitForIn(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            protected void visitElement(JsNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!this.$found.element) {
                    super.visitElement(node);
                }
            }
        });
        return found.element;
    }

    public static final /* synthetic */ boolean access$hasContinue(WhileConditionFolding $this, JsStatement statement2, JsName label) {
        return $this.hasContinue(statement2, label);
    }

    public static final /* synthetic */ void access$setChanged$p(WhileConditionFolding $this, boolean bl) {
        $this.changed = bl;
    }
}

