/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a,\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0003\"\b\b\u0000\u0010\u0017*\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a&\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u001f0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010%\u001a\u00020\u0004\u001a\u0010\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020(\u001a\u001c\u0010)\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\u0010\u0010*\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020,\u001a\u0016\u0010-\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0\t*\u00020\u0010\u001a\u0010\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u001d\u001a\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u001d2\b\b\u0002\u0010\u0014\u001a\u00020\u0001\u00a8\u00062"}, d2={"appendArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "collectAccessors", "", "", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "fragments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "collectDefinedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "skipLabelsAndCatches", "collectDefinedNamesInAllScopes", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectLocalFunctions", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "collectNamedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "collectNamedFunctionsAndMetadata", "Lkotlin/Pair;", "collectNamedFunctionsAndWrappers", "collectNamedFunctionsOrMetadata", "collectReferencedNames", "collectUsedNames", "extractFunction", "expression", "extractImportTag", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "extractImportTagImpl", "getImportTag", "jsVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "collectBreakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectFreeVariables", "collectLocalVariables", "js.translator"})
@SourceDebugExtension(value={"SMAP\ncollectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 collectUtils.kt\norg/jetbrains/kotlin/js/inline/util/CollectUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,471:1\n1547#2:472\n1618#2,3:473\n1547#2:476\n1618#2,3:477\n1236#2,4:482\n1236#2,4:488\n1236#2,4:494\n1236#2,4:500\n1862#2,3:504\n453#3:480\n403#3:481\n453#3:486\n403#3:487\n453#3:492\n403#3:493\n453#3:498\n403#3:499\n*S KotlinDebug\n*F\n+ 1 collectUtils.kt\norg/jetbrains/kotlin/js/inline/util/CollectUtilsKt\n*L\n165#1:472\n165#1:473,3\n167#1:476\n167#1:477,3\n169#1:482,4\n171#1:488,4\n185#1:494,4\n186#1:500,4\n462#1:504,3\n169#1:480\n169#1:481\n171#1:486\n171#1:487\n185#1:492\n185#1:493\n186#1:498\n186#1:499\n*E\n"})
public final class CollectUtilsKt {
    @NotNull
    public static final Set<JsName> collectReferencedNames(@NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set<JsName> $references;
            {
                this.$references = $references;
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer = x.getInitExpression();
                if (initializer != null) {
                    this.accept((JsNode)initializer);
                }
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name2 = nameRef.getName();
                if (name2 != null) {
                    ((Collection)this.$references).add(name2);
                }
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set<JsName> $references;
            {
                this.$references = $references;
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer = x.getInitExpression();
                if (initializer != null) {
                    this.accept((JsNode)initializer);
                }
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name2 = nameRef.getName();
                if (name2 != null && nameRef.getQualifier() == null) {
                    this.$references.add(name2);
                }
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                CollectionsKt.addAll((Collection)this.$references, (Iterable)CollectUtilsKt.collectFreeVariables(x));
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return CollectUtilsKt.collectDefinedNames(scope, false);
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope, boolean skipLabelsAndCatches) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2, skipLabelsAndCatches){
            final /* synthetic */ Set<JsName> $names;
            final /* synthetic */ boolean $skipLabelsAndCatches;
            {
                this.$names = $names;
                this.$skipLabelsAndCatches = $skipLabelsAndCatches;
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer = x.getInitExpression();
                if (initializer != null) {
                    this.accept((JsNode)initializer);
                }
                ((Collection)this.$names).add(x.getName());
            }

            public void visitExpressionStatement(JsExpressionStatement x) {
                JsName name2;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsFunction && (name2 = ((JsFunction)expression2).getName()) != null) {
                    ((Collection)this.$names).add(name2);
                }
                super.visitExpressionStatement(x);
            }

            public void visitLabel(JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (!this.$skipLabelsAndCatches) {
                    JsName jsName = x.getName();
                    if (jsName != null) {
                        JsName jsName2 = jsName;
                        Set<JsName> set = this.$names;
                        JsName it = jsName2;
                        boolean bl = false;
                        ((Collection)set).add(it);
                    }
                }
                super.visitLabel(x);
            }

            public void visitCatch(JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (!this.$skipLabelsAndCatches) {
                    ((Collection)this.$names).add(x.getParameter().getName());
                }
                super.visitCatch(x);
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
        }.accept(scope);
        return names2;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNamesInAllScopes(@NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set<JsName> $names;
            {
                this.$names = $names;
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visit(x);
                ((Collection)this.$names).add(x.getName());
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(JsFunction x) {
                block1: {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    super.visitFunction(x);
                    Collection collection = this.$names;
                    List<JsParameter> list2 = x.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JsParameter jsParameter = (JsParameter)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        JsName jsName = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                        collection2.add(jsName);
                    }
                    Object object = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)object);
                    JsName jsName = x.getName();
                    if (jsName == null) break block1;
                    object = jsName;
                    Set<JsName> set = this.$names;
                    Object it = object;
                    boolean bl = false;
                    ((Collection)set).add(it);
                }
            }

            public void visitLabel(JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName jsName = x.getName();
                if (jsName != null) {
                    JsName jsName2 = jsName;
                    Set<JsName> set = this.$names;
                    JsName it = jsName2;
                    boolean bl = false;
                    ((Collection)set).add(it);
                }
                super.visitLabel(x);
            }

            public void visitCatch(JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                ((Collection)this.$names).add(x.getParameter().getName());
                super.visitCatch(x);
            }
        }.accept(scope);
        return names2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $this$collectFreeVariables) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectFreeVariables, (String)"<this>");
        JsBlock jsBlock = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        Set<JsName> set = CollectUtilsKt.collectUsedNames(jsBlock);
        JsBlock jsBlock2 = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock2, (String)"getBody(...)");
        Set set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames(jsBlock2));
        List<JsParameter> list2 = $this$collectFreeVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        Iterable iterable = list2;
        Set set3 = set2;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
            collection.add(jsName);
        }
        return SetsKt.minus((Set)set3, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $this$collectLocalVariables, boolean skipLabelsAndCatches) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectLocalVariables, (String)"<this>");
        JsBlock jsBlock = $this$collectLocalVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        Set<JsName> set = CollectUtilsKt.collectDefinedNames(jsBlock, skipLabelsAndCatches);
        List<JsParameter> list2 = $this$collectLocalVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        Iterable iterable = list2;
        Set<JsName> set2 = set;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
            collection.add(jsName);
        }
        return SetsKt.plus(set2, (Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ Set collectLocalVariables$default(JsFunction jsFunction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CollectUtilsKt.collectLocalVariables(jsFunction, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        boolean $i$f$mapValues = false;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            JsFunction jsFunction = ((FunctionWithWrapper)((Pair)it.getValue()).getFirst()).getFunction();
            map3.put(k, jsFunction);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsExpression> collectNamedFunctionsOrMetadata(@NotNull JsNode scope) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        boolean $i$f$mapValues = false;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            JsExpression jsExpression = (JsExpression)((Pair)it.getValue()).getSecond();
            map3.put(k, jsExpression);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            result2.putAll(CollectUtilsKt.collectNamedFunctions(fragment.getDeclarationBlock()));
            result2.putAll(CollectUtilsKt.collectNamedFunctions(fragment.getInitializerBlock()));
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, FunctionWithWrapper> collectNamedFunctionsAndWrappers(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            FunctionWithWrapper functionWithWrapper;
            Map.Entry it;
            Map map;
            Object k;
            Map.Entry it$iv$iv;
            boolean bl;
            Map map2;
            Map $this$mapValuesTo$iv$iv;
            Map map3 = result2;
            Map $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(fragment.getDeclarationBlock());
            boolean $i$f$mapValues = false;
            Map map4 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl2 = false;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map.put(k, functionWithWrapper);
            }
            $this$mapValues$iv = destination$iv$iv;
            map3.putAll($this$mapValues$iv);
            map3 = result2;
            $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(fragment.getInitializerBlock());
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl3 = false;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map.put(k, functionWithWrapper);
            }
            Map map5 = destination$iv$iv;
            map3.putAll(map5);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, Pair<FunctionWithWrapper, JsExpression>> collectNamedFunctionsAndMetadata(@NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Map namedFunctions = new LinkedHashMap();
        scope.accept(new RecursiveJsVisitor(namedFunctions){
            final /* synthetic */ Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $namedFunctions;
            {
                this.$namedFunctions = $namedFunctions;
            }

            public void visitBinaryExpression(JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x);
                if (assignment != null) {
                    JsName name2;
                    JsExpression left = (JsExpression)assignment.component1();
                    JsExpression right = (JsExpression)assignment.component2();
                    if (left instanceof JsNameRef && (name2 = ((JsNameRef)left).getName()) != null) {
                        Intrinsics.checkNotNull((Object)right);
                        FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(right);
                        if (functionWithWrapper != null) {
                            FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                            Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = this.$namedFunctions;
                            FunctionWithWrapper functionWithWrapper3 = functionWithWrapper2;
                            boolean bl = false;
                            JsFunction function2 = functionWithWrapper3.component1();
                            JsBlock wrapper = functionWithWrapper3.component2();
                            map.put(name2, (Pair<FunctionWithWrapper, JsExpression>)new Pair((Object)new FunctionWithWrapper(function2, wrapper), (Object)right));
                        }
                    }
                }
                super.visitBinaryExpression(x);
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer = x.getInitExpression();
                JsName name2 = x.getName();
                if (initializer != null && name2 != null) {
                    FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(initializer);
                    if (functionWithWrapper != null) {
                        FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = this.$namedFunctions;
                        FunctionWithWrapper function2 = functionWithWrapper2;
                        boolean bl = false;
                        map.put(name2, (Pair<FunctionWithWrapper, JsExpression>)new Pair((Object)function2, (Object)initializer));
                    }
                }
                super.visit(x);
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName name2 = x.getName();
                if (name2 != null) {
                    this.$namedFunctions.put(name2, (Pair<FunctionWithWrapper, JsExpression>)new Pair((Object)new FunctionWithWrapper(x, null), (Object)x));
                }
                super.visitFunction(x);
            }
        });
        return namedFunctions;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        HashMap<String, FunctionWithWrapper> accessors2 = new HashMap<String, FunctionWithWrapper>();
        scope.accept(new RecursiveJsVisitor(accessors2){
            final /* synthetic */ HashMap<String, FunctionWithWrapper> $accessors;
            {
                this.$accessors = $accessors;
            }

            public void visitInvocation(JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(invocation);
                if (inlineMetadata != null) {
                    InlineMetadata inlineMetadata2 = inlineMetadata;
                    HashMap<String, FunctionWithWrapper> hashMap = this.$accessors;
                    InlineMetadata it = inlineMetadata2;
                    boolean bl = false;
                    Map map = hashMap;
                    String string2 = it.getTag().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    String string3 = string2;
                    FunctionWithWrapper functionWithWrapper = it.getFunction();
                    map.put(string3, functionWithWrapper);
                }
                super.visitInvocation(invocation);
            }
        });
        return accessors2;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull Iterable<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            result2.putAll(CollectUtilsKt.collectAccessors(fragment.getDeclarationBlock()));
        }
        return result2;
    }

    @NotNull
    public static final Map<CallableDescriptor, FunctionWithWrapper> collectLocalFunctions(@NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        HashMap<CallableDescriptor, FunctionWithWrapper> localFunctions = new HashMap<CallableDescriptor, FunctionWithWrapper>();
        scope.accept(new RecursiveJsVisitor(localFunctions){
            final /* synthetic */ HashMap<CallableDescriptor, FunctionWithWrapper> $localFunctions;
            {
                this.$localFunctions = $localFunctions;
            }

            public void visitInvocation(JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(invocation);
                if (functionWithWrapper != null) {
                    FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                    HashMap<CallableDescriptor, FunctionWithWrapper> hashMap = this.$localFunctions;
                    FunctionWithWrapper it = functionWithWrapper2;
                    boolean bl = false;
                    FunctionDescriptor functionDescriptor = MetadataProperties.getFunctionDescriptor(it.getFunction());
                    if (functionDescriptor != null) {
                        FunctionDescriptor fd = functionDescriptor;
                        boolean bl2 = false;
                        ((Map)hashMap).put(fd, it);
                    }
                }
                super.visitInvocation(invocation);
            }
        });
        return localFunctions;
    }

    @NotNull
    public static final Map<CallableDescriptor, FunctionWithWrapper> collectLocalFunctions(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            result2.putAll(CollectUtilsKt.collectLocalFunctions(fragment.getDeclarationBlock()));
        }
        return result2;
    }

    @Nullable
    public static final FunctionWithWrapper extractFunction(@NotNull JsExpression expression2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2 instanceof JsFunction) {
            object = new FunctionWithWrapper((JsFunction)expression2, null);
        } else {
            object = InlineMetadata.Companion.decompose(expression2);
            if (object == null || (object = ((InlineMetadata)object).getFunction()) == null) {
                object = InlineMetadata.Companion.tryExtractFunction(expression2);
            }
        }
        return object;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        InstanceCollector<JsNode> $this$collectInstances_u24lambda_u246 = new InstanceCollector<JsNode>(klass, false);
        boolean bl = false;
        $this$collectInstances_u24lambda_u246.accept(scope);
        return $this$collectInstances_u24lambda_u246.getCollected();
    }

    @NotNull
    public static final Map<JsContinue, JsStatement> collectBreakContinueTargets(@NotNull JsNode $this$collectBreakContinueTargets) {
        Intrinsics.checkNotNullParameter((Object)$this$collectBreakContinueTargets, (String)"<this>");
        Map targets = new LinkedHashMap();
        $this$collectBreakContinueTargets.accept(new RecursiveJsVisitor(targets){
            private JsStatement defaultBreakTarget;
            private Map<JsName, JsStatement> breakTargets;
            private JsStatement defaultContinueTarget;
            private Map<JsName, JsStatement> continueTargets;
            final /* synthetic */ Map<JsContinue, JsStatement> $targets;
            {
                this.$targets = $targets;
                this.breakTargets = new LinkedHashMap<K, V>();
                this.continueTargets = new LinkedHashMap<K, V>();
            }

            public final JsStatement getDefaultBreakTarget() {
                return this.defaultBreakTarget;
            }

            public final void setDefaultBreakTarget(JsStatement jsStatement) {
                this.defaultBreakTarget = jsStatement;
            }

            public final Map<JsName, JsStatement> getBreakTargets() {
                return this.breakTargets;
            }

            public final void setBreakTargets(Map<JsName, JsStatement> map) {
                Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                this.breakTargets = map;
            }

            public final JsStatement getDefaultContinueTarget() {
                return this.defaultContinueTarget;
            }

            public final void setDefaultContinueTarget(JsStatement jsStatement) {
                this.defaultContinueTarget = jsStatement;
            }

            public final Map<JsName, JsStatement> getContinueTargets() {
                return this.continueTargets;
            }

            public final void setContinueTargets(Map<JsName, JsStatement> map) {
                Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                this.continueTargets = map;
            }

            public void visitLabel(JsLabel x) {
                JsStatement inner;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = inner = x.getStatement();
                if (jsStatement instanceof JsDoWhile) {
                    Intrinsics.checkNotNull((Object)inner);
                    JsStatement jsStatement2 = ((JsDoWhile)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getBody(...)");
                    this.handleLoop(inner, jsStatement2, x.getName());
                } else if (jsStatement instanceof JsWhile) {
                    Intrinsics.checkNotNull((Object)inner);
                    JsStatement jsStatement3 = ((JsWhile)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"getBody(...)");
                    this.handleLoop(inner, jsStatement3, x.getName());
                } else if (jsStatement instanceof JsFor) {
                    Intrinsics.checkNotNull((Object)inner);
                    JsStatement jsStatement4 = ((JsFor)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement4, (String)"getBody(...)");
                    this.handleLoop(inner, jsStatement4, x.getName());
                } else if (jsStatement instanceof JsSwitch) {
                    Intrinsics.checkNotNull((Object)inner);
                    this.handleSwitch((JsSwitch)inner, x.getName());
                } else {
                    JsName jsName = x.getName();
                    JsStatement jsStatement5 = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement5, (String)"getStatement(...)");
                    this.withBreakAndContinue(jsName, jsStatement5, null, (Function0<Unit>)((Function0)new Function0<Unit>(this, inner){
                        final /* synthetic */ collectBreakContinueTargets.1 this$0;
                        final /* synthetic */ JsStatement $inner;
                        {
                            this.this$0 = $receiver;
                            this.$inner = $inner;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.accept((JsNode)this.$inner);
                        }
                    }));
                }
            }

            public void visitWhile(JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getBody(...)");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getBody(...)");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitFor(JsFor x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getBody(...)");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visit(JsSwitch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.handleSwitch(x, null);
            }

            private final void handleSwitch(JsSwitch statement2, JsName label) {
                collectBreakContinueTargets.1.withBreakAndContinue$default(this, label, statement2, null, (Function0)new Function0<Unit>(statement2, this){
                    final /* synthetic */ JsSwitch $statement;
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    {
                        this.$statement = $statement;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEach$iv;
                        List<JsSwitchMember> list2 = this.$statement.getCases();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getCases(...)");
                        Iterable iterable = list2;
                        collectBreakContinueTargets.1 var2_2 = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            JsSwitchMember it = (JsSwitchMember)element$iv;
                            boolean bl = false;
                            var2_2.accept((JsNode)it);
                        }
                    }
                }, 4, null);
            }

            private final void handleLoop(JsStatement loop, JsStatement body2, JsName label) {
                this.withBreakAndContinue(label, loop, loop, (Function0<Unit>)((Function0)new Function0<Unit>(body2, this){
                    final /* synthetic */ JsStatement $body;
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    {
                        this.$body = $body;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$body.accept(this.this$0);
                    }
                }));
            }

            public void visitBreak(JsBreak x) {
                JsStatement jsStatement;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                if (targetLabel == null) {
                    JsStatement jsStatement2 = this.defaultBreakTarget;
                    jsStatement = jsStatement2;
                    Intrinsics.checkNotNull((Object)jsStatement2);
                } else {
                    JsStatement jsStatement3 = this.breakTargets.get(targetLabel);
                    Intrinsics.checkNotNull((Object)jsStatement3);
                    jsStatement = jsStatement3;
                }
                this.$targets.put(x, jsStatement);
            }

            public void visitContinue(JsContinue x) {
                JsStatement jsStatement;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                if (targetLabel == null) {
                    JsStatement jsStatement2 = this.defaultContinueTarget;
                    jsStatement = jsStatement2;
                    Intrinsics.checkNotNull((Object)jsStatement2);
                } else {
                    JsStatement jsStatement3 = this.continueTargets.get(targetLabel);
                    Intrinsics.checkNotNull((Object)jsStatement3);
                    jsStatement = jsStatement3;
                }
                this.$targets.put(x, jsStatement);
            }

            private final void withBreakAndContinue(JsName label, JsStatement breakTargetStatement, JsStatement continueTargetStatement, Function0<Unit> action) {
                JsStatement oldDefaultBreakTarget = this.defaultBreakTarget;
                JsStatement oldDefaultContinueTarget = this.defaultContinueTarget;
                Pair pair = label != null ? new Pair((Object)this.breakTargets.get(label), (Object)this.continueTargets.get(label)) : new Pair(null, null);
                JsStatement oldBreakTarget = (JsStatement)pair.component1();
                JsStatement oldContinueTarget = (JsStatement)pair.component2();
                this.defaultBreakTarget = breakTargetStatement;
                if (label != null) {
                    this.breakTargets.put(label, breakTargetStatement);
                    this.continueTargets.put(label, continueTargetStatement);
                }
                if (continueTargetStatement != null) {
                    this.defaultContinueTarget = continueTargetStatement;
                }
                action.invoke();
                this.defaultBreakTarget = oldDefaultBreakTarget;
                this.defaultContinueTarget = oldDefaultContinueTarget;
                if (label != null) {
                    this.breakTargets.put(label, oldBreakTarget);
                    this.continueTargets.put(label, oldContinueTarget);
                }
            }

            static /* synthetic */ void withBreakAndContinue$default(collectBreakContinueTargets.1 var0, JsName jsName, JsStatement jsStatement, JsStatement jsStatement2, Function0 function0, int n, Object object) {
                if ((n & 4) != 0) {
                    jsStatement2 = null;
                }
                var0.withBreakAndContinue(jsName, jsStatement, jsStatement2, (Function0<Unit>)function0);
            }
        });
        return targets;
    }

    @Nullable
    public static final String getImportTag(@NotNull JsVars jsVars) {
        Intrinsics.checkNotNullParameter((Object)jsVars, (String)"jsVars");
        if (jsVars.getVars().size() == 1) {
            JsVars.JsVar jsVar = jsVars.getVars().get(0);
            JsName jsName = jsVar.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
            if (MetadataProperties.getImported(jsName)) {
                Intrinsics.checkNotNull((Object)jsVar);
                return CollectUtilsKt.extractImportTag(jsVar);
            }
        }
        return null;
    }

    @Nullable
    public static final String extractImportTag(@NotNull JsVars.JsVar jsVar) {
        Intrinsics.checkNotNullParameter((Object)jsVar, (String)"jsVar");
        JsExpression jsExpression = jsVar.getInitExpression();
        if (jsExpression == null) {
            return null;
        }
        JsExpression initExpression = jsExpression;
        StringBuilder sb = new StringBuilder();
        if (initExpression instanceof JsInvocation || initExpression instanceof JsNew) {
            sb.append(jsVar.getName().toString()).append(":");
        }
        return CollectUtilsKt.extractImportTagImpl(initExpression, sb) ? sb.toString() : null;
    }

    private static final boolean extractImportTagImpl(JsExpression expression2, StringBuilder sb) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsNameRef) {
            JsExpression nameRef = expression2;
            if (((JsNameRef)nameRef).getQualifier() != null) {
                JsExpression jsExpression2 = ((JsNameRef)nameRef).getQualifier();
                Intrinsics.checkNotNull((Object)jsExpression2);
                if (!CollectUtilsKt.extractImportTagImpl(jsExpression2, sb)) {
                    return false;
                }
                sb.append('.');
            }
            sb.append(JsToStringGenerationVisitor.javaScriptString(((JsNameRef)nameRef).getIdent()));
            return true;
        }
        if (jsExpression instanceof JsArrayAccess) {
            JsExpression arrayAccess = expression2;
            JsExpression jsExpression3 = ((JsArrayAccess)arrayAccess).getArrayExpression();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"getArrayExpression(...)");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression3, sb)) {
                return false;
            }
            sb.append(".");
            JsExpression jsExpression4 = ((JsArrayAccess)arrayAccess).getIndexExpression();
            JsStringLiteral jsStringLiteral = jsExpression4 instanceof JsStringLiteral ? (JsStringLiteral)jsExpression4 : null;
            if (jsStringLiteral == null) {
                return false;
            }
            JsStringLiteral stringLiteral = jsStringLiteral;
            sb.append(JsToStringGenerationVisitor.javaScriptString(stringLiteral.getValue()));
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression invocation = expression2;
            JsExpression jsExpression5 = ((JsInvocation)invocation).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression5, (String)"getQualifier(...)");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression5, sb)) {
                return false;
            }
            List<JsExpression> list2 = ((JsInvocation)invocation).getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
            return CollectUtilsKt.appendArguments(list2, sb);
        }
        if (jsExpression instanceof JsNew) {
            JsExpression newExpr = expression2;
            JsExpression jsExpression6 = ((JsNew)newExpr).getConstructorExpression();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression6, (String)"getConstructorExpression(...)");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression6, sb)) {
                return false;
            }
            List<JsExpression> list3 = ((JsNew)newExpr).getArguments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getArguments(...)");
            return CollectUtilsKt.appendArguments(list3, sb);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean appendArguments(List<? extends JsExpression> arguments2, StringBuilder sb) {
        Iterable $this$forEachIndexed$iv = arguments2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void arg;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsExpression jsExpression = (JsExpression)item$iv;
            int index2 = n;
            boolean bl = false;
            if (!(arg instanceof JsIntLiteral)) {
                return false;
            }
            sb.append(index2 == 0 ? "(" : ",");
            sb.append(((JsIntLiteral)arg).value);
        }
        sb.append(")");
        return true;
    }
}

