/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SynchronizedByValueChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isValueOrPrimitive", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
@SourceDebugExtension(value={"SMAP\nSynchronizedByValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynchronizedByValueChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/SynchronizedByValueChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1#2:32\n1745#3,3:33\n*S KotlinDebug\n*F\n+ 1 SynchronizedByValueChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/SynchronizedByValueChecker\n*L\n21#1:33,3\n*E\n"})
public final class SynchronizedByValueChecker
implements CallChecker {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValueOrPrimitive(KotlinType $this$isValueOrPrimitive) {
        KotlinType it;
        if (KotlinBuiltIns.isPrimitiveType($this$isValueOrPrimitive)) return true;
        ClassifierDescriptor it2 = $this$isValueOrPrimitive.getConstructor().getDeclarationDescriptor();
        boolean bl = false;
        if (it2 instanceof ClassDescriptor && ((ClassDescriptor)it2).isValue()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        TypeConstructor manyTypes = $this$isValueOrPrimitive.getConstructor();
        boolean bl3 = false;
        if (!(manyTypes instanceof IntegerLiteralTypeConstructor)) return false;
        Iterable $this$any$iv = ((IntegerLiteralTypeConstructor)manyTypes).getPossibleTypes();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KotlinType)element$iv;
            boolean bl4 = false;
        } while (!this.isValueOrPrimitive(it));
        return true;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
                Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Object obj = resolvedCall2.getResultingDescriptor();
                if (!(obj != null ? DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)obj, "synchronized", "kotlin") : false)) {
                    return;
                }
                ValueArgument valueArgument = resolvedCall2.getValueArgumentsByIndex();
                if (valueArgument == null || (valueArgument = valueArgument.get(0)) == null || (valueArgument = valueArgument.getArguments()) == null || (valueArgument = (ValueArgument)CollectionsKt.firstOrNull(valueArgument)) == null) {
                    return;
                }
                ValueArgument argument2 = valueArgument;
                object = argument2.getArgumentExpression();
                if (object == null) break block6;
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if ((object = CallUtilKt.getType(object, bindingContext)) != null) break block7;
            }
            return;
        }
        Object type2 = object;
        if (this.isValueOrPrimitive((KotlinType)type2)) {
            context.getTrace().report(Errors.FORBIDDEN_SYNCHRONIZED_BY_VALUE_CLASSES_OR_PRIMITIVES.on(reportOn, (KotlinType)type2));
        }
    }
}

