/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.SuspendLimitationsCheckerKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SuspendLimitationsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "UNSUPPORTED_OPERATOR_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nSuspendLimitationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendLimitationsChecker.kt\norg/jetbrains/kotlin/resolve/checkers/SuspendLimitationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1745#2,3:59\n*S KotlinDebug\n*F\n+ 1 SuspendLimitationsChecker.kt\norg/jetbrains/kotlin/resolve/checkers/SuspendLimitationsChecker\n*L\n47#1:59,3\n*E\n"})
public final class SuspendLimitationsChecker
implements DeclarationChecker {
    @NotNull
    public static final SuspendLimitationsChecker INSTANCE = new SuspendLimitationsChecker();
    @NotNull
    private static final Set<Name> UNSUPPORTED_OPERATOR_NAMES;

    private SuspendLimitationsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block8: {
            boolean bl;
            KtModifierList it;
            block7: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend()) {
                    return;
                }
                if (((FunctionDescriptor)descriptor2).isOperator() && UNSUPPORTED_OPERATOR_NAMES.contains(((FunctionDescriptor)descriptor2).getName())) {
                    KtModifierList ktModifierList = declaration.getModifierList();
                    if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.OPERATOR_KEYWORD)) != null) {
                        it = ktModifierList;
                        boolean bl2 = false;
                        context.getTrace().report(Errors.UNSUPPORTED.on((PsiElement)it, "suspend operator \"" + ((FunctionDescriptor)descriptor2).getName() + '\"'));
                    }
                }
                Iterable $this$any$iv = descriptor2.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor p0 = (AnnotationDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!SuspendLimitationsCheckerKt.access$isKotlinTestAnnotation(p0)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) break block8;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) != null) {
                it = ktModifierList;
                boolean bl4 = false;
                context.getTrace().report(Errors.UNSUPPORTED_SUSPEND_TEST.on((PsiElement)it));
            }
        }
    }

    static {
        Object[] objectArray = new Name[]{OperatorNameConventions.CONTAINS, OperatorNameConventions.GET, OperatorNameConventions.SET, OperatorNameConventions.PROVIDE_DELEGATE, OperatorNameConventions.GET_VALUE, OperatorNameConventions.SET_VALUE};
        UNSUPPORTED_OPERATOR_NAMES = SetsKt.setOf((Object[])objectArray);
    }
}

