/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewVariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J4\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ValueParameterUsageInDefaultArgumentChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "allParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "declaredParameters", "frontend"})
public final class ValueParameterUsageInDefaultArgumentChecker
implements DeclarationChecker {
    @NotNull
    public static final ValueParameterUsageInDefaultArgumentChecker INSTANCE = new ValueParameterUsageInDefaultArgumentChecker();

    private ValueParameterUsageInDefaultArgumentChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(declaration instanceof KtFunction) || !(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        List<ValueParameterDescriptor> allParameters = list2;
        List declaredParameters2 = new ArrayList();
        List list3 = ((KtFunction)declaration).getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
        for (Pair pair : CollectionsKt.dropLast((List)CollectionsKt.zip((Iterable)list3, (Iterable)allParameters), (int)1)) {
            KtParameter parameter = (KtParameter)pair.component1();
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)pair.component2();
            Intrinsics.checkNotNull((Object)parameter);
            this.checkParameter(parameter, allParameters, declaredParameters2, context);
            ((Collection)declaredParameters2).add(parameterDescriptor);
        }
    }

    private final void checkParameter(KtParameter parameter, List<? extends ValueParameterDescriptor> allParameters, List<? extends ValueParameterDescriptor> declaredParameters2, DeclarationCheckerContext context) {
        KtExpression ktExpression = parameter.getDefaultValue();
        if (ktExpression == null) {
            return;
        }
        KtExpression defaultValue = ktExpression;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        KtVisitorVoid visitor2 = new KtVisitorVoid(bindingContext2, allParameters, declaredParameters2, context){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ List<ValueParameterDescriptor> $allParameters;
            final /* synthetic */ List<ValueParameterDescriptor> $declaredParameters;
            final /* synthetic */ DeclarationCheckerContext $context;
            {
                this.$bindingContext = $bindingContext;
                this.$allParameters = $allParameters;
                this.$declaredParameters = $declaredParameters;
                this.$context = $context;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitSimpleNameExpression(KtSimpleNameExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)expression2, this.$bindingContext);
                CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                ValueParameterDescriptor valueParameterDescriptor = callableDescriptor instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)callableDescriptor : null;
                if (valueParameterDescriptor == null) {
                    return;
                }
                ValueParameterDescriptor resolvedDescriptor = valueParameterDescriptor;
                this.checkParameter(expression2, resolvedDescriptor);
            }

            public void visitCallExpression(KtCallExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)expression2, this.$bindingContext);
                if (resolvedCall2 instanceof NewVariableAsFunctionResolvedCallImpl) {
                    ValueParameterDescriptor descriptor2;
                    KtExpression ktExpression = expression2.getCalleeExpression();
                    KtSimpleNameExpression calleeExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
                    D d = ((NewVariableAsFunctionResolvedCallImpl)resolvedCall2).getVariableCall().getResultingDescriptor();
                    ValueParameterDescriptor valueParameterDescriptor = descriptor2 = d instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)d : null;
                    if (calleeExpression != null && descriptor2 != null) {
                        this.checkParameter(calleeExpression, descriptor2);
                    }
                }
                expression2.acceptChildren((PsiElementVisitor)this);
            }

            private final void checkParameter(KtSimpleNameExpression expression2, ValueParameterDescriptor descriptor2) {
                if (this.$allParameters.contains(descriptor2) && !this.$declaredParameters.contains(descriptor2)) {
                    DiagnosticFactory1<KtSimpleNameExpression, ValueParameterDescriptor> diagnosticFactory1;
                    boolean bl = this.$context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitIllegalValueParameterUsageInDefaultArguments);
                    if (bl) {
                        diagnosticFactory1 = Errors.UNINITIALIZED_PARAMETER;
                    } else if (!bl) {
                        diagnosticFactory1 = Errors.UNINITIALIZED_PARAMETER_WARNING;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    DiagnosticFactory1<KtSimpleNameExpression, ValueParameterDescriptor> factory = diagnosticFactory1;
                    this.$context.getTrace().report(factory.on((KtSimpleNameExpression)((PsiElement)expression2), descriptor2));
                }
            }
        };
        defaultValue.acceptChildren((PsiElementVisitor)visitor2);
    }
}

