/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.KotlinMetadataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPartProvider;
import org.jetbrains.kotlin.serialization.deserialization.MetadataUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializedPackageFragment;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "metadataPartProvider", "Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;", "finder", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder;", "components", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "memberScope", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "computeMemberScope", "getMemberScope", "hasTopLevelClass", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "initialize", "", "Companion", "deserialization"})
public final class MetadataPackageFragment
extends DeserializedPackageFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataPartProvider metadataPartProvider;
    @NotNull
    private final KotlinMetadataFinder finder;
    @NotNull
    private final MetadataClassDataFinder classDataFinder;
    private DeserializationComponents components;
    @NotNull
    private final NotNullLazyValue<MemberScope> memberScope;
    @NotNull
    public static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    @NotNull
    public static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";

    public MetadataPackageFragment(@NotNull FqName fqName2, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module2, @NotNull MetadataPartProvider metadataPartProvider, @NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)metadataPartProvider, (String)"metadataPartProvider");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        super(fqName2, storageManager, module2);
        this.metadataPartProvider = metadataPartProvider;
        this.finder = finder;
        this.classDataFinder = new MetadataClassDataFinder(this.finder);
        this.memberScope = storageManager.createLazyValue((Function0)new Function0<MemberScope>(this){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MemberScope invoke() {
                return MetadataPackageFragment.access$computeMemberScope(this.this$0);
            }
        });
    }

    @NotNull
    public MetadataClassDataFinder getClassDataFinder() {
        return this.classDataFinder;
    }

    @Override
    public void initialize(@NotNull DeserializationComponents components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.components = components;
    }

    private final MemberScope computeMemberScope() {
        DeserializationComponents deserializationComponents;
        String string2 = this.getFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        List packageParts2 = this.metadataPartProvider.findMetadataPackageParts(string2);
        ArrayList<DeserializedPackageMemberScope> scopes = new ArrayList<DeserializedPackageMemberScope>();
        for (String partName : packageParts2) {
            InputStream stream;
            FqName fqName2 = this.getFqName();
            Name name2 = Name.identifier((String)partName);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            if (this.finder.findMetadata(new ClassId(fqName2, name2)) == null) continue;
            deserializationComponents = MetadataUtilKt.readProto((InputStream)stream);
            ProtoBuf.PackageFragment proto = (ProtoBuf.PackageFragment)deserializationComponents.component1();
            NameResolverImpl nameResolver2 = (NameResolverImpl)deserializationComponents.component2();
            BuiltInsBinaryVersion version2 = (BuiltInsBinaryVersion)deserializationComponents.component3();
            PackageFragmentDescriptor packageFragmentDescriptor = this;
            ProtoBuf.Package package_ = proto.getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
            NameResolver nameResolver3 = (NameResolver)nameResolver2;
            BinaryVersion binaryVersion = (BinaryVersion)version2;
            DeserializationComponents deserializationComponents2 = this.components;
            if (deserializationComponents2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"components");
                deserializationComponents2 = null;
            }
            scopes.add(new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, nameResolver3, binaryVersion, null, deserializationComponents2, "scope with top-level callables and type aliases (no classes) for package part " + partName + " of " + this, (Function0<? extends Collection<Name>>)((Function0)computeMemberScope.1.INSTANCE)));
        }
        ProtoBuf.Package package_ = ProtoBuf.Package.getDefaultInstance();
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"getDefaultInstance(...)");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getDefaultInstance(...)");
        NameResolverImpl nameResolverImpl = new NameResolverImpl(stringTable, qualifiedNameTable);
        BuiltInsBinaryVersion builtInsBinaryVersion = BuiltInsBinaryVersion.INSTANCE;
        DeserializationComponents deserializationComponents3 = this.components;
        if (deserializationComponents3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            deserializationComponents3 = null;
        }
        deserializationComponents = deserializationComponents3;
        String string3 = "scope for all classes of " + this;
        computeMemberScope.3 var8_8 = computeMemberScope.3.INSTANCE;
        scopes.add(new DeserializedPackageMemberScope(this, package_, nameResolverImpl, builtInsBinaryVersion, deserializationComponents, string3, var8_8){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
                PackageFragmentDescriptor packageFragmentDescriptor = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super(packageFragmentDescriptor, $super_call_param$1, (NameResolver)$super_call_param$2, (BinaryVersion)$super_call_param$3, null, $super_call_param$4, $super_call_param$5, (Function0<? extends Collection<Name>>)((Function0)$super_call_param$6));
            }

            protected boolean hasClass(Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.this$0.hasTopLevelClass(name2);
            }

            public boolean definitelyDoesNotContainName(Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return false;
            }

            public Set<Name> getClassifierNames() {
                return null;
            }

            protected Set<Name> getNonDeclaredClassifierNames() {
                return null;
            }
        });
        return ChainedMemberScope.Companion.create(".kotlin_metadata parts scope of " + this, (Iterable<? extends MemberScope>)scopes);
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        return (MemberScope)this.memberScope.invoke();
    }

    @Override
    public boolean hasTopLevelClass(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return true;
    }

    public static final /* synthetic */ MemberScope access$computeMemberScope(MetadataPackageFragment $this) {
        return $this.computeMemberScope();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment$Companion;", "", "()V", "DOT_METADATA_FILE_EXTENSION", "", "METADATA_FILE_EXTENSION", "deserialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

