/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionFormat;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportSettings;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlExporter;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlResourceSavingSettings;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u001c\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J8\u0010\u001c\u001a\u00020\n*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#0\"H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "()V", "formatDescription", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormatDescription", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "state", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$DialogState;", "addSettingsListeners", "", "project", "Lcom/intellij/openapi/project/Project;", "resourceDirField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "createResourceDirField", "suggestedTargetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "exportFile", "mdFile", "outputFile", "", "saveSettings", "validate", "file", "createSettingsComponent", "Lcom/intellij/ui/dsl/builder/RowsRange;", "Lcom/intellij/ui/dsl/builder/Panel;", "saveHtml", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "path", "resDirPath", "Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;", "resultCallback", "Ljava/util/function/BiConsumer;", "", "Companion", "DialogState", "SaveSettingsListener", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownHtmlExportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownHtmlExportProvider.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,177:1\n43#2,3:178\n43#2,3:181\n*S KotlinDebug\n*F\n+ 1 MarkdownHtmlExportProvider.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider\n*L\n52#1:178,3\n137#1:181,3\n*E\n"})
public final class MarkdownHtmlExportProvider
implements MarkdownExportProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DialogState state = new DialogState(false, null, 3, null);
    @NotNull
    private static final String IMAGE_DIR_RESENT_KEYS = "ImportExportFile.ImageDir.RECENT_KEYS";
    @NotNull
    private static final MarkdownFileActionFormat format = new MarkdownFileActionFormat("HTML", "html");

    @Override
    @NotNull
    public MarkdownFileActionFormat getFormatDescription() {
        return format;
    }

    @Override
    public void exportFile(@NotNull Project project, @NotNull VirtualFile mdFile, @NotNull String outputFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mdFile, (String)"mdFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        this.saveSettings(project);
        MarkdownPreviewFileEditor markdownPreviewFileEditor = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, mdFile, true);
        if (markdownPreviewFileEditor == null) {
            return;
        }
        MarkdownPreviewFileEditor preview = markdownPreviewFileEditor;
        Object object = (WeakReference)preview.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER);
        if (object == null || (object = (MarkdownHtmlPanel)((Reference)object).get()) == null) {
            return;
        }
        Object htmlPanel = object;
        if (htmlPanel instanceof MarkdownJCEFHtmlPanel) {
            boolean $i$f$service = false;
            Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            this.saveHtml((MarkdownJCEFHtmlPanel)htmlPanel, outputFile, ((MarkdownHtmlExportSettings)object2).getResourceSavingSettings(), project, (arg_0, arg_1) -> MarkdownHtmlExportProvider.exportFile$lambda$0(project, arg_0, arg_1));
        }
    }

    @Override
    @Nullable
    public String validate(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MarkdownPreviewFileEditor preview = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, file, true);
        if (preview == null || !MarkdownImportExportUtils.INSTANCE.isJCEFPanelOpen(preview)) {
            Object[] objectArray = new Object[]{this.getFormatDescription().getFormatName()};
            return MarkdownBundle.message("markdown.export.validation.failure.msg", objectArray);
        }
        return null;
    }

    @Override
    @NotNull
    public RowsRange createSettingsComponent(@NotNull Panel $this$createSettingsComponent, @NotNull Project project, @NotNull VirtualFile suggestedTargetFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createSettingsComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestedTargetFile, (String)"suggestedTargetFile");
        TextFieldWithHistoryWithBrowseButton resourceDirField = this.createResourceDirField(project, suggestedTargetFile);
        return $this$createSettingsComponent.rowsRange((Function1)new Function1<Panel, Unit>(resourceDirField, this, project){
            final /* synthetic */ TextFieldWithHistoryWithBrowseButton $resourceDirField;
            final /* synthetic */ MarkdownHtmlExportProvider this$0;
            final /* synthetic */ Project $project;
            {
                this.$resourceDirField = $resourceDirField;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$rowsRange) {
                Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
                Panel.row$default((Panel)$this$rowsRange, null, (Function1)((Function1)new Function1<Row, Unit>(this.$resourceDirField, this.this$0, this.$project){
                    final /* synthetic */ TextFieldWithHistoryWithBrowseButton $resourceDirField;
                    final /* synthetic */ MarkdownHtmlExportProvider this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.$resourceDirField = $resourceDirField;
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = MarkdownBundle.message("markdown.export.to.html.save.images.checkbox", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        JBCheckBox saveImagesCheckbox2 = (JBCheckBox)$this$row.checkBox(string).onChanged((Function1)new Function1<JBCheckBox, Unit>(this.this$0, this.$project){
                            final /* synthetic */ MarkdownHtmlExportProvider this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                MarkdownHtmlExportProvider.access$setState$p(this.this$0, DialogState.copy$default(MarkdownHtmlExportProvider.access$getState$p(this.this$0), it.isEnabled(), null, 2, null));
                                MarkdownHtmlExportProvider.access$saveSettings(this.this$0, this.$project);
                            }
                        }).gap(RightGap.SMALL).applyToComponent((Function1)createSettingsComponent.saveImagesCheckbox.2.INSTANCE).getComponent();
                        $this$row.cell((JComponent)this.$resourceDirField).onChanged((Function1)new Function1<TextFieldWithHistoryWithBrowseButton, Unit>(this.this$0){
                            final /* synthetic */ MarkdownHtmlExportProvider this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull TextFieldWithHistoryWithBrowseButton it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DialogState dialogState = MarkdownHtmlExportProvider.access$getState$p(this.this$0);
                                String string = it.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                MarkdownHtmlExportProvider.access$setState$p(this.this$0, DialogState.copy$default(dialogState, false, string, 1, null));
                            }
                        }).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)createSettingsComponent.2.INSTANCE).focused().enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)saveImagesCheckbox2)));
                        MarkdownHtmlExportProvider.access$addSettingsListeners(this.this$0, this.$project, this.$resourceDirField);
                    }
                }), (int)1, null);
            }
        });
    }

    private final TextFieldWithHistoryWithBrowseButton createResourceDirField(Project project, VirtualFile suggestedTargetFile) {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        TextFieldWithHistoryWithBrowseButton $this$createResourceDirField_u24lambda_u241 = textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        boolean bl = false;
        $this$createResourceDirField_u24lambda_u241.setTextFieldPreferredWidth(70);
        List resDirRecent = RecentsManager.getInstance((Project)project).getRecentEntries(IMAGE_DIR_RESENT_KEYS);
        if (resDirRecent != null) {
            ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u241.getChildComponent()).setHistory(resDirRecent);
        }
        String[] stringArray = new String[]{suggestedTargetFile.getParent().getPath(), suggestedTargetFile.getNameWithoutExtension()};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String suggestedDir = string;
        if (resDirRecent == null && ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u241.getChildComponent()).getHistory().isEmpty()) {
            ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u241.getChildComponent()).setHistory(CollectionsKt.listOf((Object)suggestedDir));
        }
        ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u241.getChildComponent()).setText(suggestedDir);
        this.state = DialogState.copy$default(this.state, false, suggestedDir, 1, null);
        $this$createResourceDirField_u24lambda_u241.addBrowseFolderListener(MarkdownBundle.message("markdown.import.export.dialog.target.directory", new Object[0]), MarkdownBundle.message("markdown.import.export.dialog.target.directory.description", new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        return textFieldWithHistoryWithBrowseButton;
    }

    private final void addSettingsListeners(Project project, TextFieldWithHistoryWithBrowseButton resourceDirField) {
        ((TextFieldWithHistory)resourceDirField.getChildComponent()).getTextEditor().addFocusListener(new SaveSettingsListener(project));
    }

    private final void saveSettings(Project project) {
        String imageDir = this.state.getResourcesDir();
        boolean $i$f$service = false;
        Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        MarkdownHtmlExportSettings exportSettings = (MarkdownHtmlExportSettings)object;
        exportSettings.setSaveResources(this.state.getSaveImages());
        exportSettings.setResourceDirectory(imageDir);
        RecentsManager.getInstance((Project)project).registerRecentEntry(IMAGE_DIR_RESENT_KEYS, imageDir);
    }

    private final void saveHtml(MarkdownJCEFHtmlPanel $this$saveHtml, String path, HtmlResourceSavingSettings resDirPath, Project project, BiConsumer<String, Boolean> resultCallback) {
        $this$saveHtml.getCefBrowser().getSource(arg_0 -> MarkdownHtmlExportProvider.saveHtml$lambda$2(path, resDirPath, project, resultCallback, arg_0));
    }

    private static final void exportFile$lambda$0(Project $project, String path, Boolean ok) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ok, (String)"ok");
        if (ok.booleanValue()) {
            VirtualFile file = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            if (file != null) {
                MarkdownImportExportUtils.INSTANCE.notifyAndRefreshIfExportSuccess(file, $project);
            }
        } else {
            Object[] objectArray = new Object[]{new File(path).getName()};
            String string = MarkdownBundle.message("markdown.export.failure.msg", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, $project, "markdown.export.failed", null, string, 4, null);
        }
    }

    private static final void saveHtml$lambda$2(String $path, HtmlResourceSavingSettings $resDirPath, Project $project, BiConsumer $resultCallback, String source) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$resDirPath, (String)"$resDirPath");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$resultCallback, (String)"$resultCallback");
        try {
            File file = new File($path);
            Intrinsics.checkNotNull((Object)source);
            new HtmlExporter(source, $resDirPath, $project, file).export();
            $resultCallback.accept($path, true);
        }
        catch (Exception e) {
            $resultCallback.accept($path, false);
        }
    }

    @NotNull
    public static final MarkdownFileActionFormat getFormat() {
        return Companion.getFormat();
    }

    public static final /* synthetic */ void access$setState$p(MarkdownHtmlExportProvider $this, DialogState dialogState) {
        $this.state = dialogState;
    }

    public static final /* synthetic */ void access$addSettingsListeners(MarkdownHtmlExportProvider $this, Project project, TextFieldWithHistoryWithBrowseButton resourceDirField) {
        $this.addSettingsListeners(project, resourceDirField);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$Companion;", "", "()V", "IMAGE_DIR_RESENT_KEYS", "", "Lorg/jetbrains/annotations/NonNls;", "format", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormat$annotations", "getFormat", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownFileActionFormat getFormat() {
            return format;
        }

        @JvmStatic
        public static /* synthetic */ void getFormat$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$DialogState;", "", "saveImages", "", "resourcesDir", "", "(ZLjava/lang/String;)V", "getResourcesDir", "()Ljava/lang/String;", "getSaveImages", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.markdown"})
    private static final class DialogState {
        private final boolean saveImages;
        @NotNull
        private final String resourcesDir;

        public DialogState(boolean saveImages, @NotNull String resourcesDir) {
            Intrinsics.checkNotNullParameter((Object)resourcesDir, (String)"resourcesDir");
            this.saveImages = saveImages;
            this.resourcesDir = resourcesDir;
        }

        public /* synthetic */ DialogState(boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                string = "";
            }
            this(bl, string);
        }

        public final boolean getSaveImages() {
            return this.saveImages;
        }

        @NotNull
        public final String getResourcesDir() {
            return this.resourcesDir;
        }

        public final boolean component1() {
            return this.saveImages;
        }

        @NotNull
        public final String component2() {
            return this.resourcesDir;
        }

        @NotNull
        public final DialogState copy(boolean saveImages, @NotNull String resourcesDir) {
            Intrinsics.checkNotNullParameter((Object)resourcesDir, (String)"resourcesDir");
            return new DialogState(saveImages, resourcesDir);
        }

        public static /* synthetic */ DialogState copy$default(DialogState dialogState, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = dialogState.saveImages;
            }
            if ((n & 2) != 0) {
                string = dialogState.resourcesDir;
            }
            return dialogState.copy(bl, string);
        }

        @NotNull
        public String toString() {
            return "DialogState(saveImages=" + this.saveImages + ", resourcesDir=" + this.resourcesDir + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.saveImages);
            result2 = result2 * 31 + this.resourcesDir.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DialogState)) {
                return false;
            }
            DialogState dialogState = (DialogState)other;
            if (this.saveImages != dialogState.saveImages) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.resourcesDir, (Object)dialogState.resourcesDir);
        }

        public DialogState() {
            this(false, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$SaveSettingsListener;", "Ljava/awt/event/FocusListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;Lcom/intellij/openapi/project/Project;)V", "focusGained", "", "e", "Ljava/awt/event/FocusEvent;", "focusLost", "intellij.markdown"})
    private final class SaveSettingsListener
    implements FocusListener {
        @NotNull
        private final Project project;

        public SaveSettingsListener(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void focusGained(@Nullable FocusEvent e) {
        }

        @Override
        public void focusLost(@Nullable FocusEvent e) {
            FocusEvent focusEvent = e;
            Component component = focusEvent != null ? focusEvent.getComponent() : null;
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JTextField");
            JTextField textEditor = (JTextField)component;
            if (MarkdownHtmlExportProvider.this.state.getSaveImages()) {
                String string = textEditor.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (((CharSequence)string).length() > 0) {
                    MarkdownHtmlExportProvider.this.saveSettings(this.project);
                }
            }
        }
    }
}

