/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings;

import com.intellij.ide.startup.importSettings.DefaultTransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.TransferSettingsDataProvider;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsListener;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.models.IdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.TransferSettingsModel;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsPerformContext;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.testProvider.TestTransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vscode.VSCodeTransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vsmac.VSMacTransferSettingsProvider;
import com.intellij.ide.startup.importSettings.ui.TransferSettingsProgressIndicatorBase;
import com.intellij.ide.startup.importSettings.ui.TransferSettingsView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/startup/importSettings/TransferSettingsDemoDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "config", "Lcom/intellij/ide/startup/importSettings/DefaultTransferSettingsConfiguration;", "model", "Lcom/intellij/ide/startup/importSettings/models/TransferSettingsModel;", "pnl", "Lcom/intellij/ide/startup/importSettings/ui/TransferSettingsView;", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nTransferSettingsDemoAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransferSettingsDemoAction.kt\ncom/intellij/ide/startup/importSettings/TransferSettingsDemoDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
final class TransferSettingsDemoDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultTransferSettingsConfiguration config;
    @NotNull
    private final TransferSettingsModel model;
    @NotNull
    private final TransferSettingsView pnl;

    public TransferSettingsDemoDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        TransferSettingsProvider[] transferSettingsProviderArray = new TransferSettingsProvider[]{new TestTransferSettingsProvider(), new VSCodeTransferSettingsProvider(), new VSMacTransferSettingsProvider()};
        this.config = new DefaultTransferSettingsConfiguration(new TransferSettingsDataProvider(transferSettingsProviderArray), false);
        this.model = new TransferSettingsModel(this.config, true);
        this.pnl = new TransferSettingsView(this.config, this.model);
        this.init();
        this.setSize(640, 480);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel;
        JPanel $this$createCenterPanel_u24lambda_u243 = jPanel = new JPanel();
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u243.setLayout(new BoxLayout($this$createCenterPanel_u24lambda_u243, 3));
        JLabel status = new JLabel("No yet status");
        JProgressBar progressBar = new JProgressBar(0, 100);
        JLabel $this$createCenterPanel_u24lambda_u243_u24lambda_u240 = jLabel = new JLabel();
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u243_u24lambda_u240.setVisible(false);
        JLabel successOrFailureLabel = jLabel;
        TransferSettingsProgressIndicatorBase progressBase = new TransferSettingsProgressIndicatorBase(progressBar, status, $this$createCenterPanel_u24lambda_u243);
        JButton $this$createCenterPanel_u24lambda_u243_u24lambda_u242 = jButton = new JButton("Import");
        boolean bl3 = false;
        $this$createCenterPanel_u24lambda_u243_u24lambda_u242.addActionListener(arg_0 -> TransferSettingsDemoDialog.createCenterPanel$lambda$3$lambda$2$lambda$1(this, progressBase, arg_0));
        JButton btn = jButton;
        this.config.getController().addListener(new TransferSettingsListener(this, successOrFailureLabel, btn, progressBar){
            final /* synthetic */ TransferSettingsDemoDialog this$0;
            final /* synthetic */ JLabel $successOrFailureLabel;
            final /* synthetic */ JButton $btn;
            final /* synthetic */ JProgressBar $progressBar;
            {
                this.this$0 = $receiver;
                this.$successOrFailureLabel = $successOrFailureLabel;
                this.$btn = $btn;
                this.$progressBar = $progressBar;
            }

            public void importStarted(@NotNull IdeVersion ideVersion, @NotNull Settings settings) {
                Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.this$0.close(0);
            }

            public void importFailed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$successOrFailureLabel.setVisible(true);
                this.$successOrFailureLabel.setText("Failed");
                this.$btn.setEnabled(true);
            }

            public void importPerformed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull TransferSettingsPerformContext context2) {
                Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                this.$successOrFailureLabel.setVisible(true);
                this.$successOrFailureLabel.setText("Success");
                this.$progressBar.setVisible(false);
            }
        });
        $this$createCenterPanel_u24lambda_u243.add(this.pnl.getPanel());
        $this$createCenterPanel_u24lambda_u243.add(status);
        $this$createCenterPanel_u24lambda_u243.add(successOrFailureLabel);
        $this$createCenterPanel_u24lambda_u243.add(progressBar);
        $this$createCenterPanel_u24lambda_u243.add(btn);
        return jPanel;
    }

    private static final void createCenterPanel$lambda$3$lambda$2$lambda$1(TransferSettingsDemoDialog this$0, TransferSettingsProgressIndicatorBase $progressBase, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$progressBase), (String)"$progressBase");
        BaseIdeVersion baseIdeVersion = this$0.pnl.getSelectedIde();
        IdeVersion ideVersion = baseIdeVersion instanceof IdeVersion ? (IdeVersion)baseIdeVersion : null;
        if (ideVersion == null) {
            throw new IllegalStateException("Selected ide is null or not IdeVersion".toString());
        }
        IdeVersion selectedIde = ideVersion;
        this$0.config.getController().performImport(this$0.project, selectedIde, (ProgressIndicator)$progressBase);
    }
}

