/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.settingChooser;

import com.intellij.ide.startup.importSettings.chooser.settingChooser.CBRenderer;
import com.intellij.ide.startup.importSettings.chooser.settingChooser.ChildItem;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/settingChooser/ChildSettingsList;", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/ide/startup/importSettings/chooser/settingChooser/ChildItem;", "settings", "", "configurable", "", "changeHandler", "Lkotlin/Function0;", "", "(Ljava/util/List;ZLkotlin/jvm/functions/Function0;)V", "getSettings", "()Ljava/util/List;", "intellij.ide.startup.importSettings"})
public final class ChildSettingsList
extends JBList<ChildItem> {
    @NotNull
    private final List<ChildItem> settings;

    public ChildSettingsList(@NotNull List<ChildItem> settings, boolean configurable, final @NotNull Function0<Unit> changeHandler) {
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Intrinsics.checkNotNullParameter(changeHandler, (String)"changeHandler");
        super((ListModel)JBList.createDefaultListModel((Iterable)settings));
        this.settings = settings;
        this.setCellRenderer(new CBRenderer(configurable));
        if (configurable) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int index = this.locationToIndex(e.getPoint());
                    if (index >= 0 && this.getSettings().size() > index) {
                        ChildItem settingItem;
                        settingItem.setSelected(!(settingItem = this.getSettings().get(index)).getSelected());
                        this.repaint();
                        changeHandler.invoke();
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(@NotNull KeyEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SpeedSearchSupply supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)((Object)this)));
                    if (supply != null && supply.isPopupActive()) {
                        return;
                    }
                    if (e.getKeyChar() == ' ') {
                        int[] nArray = this.getSelectedIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedIndices(...)");
                        for (int index : nArray) {
                            ChildItem settingItem;
                            if (index < 0 || this.getSettings().size() <= index) continue;
                            settingItem.setSelected(!(settingItem = this.getSettings().get(index)).getSelected());
                            this.repaint();
                            changeHandler.invoke();
                        }
                    }
                }
            });
        }
    }

    @NotNull
    public final List<ChildItem> getSettings() {
        return this.settings;
    }
}

