/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.importProgress.ImportProgressPage;
import com.intellij.ide.startup.importSettings.chooser.productChooser.ProductChooserPage;
import com.intellij.ide.startup.importSettings.chooser.settingChooser.SettingChooserPage;
import com.intellij.ide.startup.importSettings.chooser.ui.BaseControllerImpl;
import com.intellij.ide.startup.importSettings.chooser.ui.ImportSettingsController;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingDialog;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingPage;
import com.intellij.ide.startup.importSettings.data.ActionsDataProvider;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.NotificationData;
import com.intellij.ide.startup.importSettings.data.SettingsContributor;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\u001c\u0010\u0010\u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsControllerImpl;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsController;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/BaseControllerImpl;", "dialog", "Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;", "skipImportAction", "Lkotlin/Function0;", "", "(Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;Lkotlin/jvm/functions/Function0;)V", "getSkipImportAction", "()Lkotlin/jvm/functions/Function0;", "configChosen", "goToImportPage", "importFromProduct", "Lcom/intellij/ide/startup/importSettings/data/DialogImportData;", "goToProductChooserPage", "goToSettingsPage", "provider", "Lcom/intellij/ide/startup/importSettings/data/ActionsDataProvider;", "product", "Lcom/intellij/ide/startup/importSettings/data/SettingsContributor;", "skipImport", "intellij.ide.startup.importSettings"})
final class ImportSettingsControllerImpl
extends BaseControllerImpl
implements ImportSettingsController {
    @NotNull
    private final Function0<Unit> skipImportAction;

    public ImportSettingsControllerImpl(final @NotNull OnboardingDialog dialog2, @NotNull Function0<Unit> skipImportAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        Intrinsics.checkNotNullParameter(skipImportAction, (String)"skipImportAction");
        super(dialog2);
        this.skipImportAction = skipImportAction;
        SettingsService settService = SettingsService.Companion.getInstance();
        settService.getDoClose().advise(this.getLifetime(), (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                dialog2.dialogClose();
            }
        });
        settService.getError().advise(this.getLifetime(), (Function1)new Function1<NotificationData, Unit>(){

            public final void invoke(@NotNull NotificationData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                dialog2.showError(it);
            }
        });
    }

    @Override
    @NotNull
    public Function0<Unit> getSkipImportAction() {
        return this.skipImportAction;
    }

    @Override
    public void goToSettingsPage(@NotNull ActionsDataProvider<?> provider2, @NotNull SettingsContributor product) {
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        OnboardingPage page = SettingChooserPage.Companion.createPage(provider2, product, this);
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page);
        this.getDialog().changePage(page);
    }

    @Override
    public void goToProductChooserPage() {
        ProductChooserPage page = new ProductChooserPage(this);
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page);
        this.getDialog().changePage(page);
    }

    @Override
    public void goToImportPage(@NotNull DialogImportData importFromProduct) {
        Intrinsics.checkNotNullParameter((Object)importFromProduct, (String)"importFromProduct");
        ImportProgressPage page = new ImportProgressPage(importFromProduct, this);
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page);
        this.getDialog().changePage(page);
    }

    @Override
    public void skipImport() {
        this.getDialog().dialogClose();
    }

    @Override
    public void configChosen() {
        SettingsService.Companion.getInstance().configChosen();
    }
}

