/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.ui.BannerOverlay;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingPage;
import com.intellij.ide.startup.importSettings.chooser.ui.WizardPageTracker;
import com.intellij.ide.startup.importSettings.data.NotificationData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.ide.bootstrap.StartupWizardStage;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tJ#\u0010\u0012\u001a\u00020\u00132\u000b\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J!\u0010\u0018\u001a\u00020\u00192\u000b\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J!\u0010\u001e\u001a\u00020\u00192\u000b\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0006\u0010\u001f\u001a\u00020\u0004J\b\u0010 \u001a\u00020\u0004H\u0016J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "cancelCallback", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getCancelCallback", "()Lkotlin/jvm/functions/Function0;", "currentPage", "Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingPage;", "overlay", "Lcom/intellij/ide/startup/importSettings/chooser/ui/BannerOverlay;", "pane", "Ljavax/swing/JPanel;", "tracker", "Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardPageTracker;", "changePage", "page", "createAction", "Ljavax/swing/Action;", "name", "", "Lorg/jetbrains/annotations/Nls;", "handler", "createButton", "Ljavax/swing/JButton;", "createCenterPanel", "Ljavax/swing/JComponent;", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createDefaultButton", "dialogClose", "doCancelAction", "doClose", "code", "", "initialize", "showError", "notification", "Lcom/intellij/ide/startup/importSettings/data/NotificationData;", "intellij.ide.startup.importSettings"})
public final class OnboardingDialog
extends DialogWrapper {
    @NotNull
    private final Function0<Unit> cancelCallback;
    @NotNull
    private final WizardPageTracker tracker;
    @NotNull
    private final JPanel pane;
    @NotNull
    private OnboardingPage currentPage;
    @NotNull
    private final BannerOverlay overlay;

    /*
     * WARNING - void declaration
     */
    public OnboardingDialog(@NotNull Function0<Unit> cancelCallback) {
        void $this$pane_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter(cancelCallback, (String)"cancelCallback");
        super(null, null, true, DialogWrapper.IdeModalityType.IDE, false);
        this.cancelCallback = cancelCallback;
        this.tracker = new WizardPageTracker();
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        OnboardingDialog onboardingDialog = this;
        boolean bl = false;
        $this$pane_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$pane_u24lambda_u240.setPreferredSize((Dimension)new JBDimension(640, 467));
        onboardingDialog.pane = jPanel;
        this.currentPage = new OnboardingPage(){
            @NotNull
            private final JComponent content;
            @NotNull
            private final StartupWizardStage stage;
            {
                this.content = new JPanel();
                this.stage = StartupWizardStage.InitialStart;
            }

            @NotNull
            public JComponent getContent() {
                return this.content;
            }

            @NotNull
            public StartupWizardStage getStage() {
                return this.stage;
            }

            public boolean confirmExit(@Nullable Component parentComponent) {
                return true;
            }
        };
        this.overlay = new BannerOverlay(this.pane);
    }

    @NotNull
    public final Function0<Unit> getCancelCallback() {
        return this.cancelCallback;
    }

    public void doCancelAction() {
        boolean shouldExit = this.currentPage.confirmExit(this.getPeer().getContentPane());
        if (shouldExit) {
            super.doCancelAction();
            this.tracker.onLeave();
            this.cancelCallback.invoke();
        }
    }

    public final void dialogClose() {
        if (this.isShowing() && this.isVisible()) {
            this.doClose(1);
        }
    }

    private final void doClose(int code) {
        this.tracker.onLeave();
        this.close(code);
    }

    public final void changePage(@NotNull OnboardingPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.overlay.clearNotifications();
        this.pane.removeAll();
        Disposer.dispose((Disposable)this.currentPage);
        this.tracker.onLeave();
        JComponent content2 = page.getContent();
        this.pane.add(content2);
        this.currentPage = page;
        this.tracker.onEnter(page.getStage());
    }

    @NotNull
    protected Border createContentPaneBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        return (Border)jBEmptyBorder;
    }

    public final void initialize() {
        this.init();
    }

    public final void showError(@NotNull NotificationData notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.overlay.showError(notification);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.overlay.getComponent();
    }

    @NotNull
    public final JButton createDefaultButton(@NotNull String name, @NotNull Function0<Unit> handler) {
        Action action2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Action $this$createDefaultButton_u24lambda_u241 = action2 = this.createAction(name, handler);
        boolean bl = false;
        $this$createDefaultButton_u24lambda_u241.putValue("DefaultAction", true);
        $this$createDefaultButton_u24lambda_u241.putValue("FocusedAction", true);
        Action action3 = action2;
        JButton jButton = this.createJButtonForAction(action3);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(...)");
        return jButton;
    }

    @NotNull
    public final JButton createButton(@NotNull String name, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Action action2 = this.createAction(name, handler);
        JButton jButton = this.createJButtonForAction(action2);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(...)");
        return jButton;
    }

    private final Action createAction(String name, Function0<Unit> handler) {
        return (Action)new DialogWrapper.DialogWrapperAction(this, name, handler){
            final /* synthetic */ Function0<Unit> $handler;
            {
                this.$handler = $handler;
                super((DialogWrapper)$receiver, $name);
            }

            protected void doAction(@Nullable ActionEvent e) {
                this.$handler.invoke();
            }
        };
    }
}

