/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.ui.BaseControllerImpl;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingDialog;
import com.intellij.ide.startup.importSettings.chooser.ui.WizardController;
import com.intellij.ide.startup.importSettings.data.PluginImportProgress;
import com.intellij.ide.startup.importSettings.data.WizardService;
import com.intellij.ide.startup.importSettings.wizard.keymapChooser.KeymapChooserPage;
import com.intellij.ide.startup.importSettings.wizard.pluginChooser.WizardPluginsPage;
import com.intellij.ide.startup.importSettings.wizard.pluginChooser.WizardProgressPage;
import com.intellij.ide.startup.importSettings.wizard.themeChooser.ThemeChooserPage;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardControllerImpl;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardController;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/BaseControllerImpl;", "dialog", "Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;", "service", "Lcom/intellij/ide/startup/importSettings/data/WizardService;", "goBackAction", "Lkotlin/Function0;", "", "(Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;Lcom/intellij/ide/startup/importSettings/data/WizardService;Lkotlin/jvm/functions/Function0;)V", "getGoBackAction", "()Lkotlin/jvm/functions/Function0;", "getService", "()Lcom/intellij/ide/startup/importSettings/data/WizardService;", "goToInstallPluginPage", "ids", "", "", "goToKeymapPage", "goToPluginPage", "goToThemePage", "skipPlugins", "intellij.ide.startup.importSettings"})
public final class WizardControllerImpl
extends BaseControllerImpl
implements WizardController {
    @NotNull
    private final WizardService service;
    @Nullable
    private final Function0<Unit> goBackAction;

    public WizardControllerImpl(@NotNull OnboardingDialog dialog2, @NotNull WizardService service, @Nullable Function0<Unit> goBackAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        super(dialog2);
        this.service = service;
        this.goBackAction = goBackAction;
    }

    @Override
    @NotNull
    public WizardService getService() {
        return this.service;
    }

    @Override
    @Nullable
    public Function0<Unit> getGoBackAction() {
        return this.goBackAction;
    }

    @Override
    public void goToThemePage() {
        if (ScreenReader.isActive()) {
            this.goToKeymapPage();
            return;
        }
        ThemeChooserPage page = new ThemeChooserPage(this);
        this.getDialog().changePage(page);
    }

    @Override
    public void goToKeymapPage() {
        KeymapChooserPage page = new KeymapChooserPage(this);
        this.getDialog().changePage(page);
    }

    @Override
    public void goToPluginPage() {
        WizardPluginsPage page = new WizardPluginsPage(this);
        this.getDialog().changePage(page);
    }

    @Override
    public void goToInstallPluginPage(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (!((Collection)ids).isEmpty()) {
            PluginImportProgress importProgress = this.getService().getPluginService().install(ids);
            WizardProgressPage page = new WizardProgressPage(importProgress, this);
            this.getDialog().changePage(page);
        } else {
            this.skipPlugins();
        }
    }

    @Override
    public void skipPlugins() {
        this.getService().getPluginService().skipPlugins();
        this.getDialog().dialogClose();
    }
}

