/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.controllers;

import com.intellij.ide.startup.importSettings.controllers.TransferSettingsController;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsListener;
import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.models.FailedIdeVersion;
import com.intellij.ide.startup.importSettings.models.IdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.DefaultImportPerformer;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsPerformContext;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsPerformImportTask;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\"\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0016H\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsControllerImpl;", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsController;", "()V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "previouslySelected", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "timesSwitchedBetweenInstances", "", "addListener", "", "listener", "getImportPerformer", "Lcom/intellij/ide/startup/importSettings/providers/DefaultImportPerformer;", "itemSelected", "ideVersion", "performImport", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/ide/startup/importSettings/models/IdeVersion;", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performReload", "Lcom/intellij/ide/startup/importSettings/models/FailedIdeVersion;", "updateCheckboxes", "intellij.ide.startup.importSettings"})
public final class TransferSettingsControllerImpl
implements TransferSettingsController {
    @NotNull
    private final EventDispatcher<TransferSettingsListener> eventDispatcher;
    @Nullable
    private BaseIdeVersion previouslySelected;
    private int timesSwitchedBetweenInstances;

    public TransferSettingsControllerImpl() {
        EventDispatcher eventDispatcher = EventDispatcher.create(TransferSettingsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.timesSwitchedBetweenInstances = -1;
    }

    @Override
    public void updateCheckboxes(@NotNull IdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).checkboxesUpdated(ideVersion);
    }

    @Override
    public void performImport(@Nullable Project project, @NotNull IdeVersion ideVersion, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        TransferSettingsCollector.INSTANCE.logImportStarted(ideVersion.getSettingsCache(), this.timesSwitchedBetweenInstances);
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).importStarted(ideVersion, ideVersion.getSettingsCache());
        DefaultImportPerformer performer = this.getImportPerformer();
        TransferSettingsPerformContext context2 = new TransferSettingsPerformContext(null, 1, null);
        Settings settings = ideVersion.getSettingsCache();
        TransferSettingsPerformImportTask task2 = new TransferSettingsPerformImportTask(project, performer, context2, ideVersion, this, settings){
            final /* synthetic */ TransferSettingsPerformContext $context;
            final /* synthetic */ IdeVersion $ideVersion;
            final /* synthetic */ TransferSettingsControllerImpl this$0;
            {
                this.$context = $context;
                this.$ideVersion = $ideVersion;
                this.this$0 = $receiver;
                super($project, $performer, $super_call_param$1, true, $context);
            }

            public void onSuccess() {
                TransferSettingsCollector.INSTANCE.logImportSucceeded(this.$ideVersion, this.$ideVersion.getSettingsCache());
                ((TransferSettingsListener)TransferSettingsControllerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).importPerformed(this.$ideVersion, this.$ideVersion.getSettingsCache(), this.$context);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                TransferSettingsCollector.INSTANCE.logImportFailed(this.$ideVersion);
                ((TransferSettingsListener)TransferSettingsControllerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).importFailed(this.$ideVersion, this.$ideVersion.getSettingsCache(), error);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, pi);
    }

    @Override
    public void performReload(@NotNull FailedIdeVersion ideVersion, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).reloadPerformed(ideVersion);
    }

    @Override
    public void addListener(@NotNull TransferSettingsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        BaseIdeVersion ps = this.previouslySelected;
        if (ps != null) {
            listener2.itemSelected(ps);
        }
        this.eventDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void itemSelected(@NotNull BaseIdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).itemSelected(ideVersion);
        this.previouslySelected = ideVersion;
        int n = this.timesSwitchedBetweenInstances;
        this.timesSwitchedBetweenInstances = n + 1;
    }

    @Override
    @NotNull
    public DefaultImportPerformer getImportPerformer() {
        return new DefaultImportPerformer();
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(TransferSettingsControllerImpl $this) {
        return $this.eventDispatcher;
    }
}

