/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.StartupImportIcons;
import com.intellij.ide.startup.importSettings.data.DataForSave;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.JbService;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.jb.JbAfterRestartSettingsApplierKt;
import com.intellij.ide.startup.importSettings.jb.JbChildSetting;
import com.intellij.ide.startup.importSettings.jb.JbImportServiceImpl;
import com.intellij.ide.startup.importSettings.jb.JbProductInfo;
import com.intellij.ide.startup.importSettings.jb.JbSettingsCategory;
import com.intellij.ide.startup.importSettings.jb.JbSettingsCategoryConfigurable;
import com.intellij.ide.startup.importSettings.jb.JbSettingsImporter;
import com.intellij.ide.startup.importSettings.jb.NameMappings;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsProgress;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u000e\u0010\u0019\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000eH\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010$\u001a\u00020\u001cH\u0096@\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl;", "Lcom/intellij/ide/startup/importSettings/data/JbService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "hasDataProcessed", "Lkotlinx/coroutines/CompletableDeferred;", "", "products", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;", "warmUpComplete", "filterProducts", "", "Lcom/intellij/ide/startup/importSettings/data/Product;", "old", "getOldProducts", "getProductIcon", "Ljavax/swing/Icon;", "itemId", "size", "Lcom/intellij/ide/startup/importSettings/data/IconProductSize;", "getSettings", "Lcom/intellij/ide/startup/importSettings/jb/JbSettingsCategory;", "hasDataToImport", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "importFromCustomFolder", "", "folderPath", "Ljava/nio/file/Path;", "importSettings", "Lcom/intellij/ide/startup/importSettings/data/DialogImportData;", "productId", "saveDataList", "Lcom/intellij/ide/startup/importSettings/data/DataForSave;", "warmUp", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nJbImportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,485:1\n766#2:486\n857#2,2:487\n1054#2:489\n766#2:490\n857#2,2:491\n1054#2:493\n766#2:494\n857#2,2:495\n1054#2:497\n1549#2:498\n1620#2,3:499\n11#3:502\n*S KotlinDebug\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl\n*L\n221#1:486\n221#1:487,2\n223#1:489\n228#1:490\n228#1:491,2\n228#1:493\n241#1:494\n241#1:495,2\n242#1:497\n353#1:498\n353#1:499,3\n453#1:502\n*E\n"})
public final class JbImportServiceImpl
implements JbService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentMap<String, JbProductInfo> products;
    @NotNull
    private final CompletableDeferred<Boolean> hasDataProcessed;
    @NotNull
    private final CompletableDeferred<Boolean> warmUpComplete;
    @NotNull
    private static final Logger LOG;
    private static final Pattern IDE_NAME_PATTERN;
    @NotNull
    private static final Set<String> DEFAULT_SETTINGS_FILES;
    @NotNull
    private static final JbSettingsCategory UI_CATEGORY;
    @NotNull
    private static final JbSettingsCategory CODE_CATEGORY;
    @NotNull
    private static final JbSettingsCategory TOOLS_CATEGORY;
    @NotNull
    private static final JbSettingsCategory SYSTEM_CATEGORY;
    @NotNull
    private static final Map<String, JbSettingsCategory> DEFAULT_SETTINGS_CATEGORIES;

    public JbImportServiceImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.products = new ConcurrentHashMap();
        this.hasDataProcessed = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.warmUpComplete = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    @Override
    @Nullable
    public Object hasDataToImport(@NotNull Continuation<? super Boolean> $completion) {
        return this.hasDataProcessed.await($completion);
    }

    @Override
    @NotNull
    public List<Product> getOldProducts() {
        return this.filterProducts(true);
    }

    @Override
    public void importFromCustomFolder(@NotNull Path folderPath) {
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        ModalityState modalityState2 = modalityState;
        BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState2), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(folderPath, modalityState2, null){
            int label;
            final /* synthetic */ Path $folderPath;
            final /* synthetic */ ModalityState $modalityState;
            {
                this.$folderPath = $folderPath;
                this.$modalityState = $modalityState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JbSettingsImporter importer = new JbSettingsImporter(this.$folderPath, this.$folderPath, null);
                        importer.importRaw();
                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Performing raw import from '" + this.$folderPath + "'");
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$modalityState, null){
                            int label;
                            final /* synthetic */ ModalityState $modalityState;
                            {
                                this.$modalityState = $modalityState;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ApplicationManager.getApplication().invokeLater(importFromCustomFolder.1::invokeSuspend$lambda$0, this.$modalityState);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0() {
                                ApplicationManagerEx.getApplicationEx().restart(true);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    @NotNull
    public List<Product> products() {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Product>>, Object>(this, null){
            int label;
            final /* synthetic */ JbImportServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ JbImportServiceImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = JbImportServiceImpl.access$getWarmUpComplete$p(this.this$0).await((Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return JbImportServiceImpl.access$filterProducts(this.this$0, false);
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return JbImportServiceImpl.access$filterProducts(this.this$0, false);
                        }
                        catch (TimeoutCancellationException tce) {
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Timeout waiting for products warmUp. Will show what we have now: " + tce.getMessage());
                        }
                        return JbImportServiceImpl.access$filterProducts(this.this$0, false);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends Product>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Product> filterProducts(boolean old) {
        void $this$sortedByDescending$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object version;
        List products2 = CollectionsKt.toList((Iterable)this.products.values());
        HashMap newProducts = new HashMap();
        for (JbProductInfo product : products2) {
            if (ConfigImportHelper.isConfigOld((FileTime)product.getLastUsageTime()) || (version = (String)newProducts.get(product.getCodeName$intellij_ide_startup_importSettings())) != null && ((String)version).compareTo(product.getVersion()) >= 0) continue;
            ((Map)newProducts).put(product.getCodeName$intellij_ide_startup_importSettings(), product.getVersion());
        }
        if (old) {
            $this$filter$iv = products2;
            boolean $i$f$filter = false;
            version = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JbProductInfo it = (JbProductInfo)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(newProducts.get(it.getCodeName$intellij_ide_startup_importSettings()), (Object)it.getVersion()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b) {
                    JbProductInfo it = (JbProductInfo)b;
                    boolean bl = false;
                    Comparable comparable = it.getLastUsageTime();
                    it = (JbProductInfo)a2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getLastUsageTime());
                }
            });
        }
        $this$filter$iv = products2;
        boolean $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JbProductInfo it = (JbProductInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(newProducts.get(it.getCodeName$intellij_ide_startup_importSettings()), (Object)it.getVersion())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b) {
                JbProductInfo it = (JbProductInfo)b;
                boolean bl = false;
                Comparable comparable = it.getLastUsageTime();
                it = (JbProductInfo)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getLastUsageTime());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object warmUp(@NotNull Continuation<? super Unit> $completion) {
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Path parentDir = Path.of(PathManager.getDefaultConfigPathFor((String)""), new String[0]);
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(Collections.emptySet(), null, MapsKt.emptyMap(), (Function0)warmUp.context.1.INSTANCE, false, false, false, false, 242, null);
        Intrinsics.checkNotNull((Object)parentDir);
        Iterable iterable = PathsKt.listDirectoryEntries$default((Path)parentDir, null, (int)1, null);
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Path path = it;
            LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List configDirectoriesCandidates = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b) {
                Path it = (Path)b;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                FileTime fileTime = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                it = (Path)a2;
                Comparable comparable = fileTime;
                bl = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                FileTime fileTime2 = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)fileTime2);
            }
        });
        for (Path confDir : configDirectoriesCandidates) {
            Path optionsDir;
            LOG.info("Found " + PathsKt.getName((Path)confDir) + " under " + ((Object)parentDir).toString());
            Path pluginsDir = Path.of(PathManager.getDefaultPluginPathFor((String)PathsKt.getName((Path)confDir)), new String[0]);
            String dirName = PathsKt.getName((Path)confDir);
            Matcher matcher = IDE_NAME_PATTERN.matcher(dirName);
            if (!matcher.matches()) {
                LOG.info(PathsKt.getName((Path)confDir) + " doesn't match IDE_NAME_PATTERN, skipping it");
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)confDir.resolve("options"), (String)"resolve(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(optionsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LOG.info(PathsKt.getName((Path)confDir) + " doesn't contain options directory, skipping it");
                continue;
            }
            FileTime lastModified = null;
            for (String fileName : DEFAULT_SETTINGS_FILES) {
                Path optionXml;
                Intrinsics.checkNotNullExpressionValue((Object)optionsDir.resolve(fileName), (String)"resolve(...)");
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isRegularFile(optionXml, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                if (lastModified != null) {
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    FileTime fileTime = Files.getLastModifiedTime(optionXml, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length));
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                    if (fileTime.compareTo(lastModified) <= 0) continue;
                }
                LinkOption[] linkOptionArray4 = new LinkOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.getLastModifiedTime(optionXml, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)), (String)"getLastModifiedTime(...)");
            }
            if (lastModified == null) {
                LOG.info(PathsKt.getName((Path)confDir) + "/options has no xml files, skipping it");
                continue;
            }
            LOG.info(optionsDir + "' newest file is dated " + lastModified);
            String ideName = matcher.group(1);
            String ideVersion = matcher.group(2);
            Intrinsics.checkNotNull((Object)ideName);
            String fullName = NameMappings.INSTANCE.getFullName(ideName);
            if (fullName == null) continue;
            String fullNameWithVersion = fullName + " " + ideVersion;
            Intrinsics.checkNotNull((Object)ideVersion);
            Intrinsics.checkNotNull((Object)pluginsDir);
            JbProductInfo jbProductInfo = new JbProductInfo(ideVersion, lastModified, dirName, fullNameWithVersion, ideName, confDir, pluginsDir);
            jbProductInfo.prefetchData$intellij_ide_startup_importSettings(this.coroutineScope, context2);
            ((Map)this.products).put(dirName, jbProductInfo);
            CompletableDeferredKt.completeWith(this.hasDataProcessed, (Object)Result.constructor-impl((Object)Boxing.boxBoolean((boolean)true)));
        }
        CompletableDeferredKt.completeWith(this.warmUpComplete, (Object)Result.constructor-impl((Object)Boxing.boxBoolean((boolean)true)));
        if (!this.hasDataProcessed.isCompleted()) {
            CompletableDeferredKt.completeWith(this.hasDataProcessed, (Object)Result.constructor-impl((Object)Boxing.boxBoolean((!((Map)this.products).isEmpty() ? 1 : 0) != 0)));
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public List<JbSettingsCategory> getSettings(@NotNull String itemId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        LOG.info("User has selected " + itemId);
        JbProductInfo jbProductInfo = (JbProductInfo)this.products.get(itemId);
        if (jbProductInfo == null) {
            throw new IllegalStateException("Can't find product".toString());
        }
        JbProductInfo productInfo = jbProductInfo;
        ArrayList<JbChildSetting> plugins2 = new ArrayList<JbChildSetting>();
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (IdeaPluginDescriptorImpl descriptor : productInfo.getPluginsDescriptors()) {
            String string2 = descriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdString(...)");
            plugins2.add(new JbChildSetting(string2, descriptor.getName()));
            pluginNames.add(descriptor.getName());
        }
        LOG.info("Found " + pluginNames.size() + " custom plugins: " + CollectionsKt.joinToString$default((Iterable)pluginNames, null, null, null, (int)0, null, null, (int)63, null));
        Icon icon = StartupImportIcons.Icons.Plugin;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Plugin");
        JbSettingsCategoryConfigurable pluginsCategory = new JbSettingsCategoryConfigurable(SettingsCategory.PLUGINS, icon, ImportSettingsBundle.INSTANCE.message("settings.category.plugins.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.plugins.description", new Object[0]), CollectionsKt.listOf(plugins2));
        String activeKeymap = productInfo.getActiveKeymap();
        if (activeKeymap == null) {
            string = null;
        } else {
            Object[] objectArray = new Object[]{activeKeymap};
            string = ImportSettingsBundle.INSTANCE.message("settings.category.keymap.description", objectArray);
        }
        String activeKeymapComment = string;
        Icon icon2 = StartupImportIcons.Icons.Keyboard;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Keyboard");
        JbSettingsCategory keymapsCategory = new JbSettingsCategory(SettingsCategory.KEYMAP, icon2, ImportSettingsBundle.INSTANCE.message("settings.category.keymap.name", new Object[0]), activeKeymapComment);
        Object[] objectArray = new JbSettingsCategory[]{UI_CATEGORY, keymapsCategory, CODE_CATEGORY, pluginsCategory, TOOLS_CATEGORY, SYSTEM_CATEGORY};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public Icon getProductIcon(@NotNull String itemId, @NotNull IconProductSize size2) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)((Object)size2), (String)"size");
        JbProductInfo jbProductInfo = (JbProductInfo)this.products.get(itemId);
        if (jbProductInfo == null) {
            throw new IllegalStateException("Can't find product".toString());
        }
        JbProductInfo productInfo = jbProductInfo;
        return NameMappings.INSTANCE.getIcon(productInfo.getCodeName$intellij_ide_startup_importSettings(), size2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DialogImportData importSettings(@NotNull String productId, @NotNull List<DataForSave> saveDataList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Intrinsics.checkNotNullParameter(saveDataList, (String)"saveDataList");
        JbProductInfo jbProductInfo = (JbProductInfo)this.products.get(productId);
        if (jbProductInfo == null) {
            throw new IllegalStateException("Can't find product".toString());
        }
        JbProductInfo productInfo = jbProductInfo;
        Set filteredCategories = new LinkedHashSet();
        Ref.ObjectRef plugins2import = new Ref.ObjectRef();
        List<String> unselectedPlugins = null;
        for (DataForSave data2 : saveDataList) {
            JbSettingsCategory category;
            if (Intrinsics.areEqual((Object)data2.getId(), (Object)"PLUGINS")) {
                filteredCategories.add(SettingsCategory.PLUGINS);
                plugins2import.element = data2.getSelectedChildIds();
                unselectedPlugins = data2.getUnselectedChildIds();
                List<String> list = data2.getSelectedChildIds();
                List<String> list2 = data2.getSelectedChildIds();
                List<String> list3 = data2.getUnselectedChildIds();
                List<String> list4 = data2.getUnselectedChildIds();
                LOG.info("Will import " + (list != null ? Integer.valueOf(list.size()) : null) + " custom plugins: " + (list2 != null ? CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null) : null) + "\n" + (list3 != null ? Integer.valueOf(list3.size()) : null) + " plugins will be skipped: " + (list4 != null ? CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null) : null));
                continue;
            }
            if (DEFAULT_SETTINGS_CATEGORIES.get(data2.getId()) == null) continue;
            filteredCategories.add(category.getSettingsCategory());
        }
        LOG.info("Will import the following categories: " + CollectionsKt.joinToString$default((Iterable)filteredCategories, null, null, null, (int)0, null, null, (int)63, null));
        Iterable $this$map$iv = DEFAULT_SETTINGS_CATEGORIES.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JbSettingsCategory jbSettingsCategory = (JbSettingsCategory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSettingsCategory());
        }
        List allRoamableCategories = (List)destination$iv$iv;
        boolean importEverything = filteredCategories.containsAll(allRoamableCategories) && filteredCategories.contains(SettingsCategory.PLUGINS) && (($i$f$map = (Collection)unselectedPlugins) == null || $i$f$map.isEmpty());
        TransferSettingsProgress importData = new TransferSettingsProgress(productInfo);
        JbSettingsImporter importer = new JbSettingsImporter(productInfo.getConfigDir(), productInfo.getPluginDir(), null);
        ProgressIndicator progressIndicator = importData.createProgressIndicatorAdapter();
        LifetimeDefinition importLifetime = new LifetimeDefinition();
        SettingsService.Companion.getInstance().getImportCancelled().advise((Lifetime)importLifetime, (Function1)new Function1<Unit, Unit>(progressIndicator){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            {
                this.$progressIndicator = $progressIndicator;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$progressIndicator.cancel();
            }
        });
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        ModalityState modalityState2 = modalityState;
        long startTime = System.currentTimeMillis();
        BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState2), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(importEverything, productInfo, progressIndicator, importer, startTime, (Ref.ObjectRef<List<String>>)plugins2import, (Set<SettingsCategory>)filteredCategories, modalityState2, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ boolean $importEverything;
            final /* synthetic */ JbProductInfo $productInfo;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ JbSettingsImporter $importer;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Ref.ObjectRef<List<String>> $plugins2import;
            final /* synthetic */ Set<SettingsCategory> $filteredCategories;
            final /* synthetic */ ModalityState $modalityState;
            {
                this.$importEverything = $importEverything;
                this.$productInfo = $productInfo;
                this.$progressIndicator = $progressIndicator;
                this.$importer = $importer;
                this.$startTime = $startTime;
                this.$plugins2import = $plugins2import;
                this.$filteredCategories = $filteredCategories;
                this.$modalityState = $modalityState;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        shouldRestart = new Ref.BooleanRef();
                        var4_4 = shouldRestart;
                        this.L$0 = shouldRestart;
                        this.L$1 = var4_4;
                        this.label = 1;
                        v0 = importSettings.2.invokeSuspend$performImport(this.$importEverything, this.$productInfo, this.$progressIndicator, this.$importer, this.$startTime, this.$plugins2import, this.$filteredCategories, (Continuation<? super Boolean>)((Continuation)this));
                        ** if (v0 != var5_2) goto lbl15
lbl14:
                        // 1 sources

                        return var5_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        var4_4 = (Ref.BooleanRef)this.L$1;
                        shouldRestart = (Ref.BooleanRef)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            var4_4.element = (Boolean)v0;
                        }
                        catch (Throwable e) {
                            if (!(e instanceof CancellationException) && !(e instanceof ProcessCanceledException)) ** GOTO lbl29
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Import cancellation detected. Proceeding normally without restart.");
                            ** GOTO lbl30
lbl29:
                            // 1 sources

                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().error("Import error. Proceeding normally without restart.", e);
                        }
lbl30:
                        // 3 sources

                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Finishing the import process, shouldRestart=" + shouldRestart.element);
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(shouldRestart, this.$modalityState, null){
                            int label;
                            final /* synthetic */ Ref.BooleanRef $shouldRestart;
                            final /* synthetic */ ModalityState $modalityState;
                            {
                                this.$shouldRestart = $shouldRestart;
                                this.$modalityState = $modalityState;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        if (this.$shouldRestart.element) {
                                            importSettings.2.access$invokeSuspend$restartIde(this.$modalityState);
                                        } else {
                                            importSettings.2.access$invokeSuspend$closeImportDialog();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl41
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl41:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * Unable to fully structure code
             */
            private static final Object invokeSuspend$performImport(boolean var0, JbProductInfo var1_1, ProgressIndicator var2_2, JbSettingsImporter var3_3, long var4_4, Ref.ObjectRef<List<String>> var6_5, Set<SettingsCategory> var7_6, Continuation<? super Boolean> var8_7) {
                if (!(var8_7 instanceof importSettings.performImport.1)) ** GOTO lbl-1000
                var12_8 = var8_7;
                if ((var12_8.label & -2147483648) != 0) {
                    var12_8.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var8_7){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        long J$0;
                        int I$0;
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return importSettings.2.access$invokeSuspend$performImport(false, null, null, null, 0L, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var13_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (importEverything && NameMappings.INSTANCE.canImportDirectly(productInfo.getCodeName$intellij_ide_startup_importSettings())) {
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Started importing all...");
                            progressIndicator.setText2("Migrating options");
                            importer.importRaw();
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Imported all completed in " + (System.currentTimeMillis() - startTime) + " ms. ");
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Calling restart...");
                            return Boxing.boxBoolean((boolean)true);
                        }
                        progressIndicator.setText2("Migrating options");
                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Starting migration...");
                        restartRequired = 0;
                        var10_13 = (Collection)plugins2import.element;
                        if (!(var10_13 == null || var10_13.isEmpty() != false)) {
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Started importing plugins...");
                            importer.installPlugins(progressIndicator, (List)plugins2import.element);
                            restartRequired = 1;
                        }
                        if (progressIndicator.isCanceled()) {
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Import cancelled after importing the plugins. " + (restartRequired != 0 ? "Will now restart." : ""));
                            return Boxing.boxBoolean((boolean)(restartRequired != 0));
                        }
                        $continuation.L$0 = productInfo;
                        $continuation.L$1 = progressIndicator;
                        $continuation.L$2 = plugins2import;
                        $continuation.L$3 = filteredCategories;
                        $continuation.J$0 = startTime;
                        $continuation.I$0 = restartRequired;
                        $continuation.label = 1;
                        v0 = importer.importOptions(progressIndicator, filteredCategories, (Continuation<? super Boolean>)$continuation);
                        ** if (v0 != var13_10) goto lbl44
lbl43:
                        // 1 sources

                        return var13_10;
lbl44:
                        // 1 sources

                        ** GOTO lbl57
                    }
                    case 1: {
                        restartRequired = $continuation.I$0;
                        startTime = $continuation.J$0;
                        filteredCategories = (Set)$continuation.L$3;
                        plugins2import = (Ref.ObjectRef)$continuation.L$2;
                        progressIndicator = (ProgressIndicator)$continuation.L$1;
                        productInfo = (JbProductInfo)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl57:
                            // 2 sources

                            if (((Boolean)v0).booleanValue()) {
                                restartRequired = 1;
                            }
                            {
                                catch (ProcessCanceledException var10_14) {
                                    JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Import process cancelled. " + (restartRequired != 0 ? "Will now restart." : "Will proceed to the normal IDE startup."));
                                    return Boxing.boxBoolean((boolean)(restartRequired != 0));
                                }
                            }
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Options migrated in " + (System.currentTimeMillis() - startTime) + " ms.");
                            progressIndicator.setFraction(0.99);
                            JbAfterRestartSettingsApplierKt.storeImportConfig(productInfo.getConfigDir(), filteredCategories, (List)plugins2import.element);
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Plugins imported in " + (System.currentTimeMillis() - startTime) + " ms. ");
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Calling restart...");
                            return Boxing.boxBoolean((boolean)(restartRequired != 0));
                        }
                        catch (Throwable th) {
                            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().warn("An exception occurred during settings import", th);
                            return Boxing.boxBoolean((boolean)true);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            private static final void invokeSuspend$restartIde$lambda$0() {
                ApplicationManagerEx.getApplicationEx().restart(true);
            }

            private static final void invokeSuspend$restartIde(ModalityState modalityState) {
                ApplicationManager.getApplication().invokeLater(importSettings.2::invokeSuspend$restartIde$lambda$0, modalityState);
            }

            private static final void invokeSuspend$closeImportDialog() {
                SettingsService.Companion.getInstance().getDoClose().fire((Object)Unit.INSTANCE);
            }

            public static final /* synthetic */ void access$invokeSuspend$restartIde(ModalityState modalityState) {
                importSettings.2.invokeSuspend$restartIde(modalityState);
            }

            public static final /* synthetic */ void access$invokeSuspend$closeImportDialog() {
                importSettings.2.invokeSuspend$closeImportDialog();
            }

            public static final /* synthetic */ Object access$invokeSuspend$performImport(boolean importEverything, JbProductInfo productInfo, ProgressIndicator progressIndicator, JbSettingsImporter importer, long startTime, Ref.ObjectRef plugins2import, Set filteredCategories, Continuation $completion) {
                return importSettings.2.invokeSuspend$performImport(importEverything, productInfo, progressIndicator, importer, startTime, (Ref.ObjectRef<List<String>>)plugins2import, filteredCategories, (Continuation<? super Boolean>)$completion);
            }
        }), (int)2, null);
        return importData;
    }

    public static final /* synthetic */ CompletableDeferred access$getWarmUpComplete$p(JbImportServiceImpl $this) {
        return $this.warmUpComplete;
    }

    public static final /* synthetic */ List access$filterProducts(JbImportServiceImpl $this, boolean old) {
        return $this.filterProducts(old);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JbImportServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        IDE_NAME_PATTERN = Pattern.compile("([a-zA-Z]+)(20\\d\\d\\.\\d)");
        Object[] objectArray = new String[]{"ide.general.xml", "other.xml"};
        DEFAULT_SETTINGS_FILES = SetsKt.setOf((Object[])objectArray);
        Icon icon = StartupImportIcons.Icons.ColorPicker;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ColorPicker");
        UI_CATEGORY = new JbSettingsCategory(SettingsCategory.UI, icon, ImportSettingsBundle.INSTANCE.message("settings.category.ui.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.ui.description", new Object[0]));
        Icon icon2 = StartupImportIcons.Icons.Json;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Json");
        CODE_CATEGORY = new JbSettingsCategory(SettingsCategory.CODE, icon2, ImportSettingsBundle.INSTANCE.message("settings.category.code.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.code.description", new Object[0]));
        Icon icon3 = StartupImportIcons.Icons.Build;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Build");
        TOOLS_CATEGORY = new JbSettingsCategory(SettingsCategory.TOOLS, icon3, ImportSettingsBundle.INSTANCE.message("settings.category.tools.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.tools.description", new Object[0]));
        Icon icon4 = StartupImportIcons.Icons.Settings;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Settings");
        SYSTEM_CATEGORY = new JbSettingsCategory(SettingsCategory.SYSTEM, icon4, ImportSettingsBundle.INSTANCE.message("settings.category.system.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.system.description", new Object[0]));
        objectArray = new Pair[]{TuplesKt.to((Object)"UI", (Object)UI_CATEGORY), TuplesKt.to((Object)"CODE", (Object)CODE_CATEGORY), TuplesKt.to((Object)"TOOLS", (Object)TOOLS_CATEGORY), TuplesKt.to((Object)"SYSTEM", (Object)SYSTEM_CATEGORY)};
        DEFAULT_SETTINGS_CATEGORIES = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl$Companion;", "", "()V", "CODE_CATEGORY", "Lcom/intellij/ide/startup/importSettings/jb/JbSettingsCategory;", "DEFAULT_SETTINGS_CATEGORIES", "", "", "getDEFAULT_SETTINGS_CATEGORIES", "()Ljava/util/Map;", "DEFAULT_SETTINGS_FILES", "", "IDE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_ide_startup_importSettings", "()Lcom/intellij/openapi/diagnostic/Logger;", "SYSTEM_CATEGORY", "TOOLS_CATEGORY", "UI_CATEGORY", "getInstance", "Lcom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl;", "intellij.ide.startup.importSettings"})
    @SourceDebugExtension(value={"SMAP\nJbImportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,485:1\n43#2,3:486\n*S KotlinDebug\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl$Companion\n*L\n459#1:486,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_ide_startup_importSettings() {
            return LOG;
        }

        @NotNull
        public final JbImportServiceImpl getInstance() {
            boolean $i$f$service = false;
            Class<JbImportServiceImpl> serviceClass$iv = JbImportServiceImpl.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (JbImportServiceImpl)object;
        }

        @NotNull
        public final Map<String, JbSettingsCategory> getDEFAULT_SETTINGS_CATEGORIES() {
            return DEFAULT_SETTINGS_CATEGORIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

