/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.jb.IDEData;
import com.intellij.ide.startup.importSettings.jb.JbImportServiceImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010,\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b-J\t\u0010.\u001a\u00020\nH\u00c6\u0003J\t\u0010/\u001a\u00020\nH\u00c6\u0003JO\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u00101\u001a\u00020\u001a2\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001905J\t\u00106\u001a\u00020\u001cH\u00d6\u0001J\u0010\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u0019H\u0002J\u001d\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u0010\u0010@\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010A\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0012\u00a8\u0006C"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;", "Lcom/intellij/ide/startup/importSettings/data/Product;", "version", "", "lastUsageTime", "Ljava/nio/file/attribute/FileTime;", "id", "name", "codeName", "configDir", "Ljava/nio/file/Path;", "pluginDir", "(Ljava/lang/String;Ljava/nio/file/attribute/FileTime;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "_lastUsage", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "activeKeymap", "getActiveKeymap", "()Ljava/lang/String;", "getCodeName$intellij_ide_startup_importSettings", "getConfigDir", "()Ljava/nio/file/Path;", "descriptors", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "", "descriptors2ProcessCnt", "", "getId", "keymapRef", "Ljava/util/concurrent/atomic/AtomicReference;", "lastUsage", "getLastUsage", "()Ljava/time/LocalDate;", "getLastUsageTime", "()Ljava/nio/file/attribute/FileTime;", "getName", "getPluginDir", "getVersion", "component1", "component2", "component3", "component4", "component5", "component5$intellij_ide_startup_importSettings", "component6", "component7", "copy", "equals", "other", "", "getPluginsDescriptors", "", "hashCode", "isCompatible", "descriptor", "prefetchData", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "prefetchData$intellij_ide_startup_importSettings", "prefetchKeymap", "prefetchPluginDescriptors", "toString", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nJbImportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbProductInfo\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,485:1\n46#2,5:486\n766#3:491\n857#3,2:492\n1549#3:494\n1620#3,3:495\n*S KotlinDebug\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbProductInfo\n*L\n86#1:486,5\n131#1:491\n131#1:492,2\n131#1:494\n131#1:495,3\n*E\n"})
public final class JbProductInfo
implements Product {
    @NotNull
    private final String version;
    @NotNull
    private final FileTime lastUsageTime;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String codeName;
    @NotNull
    private final Path configDir;
    @NotNull
    private final Path pluginDir;
    @NotNull
    private final CopyOnWriteArrayList<Pair<IdeaPluginDescriptorImpl, Boolean>> descriptors;
    private int descriptors2ProcessCnt;
    @NotNull
    private AtomicReference<String> keymapRef;
    private final LocalDate _lastUsage;
    @NotNull
    private final LocalDate lastUsage;

    public JbProductInfo(@NotNull String version, @NotNull FileTime lastUsageTime, @NotNull String id, @NotNull String name, @NotNull String codeName, @NotNull Path configDir, @NotNull Path pluginDir) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)lastUsageTime, (String)"lastUsageTime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Intrinsics.checkNotNullParameter((Object)pluginDir, (String)"pluginDir");
        this.version = version;
        this.lastUsageTime = lastUsageTime;
        this.id = id;
        this.name = name;
        this.codeName = codeName;
        this.configDir = configDir;
        this.pluginDir = pluginDir;
        this.descriptors = new CopyOnWriteArrayList();
        this.keymapRef = new AtomicReference();
        LocalDate localDate = this._lastUsage = LocalDate.ofInstant(this.lastUsageTime.toInstant(), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"_lastUsage");
        this.lastUsage = localDate;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public final FileTime getLastUsageTime() {
        return this.lastUsageTime;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getCodeName$intellij_ide_startup_importSettings() {
        return this.codeName;
    }

    @NotNull
    public final Path getConfigDir() {
        return this.configDir;
    }

    @NotNull
    public final Path getPluginDir() {
        return this.pluginDir;
    }

    @Nullable
    public final String getActiveKeymap() {
        return this.keymapRef.get();
    }

    public final void prefetchData$intellij_ide_startup_importSettings(@NotNull CoroutineScope coroutineScope, @NotNull DescriptorListLoadingContext context2) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.prefetchPluginDescriptors(coroutineScope, context2);
        this.prefetchKeymap(coroutineScope);
    }

    private final void prefetchKeymap(CoroutineScope coroutineScope) {
        BuildersKt.async$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JbProductInfo this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Path keymapFilePath = this.this$0.getConfigDir().resolve("options/" + StoreUtilKt.getPerOsSettingsStorageFolderName() + "/keymap.xml");
                        Intrinsics.checkNotNull((Object)keymapFilePath);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(keymapFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            Element element = JDOMUtil.load((Path)keymapFilePath);
                            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
                            Element element2 = element;
                            List children = element2.getChildren("component");
                            for (Element child : children) {
                                String keymapName;
                                Element activeKeymap;
                                if (!Intrinsics.areEqual((Object)child.getAttributeValue("name"), (Object)"KeymapManager")) continue;
                                if (child.getChild("active_keymap") == null) {
                                    return Unit.INSTANCE;
                                }
                                if (activeKeymap.getAttributeValue("name") == null) {
                                    return Unit.INSTANCE;
                                }
                                JbProductInfo.access$getKeymapRef$p(this.this$0).set(keymapName);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void prefetchPluginDescriptors(CoroutineScope coroutineScope, DescriptorListLoadingContext context2) {
        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().debug("Prefetching plugin descriptors from " + this.pluginDir);
        List descriptorDeferreds = PluginDescriptorLoader.loadCustomDescriptorsFromDir((CoroutineScope)coroutineScope, (Path)this.pluginDir, (DescriptorListLoadingContext)context2);
        this.descriptors2ProcessCnt = descriptorDeferreds.size();
        Logger $this$debug_u24default$iv = JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("There are " + descriptorDeferreds.size() + " plugins in " + this.pluginDir, e$iv);
        }
        for (Deferred def : descriptorDeferreds) {
            def.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(coroutineScope, (Deferred<IdeaPluginDescriptorImpl>)def, this){
                final /* synthetic */ CoroutineScope $coroutineScope;
                final /* synthetic */ Deferred<IdeaPluginDescriptorImpl> $def;
                final /* synthetic */ JbProductInfo this$0;
                {
                    this.$coroutineScope = $coroutineScope;
                    this.$def = $def;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable Throwable it) {
                    BuildersKt.async$default((CoroutineScope)this.$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$def, this.this$0, null){
                        int label;
                        final /* synthetic */ Deferred<IdeaPluginDescriptorImpl> $def;
                        final /* synthetic */ JbProductInfo this$0;
                        {
                            this.$def = $def;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = this.$def.await((Continuation)this);
                                    if (v0 == var4_2) {
                                        return var4_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    v1 = (IdeaPluginDescriptorImpl)v0;
                                    if (v1 == null) {
                                        return Unit.INSTANCE;
                                    }
                                    descr = v1;
                                    compatible = JbProductInfo.access$isCompatible(this.this$0, descr);
                                    JbProductInfo.access$getDescriptors$p(this.this$0).add(TuplesKt.to((Object)descr, (Object)Boxing.boxBoolean((boolean)(compatible != false))));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            });
        }
    }

    private final boolean isCompatible(IdeaPluginDescriptorImpl descriptor) {
        if (PluginManagerCore.INSTANCE.getPluginSet().isPluginEnabled(descriptor.getPluginId())) {
            IDEData iDEData = IDEData.Companion.getSelf();
            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Plugin \"" + descriptor.getName() + "\" from \"" + this.getName() + "\" is already present in \"" + (iDEData != null ? iDEData.getFullName() : null) + "\"");
            return false;
        }
        for (PluginId ic : descriptor.incompatibilities) {
            if (!PluginManagerCore.INSTANCE.getPluginSet().isPluginEnabled(ic)) continue;
            IDEData iDEData = IDEData.Companion.getSelf();
            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Plugin \"" + descriptor.getName() + "\" from \"" + this.getName() + "\" could not be migrated to \"" + (iDEData != null ? iDEData.getFullName() : null) + "\", because it is incompatible with " + ic);
            return false;
        }
        for (PluginDependency dependency : descriptor.pluginDependencies) {
            if (dependency.isOptional() || PluginManagerCore.INSTANCE.getPluginSet().isPluginEnabled(dependency.getPluginId())) continue;
            IDEData iDEData = IDEData.Companion.getSelf();
            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Plugin \"" + descriptor.getName() + "\" from \"" + this.getName() + "\" could not be migrated to \"" + (iDEData != null ? iDEData.getFullName() : null) + "\", because of the missing required dependency: " + dependency.getPluginId());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IdeaPluginDescriptorImpl> getPluginsDescriptors() {
        void $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        List retval = CollectionsKt.toList((Iterable)this.descriptors);
        if (retval.size() != this.descriptors2ProcessCnt) {
            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().warn("found " + retval.size() + " custom plugins, but found only " + this.descriptors2ProcessCnt);
        }
        Iterable $this$filter$iv = retval;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)it.getSecond()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((IdeaPluginDescriptorImpl)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public LocalDate getLastUsage() {
        return this.lastUsage;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final FileTime component2() {
        return this.lastUsageTime;
    }

    @NotNull
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    @NotNull
    public final String component5$intellij_ide_startup_importSettings() {
        return this.codeName;
    }

    @NotNull
    public final Path component6() {
        return this.configDir;
    }

    @NotNull
    public final Path component7() {
        return this.pluginDir;
    }

    @NotNull
    public final JbProductInfo copy(@NotNull String version, @NotNull FileTime lastUsageTime, @NotNull String id, @NotNull String name, @NotNull String codeName, @NotNull Path configDir, @NotNull Path pluginDir) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)lastUsageTime, (String)"lastUsageTime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Intrinsics.checkNotNullParameter((Object)pluginDir, (String)"pluginDir");
        return new JbProductInfo(version, lastUsageTime, id, name, codeName, configDir, pluginDir);
    }

    public static /* synthetic */ JbProductInfo copy$default(JbProductInfo jbProductInfo, String string, FileTime fileTime, String string2, String string3, String string4, Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            string = jbProductInfo.version;
        }
        if ((n & 2) != 0) {
            fileTime = jbProductInfo.lastUsageTime;
        }
        if ((n & 4) != 0) {
            string2 = jbProductInfo.id;
        }
        if ((n & 8) != 0) {
            string3 = jbProductInfo.name;
        }
        if ((n & 0x10) != 0) {
            string4 = jbProductInfo.codeName;
        }
        if ((n & 0x20) != 0) {
            path = jbProductInfo.configDir;
        }
        if ((n & 0x40) != 0) {
            path2 = jbProductInfo.pluginDir;
        }
        return jbProductInfo.copy(string, fileTime, string2, string3, string4, path, path2);
    }

    @NotNull
    public String toString() {
        return "JbProductInfo(version=" + this.version + ", lastUsageTime=" + this.lastUsageTime + ", id=" + this.id + ", name=" + this.name + ", codeName=" + this.codeName + ", configDir=" + this.configDir + ", pluginDir=" + this.pluginDir + ")";
    }

    public int hashCode() {
        int result2 = this.version.hashCode();
        result2 = result2 * 31 + this.lastUsageTime.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.codeName.hashCode();
        result2 = result2 * 31 + ((Object)this.configDir).hashCode();
        result2 = result2 * 31 + ((Object)this.pluginDir).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JbProductInfo)) {
            return false;
        }
        JbProductInfo jbProductInfo = (JbProductInfo)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)jbProductInfo.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUsageTime, (Object)jbProductInfo.lastUsageTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)jbProductInfo.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)jbProductInfo.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.codeName, (Object)jbProductInfo.codeName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configDir, (Object)jbProductInfo.configDir)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pluginDir, (Object)jbProductInfo.pluginDir);
    }

    public static final /* synthetic */ AtomicReference access$getKeymapRef$p(JbProductInfo $this) {
        return $this.keymapRef;
    }

    public static final /* synthetic */ boolean access$isCompatible(JbProductInfo $this, IdeaPluginDescriptorImpl descriptor) {
        return $this.isCompatible(descriptor);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getDescriptors$p(JbProductInfo $this) {
        return $this.descriptors;
    }
}

