/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers;

import com.intellij.ide.startup.importSettings.models.BundledKeymap;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.PluginKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.SettingsPreferencesKind;
import com.intellij.ide.startup.importSettings.providers.PartialImportPerformer;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0016J\"\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/KeymapSchemeImportPerformer;", "Lcom/intellij/ide/startup/importSettings/providers/PartialImportPerformer;", "()V", "collectAllRequiredPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "doBundledKeymap", "", "keymap", "Lcom/intellij/ide/startup/importSettings/models/BundledKeymap;", "doPatchedKeymap", "Lcom/intellij/ide/startup/importSettings/models/PatchedKeymap;", "patchSettingsAfterPluginInstallation", "pluginIds", "", "perform", "project", "Lcom/intellij/openapi/project/Project;", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performEdt", "willPerform", "", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nPartialImportPerformers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialImportPerformers.kt\ncom/intellij/ide/startup/importSettings/providers/KeymapSchemeImportPerformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1#2:229\n1855#3:230\n1855#3,2:231\n1856#3:233\n1855#3:234\n766#3:235\n857#3,2:236\n1855#3,2:238\n1856#3:240\n*S KotlinDebug\n*F\n+ 1 PartialImportPerformers.kt\ncom/intellij/ide/startup/importSettings/providers/KeymapSchemeImportPerformer\n*L\n193#1:230\n194#1:231,2\n193#1:233\n199#1:234\n201#1:235\n201#1:236,2\n202#1:238,2\n199#1:240\n*E\n"})
public final class KeymapSchemeImportPerformer
implements PartialImportPerformer {
    @Override
    public boolean willPerform(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getPreferences().get(SettingsPreferencesKind.Keymap) && settings.getKeymap() != null;
    }

    @Override
    @NotNull
    public Set<PluginId> collectAllRequiredPlugins(@NotNull Settings settings) {
        PluginKeymap pluginKeymap;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Keymap keymap = settings.getKeymap();
        PluginKeymap pluginKeymap2 = pluginKeymap = keymap instanceof PluginKeymap ? (PluginKeymap)keymap : null;
        if (pluginKeymap != null) {
            PluginKeymap it = pluginKeymap;
            boolean bl = false;
            PluginId pluginId = PluginId.getId((String)it.getPluginId());
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
            return SetsKt.setOf((Object)pluginId);
        }
        Keymap bl = settings.getKeymap();
        PatchedKeymap patchedKeymap = bl instanceof PatchedKeymap ? (PatchedKeymap)bl : null;
        keymap = patchedKeymap != null ? patchedKeymap.getParent() : null;
        PluginKeymap pluginKeymap3 = pluginKeymap = keymap instanceof PluginKeymap ? (PluginKeymap)keymap : null;
        if (pluginKeymap != null) {
            PluginKeymap it = pluginKeymap;
            boolean bl2 = false;
            PluginId pluginId = PluginId.getId((String)it.getPluginId());
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
            return SetsKt.setOf((Object)pluginId);
        }
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Settings patchSettingsAfterPluginInstallation(@NotNull Settings settings, @NotNull Set<String> pluginIds) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        Keymap km = settings.getKeymap();
        if (km instanceof PatchedKeymap) {
            PluginKeymap parent;
            Keymap keymap = ((PatchedKeymap)km).getParent();
            PluginKeymap pluginKeymap = parent = keymap instanceof PluginKeymap ? (PluginKeymap)keymap : null;
            if (parent != null) {
                if (pluginIds.contains(parent.getPluginId())) {
                    ((PatchedKeymap)km).setParent(BundledKeymap.Companion.fromManager(((PatchedKeymap)km).getTransferableId(), parent.getInstalledName(), CollectionsKt.emptyList()));
                } else {
                    ((PatchedKeymap)km).setParent(parent.getFallback());
                }
            }
        }
        if (km instanceof PluginKeymap) {
            if (pluginIds.contains(((PluginKeymap)km).getPluginId())) {
                settings.setKeymap(BundledKeymap.Companion.fromManager(((PluginKeymap)km).getTransferableId(), ((PluginKeymap)km).getInstalledName(), CollectionsKt.emptyList()));
            } else {
                settings.setKeymap(((PluginKeymap)km).getFallback());
            }
        }
        return settings;
    }

    @Override
    public void perform(@Nullable Project project, @NotNull Settings settings, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
    }

    @Override
    public void performEdt(@Nullable Project project, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Keymap keymap = settings.getKeymap();
        if (keymap == null) {
            return;
        }
        Keymap keymap2 = keymap;
        Keymap keymap3 = keymap2;
        if (keymap3 instanceof BundledKeymap) {
            this.doBundledKeymap((BundledKeymap)keymap2);
        } else if (keymap3 instanceof PatchedKeymap) {
            this.doPatchedKeymap((PatchedKeymap)keymap2);
        }
    }

    private final void doBundledKeymap(BundledKeymap keymap) {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        keymapManager.setActiveKeymap(keymap.getKeymap());
    }

    /*
     * WARNING - void declaration
     */
    private final void doPatchedKeymap(PatchedKeymap keymap) {
        KeyBinding it;
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        Keymap keymap2 = keymap.getParent();
        BundledKeymap bundledKeymap = keymap2 instanceof BundledKeymap ? (BundledKeymap)keymap2 : null;
        Object parent = bundledKeymap != null ? bundledKeymap.getKeymap() : null;
        if (parent == null) {
            boolean $i$a$-requireNotNull-KeymapSchemeImportPerformer$doPatchedKeymap$22 = false;
            String $i$a$-requireNotNull-KeymapSchemeImportPerformer$doPatchedKeymap$22 = "parent must be BundledKeymap at this point";
            throw new IllegalArgumentException($i$a$-requireNotNull-KeymapSchemeImportPerformer$doPatchedKeymap$22.toString());
        }
        if (keymap.getOverrides().isEmpty() && keymap.getRemoval().isEmpty()) {
            keymapManager.setActiveKeymap(parent);
            return;
        }
        com.intellij.openapi.keymap.Keymap keymap3 = parent.deriveKeymap(parent.getName() + " (Migrated)");
        Intrinsics.checkNotNullExpressionValue((Object)keymap3, (String)"deriveKeymap(...)");
        com.intellij.openapi.keymap.Keymap derived = keymap3;
        Iterable $this$forEach$iv = keymap.getOverrides();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KeyBinding)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getShortcuts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KeyboardShortcut ks = (KeyboardShortcut)element$iv2;
                boolean bl2 = false;
                derived.addShortcut(it.getActionId(), (Shortcut)ks);
            }
        }
        $this$forEach$iv = keymap.getRemoval();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            it = (KeyBinding)element$iv;
            boolean bl = false;
            Shortcut[] shortcutArray = derived.getShortcuts(it.getActionId());
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Set og = ArraysKt.toSet((Object[])shortcutArray);
            Iterable $this$filter$iv = it.getShortcuts();
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KeyboardShortcut it2 = (KeyboardShortcut)element$iv$iv;
                boolean bl3 = false;
                if (!og.contains(it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv3 = toRemove;
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                KeyboardShortcut tr = (KeyboardShortcut)element$iv3;
                boolean bl4 = false;
                derived.removeShortcut(it.getActionId(), (Shortcut)tr);
            }
        }
        keymapManager.getSchemeManager().addScheme((Object)derived);
        keymapManager.setActiveKeymap(derived);
        System.out.println();
    }
}

