/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers;

import com.intellij.ide.startup.importSettings.models.BundledEditorColorScheme;
import com.intellij.ide.startup.importSettings.models.EditorColorScheme;
import com.intellij.ide.startup.importSettings.models.PluginEditorColorScheme;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.SettingsPreferencesKind;
import com.intellij.ide.startup.importSettings.providers.PartialImportPerformer;
import com.intellij.ide.startup.importSettings.providers.PartialImportPerformersKt;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004H\u0016J\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/SyntaxSchemeImportPerformer;", "Lcom/intellij/ide/startup/importSettings/providers/PartialImportPerformer;", "()V", "collectAllRequiredPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "patchSettingsAfterPluginInstallation", "pluginIds", "", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performEdt", "willPerform", "", "intellij.ide.startup.importSettings"})
public final class SyntaxSchemeImportPerformer
implements PartialImportPerformer {
    @Override
    public boolean willPerform(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getPreferences().get(SettingsPreferencesKind.SyntaxScheme) && settings.getSyntaxScheme() != null;
    }

    @Override
    @NotNull
    public Set<PluginId> collectAllRequiredPlugins(@NotNull Settings settings) {
        PluginEditorColorScheme pluginEditorColorScheme;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        EditorColorScheme editorColorScheme = settings.getSyntaxScheme();
        PluginEditorColorScheme pluginEditorColorScheme2 = pluginEditorColorScheme = editorColorScheme instanceof PluginEditorColorScheme ? (PluginEditorColorScheme)editorColorScheme : null;
        if (pluginEditorColorScheme != null) {
            PluginEditorColorScheme it = pluginEditorColorScheme;
            boolean bl = false;
            PluginId pluginId = PluginId.getId((String)it.getPluginId());
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
            return SetsKt.setOf((Object)pluginId);
        }
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Settings patchSettingsAfterPluginInstallation(@NotNull Settings settings, @NotNull Set<String> pluginIds) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            EditorColorScheme editorColorScheme = settings.getSyntaxScheme();
            PluginEditorColorScheme pluginEditorColorScheme = editorColorScheme instanceof PluginEditorColorScheme ? (PluginEditorColorScheme)editorColorScheme : null;
            if (pluginEditorColorScheme == null) break block2;
            PluginEditorColorScheme it = pluginEditorColorScheme;
            boolean bl = false;
            if (pluginIds.contains(it.getPluginId())) {
                settings.setSyntaxScheme(BundledEditorColorScheme.Companion.fromManager(it.getInstalledName()));
            } else {
                settings.setSyntaxScheme(it.getFallback());
            }
        }
        return settings;
    }

    @Override
    public void perform(@Nullable Project project, @NotNull Settings settings, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
    }

    @Override
    public void performEdt(@Nullable Project project, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        EditorColorScheme editorColorScheme = settings.getSyntaxScheme();
        if (editorColorScheme == null) {
            return;
        }
        EditorColorScheme scheme = editorColorScheme;
        if (!(scheme instanceof BundledEditorColorScheme)) {
            PartialImportPerformersKt.access$getLogger$p().warn("scheme is not BundledEditorColorScheme, but instead " + scheme.getClass().getSimpleName());
            return;
        }
        EditorColorsManager.getInstance().getGlobalScheme();
    }
}

