/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vscode.mappings;

import com.intellij.ide.startup.importSettings.models.BuiltInFeature;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.PluginFeature;
import com.intellij.ide.startup.importSettings.providers.vscode.mappings.FeatureData;
import com.intellij.ide.startup.importSettings.providers.vscode.mappings.PluginsMappingsKt;
import com.intellij.ide.startup.importSettings.providers.vscode.mappings.VSCodePluginMapping;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.util.PlatformUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/mappings/CommonPluginMapping;", "Lcom/intellij/ide/startup/importSettings/providers/vscode/mappings/VSCodePluginMapping;", "()V", "allPlugins", "", "", "Lcom/intellij/ide/startup/importSettings/models/FeatureInfo;", "getAllPlugins", "()Ljava/util/Map;", "allPlugins$delegate", "Lkotlin/Lazy;", "getResourceMappings", "", "mapPlugin", "pluginId", "intellij.ide.startup.importSettings"})
public final class CommonPluginMapping
implements VSCodePluginMapping {
    @NotNull
    private final Lazy allPlugins$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, FeatureInfo>>(this){
        final /* synthetic */ CommonPluginMapping this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, FeatureInfo> invoke() {
            List resourceNames = CommonPluginMapping.access$getResourceMappings(this.this$0);
            Map result2 = new LinkedHashMap<K, V>();
            for (String resourceName : resourceNames) {
                Object object;
                void $this$runAndLogException$iv;
                Logger logger = PluginsMappingsKt.access$getLogger$p();
                CommonPluginMapping commonPluginMapping = this.this$0;
                boolean $i$f$runAndLogException = false;
                void var8_8 = $this$runAndLogException$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv = var8_8;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object object2 = commonPluginMapping.getClass().getClassLoader().getResourceAsStream("pluginData/" + resourceName);
                    Throwable throwable = null;
                    try {
                        void $this$decodeFromStream$iv;
                        Object file = (InputStream)object2;
                        boolean bl3 = false;
                        Json json = (Json)Json.Default;
                        Intrinsics.checkNotNull((Object)file);
                        InputStream stream$iv = file;
                        boolean $i$f$decodeFromStream = false;
                        $this$decodeFromStream$iv.getSerializersModule();
                        file = (List)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)new ArrayListSerializer(FeatureData.Companion.serializer())), (InputStream)stream$iv);
                    }
                    catch (Throwable file) {
                        throwable = file;
                        throw file;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    }
                    Object features = file;
                    object2 = features.iterator();
                    while (object2.hasNext()) {
                        FeatureInfo featureInfo;
                        boolean isBundled;
                        String key;
                        FeatureData data2 = (FeatureData)object2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)data2.getVsCodeId().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                        if (data2.getDisabled()) {
                            result2.remove(key);
                            continue;
                        }
                        boolean bl4 = isBundled = data2.getBundled() || data2.getBuiltIn();
                        if (isBundled) {
                            featureInfo = new BuiltInFeature(null, data2.getIdeaName(), null, false, 12, null);
                        } else {
                            if (data2.getIdeaId() == null) {
                                PluginsMappingsKt.access$getLogger$p().error("Cannot determine IntelliJ plugin id for feature " + data2 + ".");
                                continue;
                            }
                            featureInfo = new PluginFeature(null, data2.getIdeaId(), data2.getIdeaName(), null, false, 24, null);
                        }
                        FeatureInfo feature = featureInfo;
                        result2.put(key, feature);
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
            }
            return result2;
        }
    }));

    private final List<String> getResourceMappings() {
        List list;
        if (PlatformUtils.isDataGrip()) {
            Object[] objectArray = new String[]{"general.json", "dg.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isIntelliJ()) {
            Object[] objectArray = new String[]{"general.json", "ic.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isPhpStorm()) {
            Object[] objectArray = new String[]{"general.json", "ps.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isPyCharm()) {
            Object[] objectArray = new String[]{"general.json", "pc.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isRubyMine()) {
            Object[] objectArray = new String[]{"general.json", "rm.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isRustRover()) {
            Object[] objectArray = new String[]{"general.json", "rr.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isRider()) {
            Object[] objectArray = new String[]{"general.json", "rd.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isWebStorm()) {
            Object[] objectArray = new String[]{"general.json", "ws.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)"general.json");
        }
        return list;
    }

    @NotNull
    public final Map<String, FeatureInfo> getAllPlugins() {
        Lazy lazy = this.allPlugins$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @Nullable
    public FeatureInfo mapPlugin(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Map<String, FeatureInfo> map2 = this.getAllPlugins();
        String string = pluginId.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return map2.get(string);
    }

    public static final /* synthetic */ List access$getResourceMappings(CommonPluginMapping $this) {
        return $this.getResourceMappings();
    }
}

