/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vsmac;

import com.intellij.ide.startup.importSettings.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vsmac.parsers.GeneralSettingsParser;
import com.intellij.ide.startup.importSettings.providers.vsmac.parsers.KeyBindingsParser;
import com.intellij.ide.startup.importSettings.providers.vsmac.parsers.RecentProjectsParser;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vsmac/VSMacSettingsProcessor;", "", "()V", "getProcessedSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "version", "", "Companion", "intellij.ide.startup.importSettings"})
public final class VSMacSettingsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String homeDirectory = System.getProperty("user.home");
    @NotNull
    private static final String vsHome = homeDirectory + "/Library/VisualStudio";
    @NotNull
    private static final String vsPreferences = homeDirectory + "/Library/Preferences/VisualStudio";

    @NotNull
    public final Settings getProcessedSettings(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        File keyBindingsFile = Companion.getKeyBindingsFile$intellij_ide_startup_importSettings(version);
        File generalSettingsFile = Companion.getGeneralSettingsFile$intellij_ide_startup_importSettings(version);
        File recentlyUsedFile = Companion.getRecentlyUsedFile$intellij_ide_startup_importSettings(version);
        Settings settings = Companion.getDefaultSettings();
        new KeyBindingsParser(settings).process(keyBindingsFile);
        new GeneralSettingsParser(settings).process(generalSettingsFile);
        new RecentProjectsParser(settings).process(recentlyUsedFile);
        return settings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vsmac/VSMacSettingsProcessor$Companion;", "", "()V", "homeDirectory", "", "kotlin.jvm.PlatformType", "vsHome", "vsPreferences", "getVsPreferences$intellij_ide_startup_importSettings", "()Ljava/lang/String;", "getDefaultSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "getGeneralSettingsFile", "Ljava/io/File;", "version", "getGeneralSettingsFile$intellij_ide_startup_importSettings", "getKeyBindingsFile", "getKeyBindingsFile$intellij_ide_startup_importSettings", "getRecentlyUsedFile", "getRecentlyUsedFile$intellij_ide_startup_importSettings", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVsPreferences$intellij_ide_startup_importSettings() {
            return vsPreferences;
        }

        @NotNull
        public final File getRecentlyUsedFile$intellij_ide_startup_importSettings(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new File(this.getVsPreferences$intellij_ide_startup_importSettings() + "/" + version + "/RecentlyUsed.xml");
        }

        @NotNull
        public final File getKeyBindingsFile$intellij_ide_startup_importSettings(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new File(vsHome + "/" + version + "/KeyBindings/Custom.mac-kb.xml");
        }

        @NotNull
        public final File getGeneralSettingsFile$intellij_ide_startup_importSettings(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new File(this.getVsPreferences$intellij_ide_startup_importSettings() + "/" + version + "/MonoDevelopProperties.xml");
        }

        @NotNull
        public final Settings getDefaultSettings() {
            return new Settings(null, KnownLafs.INSTANCE.getLight(), KnownColorSchemes.INSTANCE.getLight(), KnownKeymaps.INSTANCE.getVSMac(), null, null, 49, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

