/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.parsers;

import com.intellij.ide.startup.importSettings.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSRegistryParserNew;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSXmlParser;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHive;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSParser;", "", "hive", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "(Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "getSettings", "()Lcom/intellij/ide/startup/importSettings/models/Settings;", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSParser.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,43:1\n11#2:44\n*S KotlinDebug\n*F\n+ 1 VSParser.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSParser\n*L\n12#1:44\n*E\n"})
public final class VSParser {
    @NotNull
    private final VSHive hive;
    @NotNull
    private final Settings settings;
    @NotNull
    private final Logger logger;

    /*
     * WARNING - void declaration
     */
    public VSParser(@NotNull VSHive hive) {
        ILookAndFeel iLookAndFeel;
        void $this$_init__u24lambda_u240;
        Settings settings;
        VSRegistryParserNew regParser;
        Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
        this.hive = hive;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        VSRegistryParserNew vSRegistryParserNew = regParser = this.hive.getRegistry();
        File settingsFile2 = vSRegistryParserNew != null ? vSRegistryParserNew.getSettingsFile() : null;
        if (settingsFile2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Settings settings2 = settings = new VSXmlParser(settingsFile2, this.hive).toSettings();
        VSParser vSParser = this;
        boolean bl = false;
        if ($this$_init__u24lambda_u240.getLaf() == null) {
            $this$_init__u24lambda_u240.setLaf(KnownLafs.INSTANCE.getDarcula());
        }
        if (Intrinsics.areEqual((Object)(iLookAndFeel = $this$_init__u24lambda_u240.getLaf()), (Object)KnownLafs.INSTANCE.getDarcula())) {
            $this$_init__u24lambda_u240.setSyntaxScheme(KnownColorSchemes.INSTANCE.getDarcula());
        } else if (Intrinsics.areEqual((Object)iLookAndFeel, (Object)KnownLafs.INSTANCE.getLight())) {
            $this$_init__u24lambda_u240.setSyntaxScheme(KnownColorSchemes.INSTANCE.getLight());
        }
        $this$_init__u24lambda_u240.getPlugins().putAll(regParser.getExtensions());
        $this$_init__u24lambda_u240.getRecentProjects().addAll((Collection<RecentPathInfo>)regParser.getRecentProjects());
        if ($this$_init__u24lambda_u240.getLaf() == null) {
            this.logger.info("Got null for laf, trying registry method");
            $this$_init__u24lambda_u240.setLaf(regParser.getTheme());
        }
        vSParser.settings = settings;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }
}

