/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.parsers;

import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSXmlParserException;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.FontsAndColorsParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.KeyBindingsParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VSParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VSParsedDataCreator;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHive;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.Version2;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00152\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0006\u0010\u001a\u001a\u00020\bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser;", "", "settingsFile", "Ljava/io/File;", "hive", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "(Ljava/io/File;Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;)V", "allSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "getAllSettings", "()Lcom/intellij/ide/startup/importSettings/models/Settings;", "document", "Lorg/jdom/Document;", "ver", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "getVer", "()Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "categoryDigger", "", "version", "rtElement", "Lorg/jdom/Element;", "parserDispatcher", "Lkotlin/Function0;", "Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/VSParsedData;", "el", "toSettings", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSXmlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSXmlParser.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n1#2:106\n11#3:107\n*S KotlinDebug\n*F\n+ 1 VSXmlParser.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser\n*L\n30#1:107\n*E\n"})
public final class VSXmlParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final VSHive hive;
    @NotNull
    private final Document document;
    @NotNull
    private final Settings allSettings;
    @NotNull
    private final Version2 ver;
    @NotNull
    public static final String applicationIdentity = "ApplicationIdentity";
    @NotNull
    public static final String toolsOptions = "ToolsOptions";
    @NotNull
    public static final String category = "Category";
    @NotNull
    public static final String envGroup = "Environment_Group";
    @NotNull
    public static final String nameAttr = "name";
    @NotNull
    public static final String versionAttr = "version";
    @NotNull
    private static final Logger logger;

    public VSXmlParser(@NotNull File settingsFile2, @Nullable VSHive hive) {
        String string;
        Intrinsics.checkNotNullParameter((Object)settingsFile2, (String)"settingsFile");
        this.hive = hive;
        this.allSettings = new Settings(null, null, null, KnownKeymaps.INSTANCE.getVisualStudio2022(), null, null, 55, null);
        if (!settingsFile2.exists()) {
            boolean bl = false;
            String string2 = "Settings file was not found";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.hive != null) {
            logger.info("Parsing " + this.hive);
        }
        Document document = new SAXBuilder().build(settingsFile2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"build(...)");
        this.document = document;
        logger.info("Parsing file " + settingsFile2.getAbsolutePath());
        Element element = this.document.getRootElement().getChild(applicationIdentity);
        String string3 = element != null && (element = element.getAttribute(versionAttr)) != null ? element.getValue() : (string = null);
        if (string == null) {
            throw new VSXmlParserException("Can't find version");
        }
        String verStr = string;
        Version2 version2 = Version2.Companion.parse(verStr);
        if (version2 == null) {
            throw new VSXmlParserException("Can't parse version");
        }
        this.ver = version2;
        Element element2 = this.document.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"getRootElement(...)");
        this.categoryDigger(this.ver, element2);
    }

    public /* synthetic */ VSXmlParser(File file, VSHive vSHive, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vSHive = null;
        }
        this(file, vSHive);
    }

    @NotNull
    public final Settings getAllSettings() {
        return this.allSettings;
    }

    @NotNull
    public final Version2 getVer() {
        return this.ver;
    }

    @NotNull
    public final Settings toSettings() {
        return this.allSettings;
    }

    private final void categoryDigger(Version2 version, Element rtElement) {
        for (Element el : rtElement.getChildren()) {
            String name;
            VSParsedData disp;
            VSParsedData vSParsedData;
            block9: {
                block8: {
                    if (Intrinsics.areEqual((Object)el.getName(), (Object)applicationIdentity)) continue;
                    if (Intrinsics.areEqual((Object)el.getName(), (Object)toolsOptions)) break block8;
                    if (!Intrinsics.areEqual((Object)el.getName(), (Object)category)) break block9;
                    Attribute attribute2 = el.getAttribute(nameAttr);
                    if (!Intrinsics.areEqual((Object)(attribute2 != null ? attribute2.getValue() : null), (Object)envGroup)) break block9;
                }
                Intrinsics.checkNotNull((Object)el);
                this.categoryDigger(version, el);
                continue;
            }
            Intrinsics.checkNotNull((Object)el);
            if (this.parserDispatcher(version, el, this.hive) != null) {
                Function0<VSParsedData> it;
                boolean bl = false;
                vSParsedData = (VSParsedData)it.invoke();
            } else {
                vSParsedData = null;
            }
            if ((disp = vSParsedData) == null) continue;
            Attribute attribute3 = el.getAttribute(nameAttr);
            String string = name = attribute3 != null ? attribute3.getValue() : null;
            if (name == null) {
                logger.info("This should not happen. For some reason there is no name attribute");
                continue;
            }
            VSParsedData vSParsedData2 = disp;
            if (vSParsedData2 instanceof FontsAndColorsParsedData) {
                this.allSettings.setLaf(((FontsAndColorsParsedData)disp).getTheme().toRiderTheme());
                continue;
            }
            if (!(vSParsedData2 instanceof KeyBindingsParsedData)) continue;
            List<KeyBinding> format = ((KeyBindingsParsedData)disp).convertToSettingsFormat();
            Keymap oldKeymap = this.allSettings.getKeymap();
            if (!(!((Collection)format).isEmpty()) || oldKeymap == null) continue;
            this.allSettings.setKeymap(new PatchedKeymap(oldKeymap.getTransferableId(), oldKeymap, ((KeyBindingsParsedData)disp).convertToSettingsFormat(), CollectionsKt.emptyList()));
        }
    }

    private final Function0<VSParsedData> parserDispatcher(Version2 version, Element el, VSHive hive) {
        String string;
        Attribute attribute2 = el.getAttribute(nameAttr);
        String string2 = string = attribute2 != null ? attribute2.getValue() : null;
        return Intrinsics.areEqual((Object)string, (Object)"Environment_FontsAndColors") ? (Function0)new Function0<VSParsedData>(version, el){
            final /* synthetic */ Version2 $version;
            final /* synthetic */ Element $el;
            {
                this.$version = $version;
                this.$el = $el;
                super(0);
            }

            @Nullable
            public final VSParsedData invoke() {
                return VSParsedDataCreator.INSTANCE.fontsAndColors(this.$version, this.$el);
            }
        } : (Intrinsics.areEqual((Object)string, (Object)"Environment_KeyBindings") ? (Function0)new Function0<VSParsedData>(version, el, hive){
            final /* synthetic */ Version2 $version;
            final /* synthetic */ Element $el;
            final /* synthetic */ VSHive $hive;
            {
                this.$version = $version;
                this.$el = $el;
                this.$hive = $hive;
                super(0);
            }

            @Nullable
            public final VSParsedData invoke() {
                return VSParsedDataCreator.INSTANCE.keyBindings(this.$version, this.$el, this.$hive);
            }
        } : null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSXmlParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VSXmlParser.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser$Companion;", "", "()V", "applicationIdentity", "", "category", "envGroup", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "nameAttr", "toolsOptions", "versionAttr", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

