/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.vscode.parsers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.LegacySettingsTransferWizard;
import com.intellij.ide.startup.importSettings.vscode.parsers.StateDatabaseParserKt;
import com.intellij.ide.startup.importSettings.vscode.parsers.StorageParser;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/startup/importSettings/vscode/parsers/StateDatabaseParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "recentsKey", "", "getKey", "connection", "Ljava/sql/Connection;", "key", "parseRecents", "", "process", "file", "Ljava/io/File;", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nStateDatabaseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateDatabaseParser.kt\ncom/intellij/ide/startup/importSettings/vscode/parsers/StateDatabaseParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1603#2,9:68\n1855#2:77\n1856#2:79\n1612#2:80\n1855#2,2:81\n1#3:78\n*S KotlinDebug\n*F\n+ 1 StateDatabaseParser.kt\ncom/intellij/ide/startup/importSettings/vscode/parsers/StateDatabaseParser\n*L\n47#1:68,9\n47#1:77\n47#1:79\n47#1:80\n49#1:81,2\n47#1:78\n*E\n"})
public final class StateDatabaseParser {
    @NotNull
    private final Settings settings;
    @NotNull
    private final String recentsKey;

    public StateDatabaseParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.recentsKey = "history.recentlyOpenedPathsList";
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LegacySettingsTransferWizard.INSTANCE.warnBackgroundThreadIfNotLegacy();
        try {
            Class.forName("org.sqlite.JDBC");
            Connection connection = DriverManager.getConnection("jdbc:sqlite:" + FileUtil.toSystemIndependentName((String)file.getPath()));
            Intrinsics.checkNotNull((Object)connection);
            this.parseRecents(connection);
        }
        catch (Throwable t) {
            this.settings.getNotes().put("vscode.databaseState", false);
            StateDatabaseParserKt.access$getLogger$p().warn(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseRecents(Connection connection) {
        void $this$mapNotNullTo$iv$iv;
        String string = this.getKey(connection, this.recentsKey);
        if (string == null) {
            return;
        }
        String recentProjectsRaw = string;
        JsonNode jsonNode = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS)).readTree(recentProjectsRaw);
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            throw new IllegalStateException(("Unexpected JSON data; expected: " + JsonNodeType.OBJECT).toString());
        }
        ObjectNode root = objectNode;
        JsonNode jsonNode2 = root.get("entries");
        Intrinsics.checkNotNull((Object)jsonNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
        Iterable $this$mapNotNull$iv = (Iterable)((ArrayNode)jsonNode2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl2 = false;
            JsonNode jsonNode3 = it.get("folderUri");
            if ((jsonNode3 != null ? jsonNode3.textValue() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String uri = (String)element$iv;
            boolean bl = false;
            RecentPathInfo res2 = StorageParser.Companion.parsePath$intellij_ide_startup_importSettings(uri);
            if (res2 == null) continue;
            this.settings.getRecentProjects().add(res2);
        }
    }

    private final String getKey(Connection connection, String key) {
        String query = "SELECT value FROM ItemTable WHERE key is '" + key + "' LIMIT 1";
        ResultSet res2 = connection.createStatement().executeQuery(query);
        if (!res2.next()) {
            return null;
        }
        return res2.getString("value");
    }
}

