/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.vscode.parsers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.startup.importSettings.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.BundledLookAndFeel;
import com.intellij.ide.startup.importSettings.models.EditorColorScheme;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vscode.mappings.ThemesMappings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/startup/importSettings/vscode/parsers/StorageParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "process", "", "file", "Ljava/io/File;", "processRecentProjects", "root", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "processThemeAndScheme", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nStorageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/vscode/parsers/StorageParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n11#2:133\n1360#3:134\n1446#3,5:135\n1603#3,9:140\n1855#3:149\n1856#3:151\n1612#3:152\n1603#3,9:153\n1855#3,2:162\n1612#3:164\n1603#3,9:165\n1855#3:174\n1856#3:176\n1612#3:177\n1855#3,2:178\n1#4:150\n1#4:175\n*S KotlinDebug\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/vscode/parsers/StorageParser\n*L\n26#1:133\n82#1:134\n82#1:135,5\n84#1:140,9\n84#1:149\n84#1:151\n84#1:152\n84#1:153,9\n84#1:162,2\n84#1:164\n90#1:165,9\n90#1:174\n90#1:176\n90#1:177\n98#1:178,2\n84#1:150\n90#1:175\n*E\n"})
public final class StorageParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final String OPENED_PATHS = "openedPathsList";
    @NotNull
    private static final String WORKSPACES = "workspaces";
    @NotNull
    private static final String WORKSPACES_2 = "workspaces2";
    @NotNull
    private static final String WORKSPACES_3 = "workspaces3";
    @NotNull
    private static final String THEME = "theme";

    public StorageParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StorageParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            this.logger.info("Processing a storage file: " + file);
            JsonNode jsonNode = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS)).readTree(file);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                throw new IllegalStateException(("Unexpected JSON data; expected: " + JsonNodeType.OBJECT).toString());
            }
            ObjectNode root = objectNode;
            this.processRecentProjects(root);
            this.processThemeAndScheme(root);
        }
        catch (Throwable t) {
            this.logger.warn(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processRecentProjects(ObjectNode root) {
        try {
            Iterable workspaces;
            Iterable iterable;
            Iterable $this$mapNotNull$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNull$iv2;
            void $this$flatMapTo$iv$iv;
            JsonNode jsonNode = root.get(OPENED_PATHS);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                return;
            }
            ObjectNode openedPaths = objectNode;
            Iterable $this$flatMap$iv = CollectionsKt.toList((Iterable)((Iterable)openedPaths));
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
                Iterable list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)((ArrayNode)it)));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List flatList = (List)destination$iv$iv;
            try {
                Object it$iv$iv;
                boolean bl;
                JsonNode it;
                boolean bl2;
                Object element$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv2 = flatList;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator bl3 = $this$forEach$iv$iv$iv.iterator();
                while (bl3.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = bl3.next();
                    bl2 = false;
                    it = (JsonNode)element$iv$iv;
                    boolean bl4 = false;
                    if (it.get("folderUri") == null) continue;
                    bl = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv2;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv2;
                destination$iv$iv2 = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                bl3 = $this$forEach$iv$iv$iv.iterator();
                while (bl3.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = bl3.next();
                    bl2 = false;
                    it = (JsonNode)element$iv$iv;
                    boolean bl5 = false;
                    if (it.textValue() == null) continue;
                    bl = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv2;
            }
            catch (Throwable t) {
                $this$mapNotNull$iv2 = null;
            }
            Iterable workspacesNew = $this$mapNotNull$iv2;
            try {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = flatList;
                boolean $i$f$mapNotNull = false;
                Iterable destination$iv$iv3 = $this$mapNotNull$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                element$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
                while (element$iv$iv$iv.hasNext()) {
                    String string;
                    String string2;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = element$iv$iv$iv.next();
                    boolean bl = false;
                    JsonNode it = (JsonNode)element$iv$iv;
                    boolean bl6 = false;
                    String string3 = string2 = it.textValue();
                    if (string3 == null) {
                        string = null;
                    } else {
                        Intrinsics.checkNotNull((Object)string3);
                        string = string2;
                    }
                    if (string == null) continue;
                    String it$iv$iv = string;
                    boolean bl7 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv4;
            }
            catch (Throwable t) {
                $this$mapNotNull$iv = null;
            }
            Iterable workspacesOld = $this$mapNotNull$iv;
            Collection t = (Collection)workspacesNew;
            if (!(t == null || t.isEmpty())) {
                iterable = workspacesNew;
            } else {
                iterable = workspacesOld;
                if (iterable == null) {
                    return;
                }
            }
            Iterable $this$forEach$iv = workspaces = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uri = (String)element$iv;
                boolean bl = false;
                try {
                    RecentPathInfo res2 = Companion.parsePath$intellij_ide_startup_importSettings(uri);
                    if (res2 == null) continue;
                    this.settings.getRecentProjects().add(res2);
                }
                catch (Throwable t2) {
                    this.logger.warn(t2);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn(t);
        }
    }

    private final void processThemeAndScheme(ObjectNode root) {
        try {
            JsonNode jsonNode = root.get(THEME);
            String string = jsonNode != null ? jsonNode.textValue() : null;
            if (string == null) {
                return;
            }
            String theme2 = string;
            BundledLookAndFeel laf = ThemesMappings.INSTANCE.themeMap(theme2);
            this.settings.setLaf(laf);
            this.settings.setSyntaxScheme(Intrinsics.areEqual((Object)laf, (Object)KnownLafs.INSTANCE.getLight()) ? (EditorColorScheme)KnownColorSchemes.INSTANCE.getLight() : (EditorColorScheme)KnownColorSchemes.INSTANCE.getDarcula());
        }
        catch (Throwable t) {
            this.logger.warn(t);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/startup/importSettings/vscode/parsers/StorageParser$Companion;", "", "()V", "OPENED_PATHS", "", "THEME", "WORKSPACES", "WORKSPACES_2", "WORKSPACES_3", "parsePath", "Lcom/intellij/ide/startup/importSettings/models/RecentPathInfo;", "uri", "parsePath$intellij_ide_startup_importSettings", "workaroundWindowsIssue", "input", "intellij.ide.startup.importSettings"})
    @SourceDebugExtension(value={"SMAP\nStorageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/vscode/parsers/StorageParser$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,132:1\n13896#2,14:133\n*S KotlinDebug\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/vscode/parsers/StorageParser$Companion\n*L\n37#1:133,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final RecentPathInfo parsePath$intellij_ide_startup_importSettings(@NotNull String uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            v0 = Path.of(new URI(uri));
            if (v0 == null) {
                return null;
            }
            path = v0;
            v1 = path.toFile().listFiles();
            if (v1 == null) ** GOTO lbl-1000
            $this$maxByOrNull$iv = v1;
            $i$f$maxByOrNull = false;
            if ($this$maxByOrNull$iv.length == 0) {
                v2 = null;
            } else {
                maxElem$iv = $this$maxByOrNull$iv[0];
                lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                if (lastIndex$iv == 0) {
                    v2 = maxElem$iv;
                } else {
                    it = maxElem$iv;
                    $i$a$-maxByOrNull-StorageParser$Companion$parsePath$modifiedTime$1 = false;
                    maxValue$iv = it.lastModified();
                    var12_10 = new IntRange(1, lastIndex$iv).iterator();
                    while (var12_10.hasNext()) {
                        i$iv = var12_10.nextInt();
                        it = e$iv = $this$maxByOrNull$iv[i$iv];
                        $i$a$-maxByOrNull-StorageParser$Companion$parsePath$modifiedTime$1 = false;
                        v$iv = it.lastModified();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    v2 = v1 = maxElem$iv;
                }
            }
            if (v2 != null) {
                v3 = v1.lastModified();
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            modifiedTime = v3;
            $this$parsePath_u24lambda_u241 = var5_17 /* !! */  = new RecentProjectMetaInfo();
            $i$a$-apply-StorageParser$Companion$parsePath$info$1 = false;
            v4 = modifiedTime;
            $this$parsePath_u24lambda_u241.setProjectOpenTimestamp(v4 != null ? v4 : 0L);
            $this$parsePath_u24lambda_u241.setBuildTimestamp($this$parsePath_u24lambda_u241.getProjectOpenTimestamp());
            $this$parsePath_u24lambda_u241.setDisplayName(path.getFileName().toString());
            info = var5_17 /* !! */ ;
            if (Registry.is((String)"transferSettings.vscode.onlyCargoToml")) {
                v5 = path.resolve("Cargo.toml");
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"resolve(...)");
                var5_17 /* !! */  = v5;
                var6_3 = new LinkOption[]{};
                if (!Files.exists((Path)var5_17 /* !! */ , Arrays.copyOf(var6_3, var6_3.length))) {
                    return null;
                }
            }
            return new RecentPathInfo(this.workaroundWindowsIssue(path.toAbsolutePath().toString()), info);
        }

        private final String workaroundWindowsIssue(String input) {
            if (!SystemInfo.isWindows) {
                return input;
            }
            if (input.length() < 3) {
                return input;
            }
            if (input.charAt(1) != ':') {
                return input;
            }
            String string = String.valueOf(input.charAt(0));
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return string2 + input.subSequence(1, input.length());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

