/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.services;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.ml.embeddings.EmbeddingsBundle;
import com.intellij.platform.ml.embeddings.services.CustomRootDataLoader;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\rH\u0002J$\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0087@\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/ml/embeddings/services/LocalArtifactsManager;", "", "()V", "downloadCanceled", "", "downloadContext", "Lkotlinx/coroutines/CoroutineDispatcher;", "failNotificationShown", "modelArtifactsRoot", "Ljava/io/File;", "root", "checkArtifactsPresent", "downloadArtifacts", "", "downloadArtifactsIfNecessary", "project", "Lcom/intellij/openapi/project/Project;", "retryIfCanceled", "(Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCustomRootDataLoader", "Lcom/intellij/platform/ml/embeddings/services/CustomRootDataLoader;", "getModelVersion", "", "unpackArtifactsArchive", "archiveFile", "destination", "Companion", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nLocalArtifactsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalArtifactsManager.kt\ncom/intellij/platform/ml/embeddings/services/LocalArtifactsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n1#2:138\n766#3:139\n857#3,2:140\n1855#3,2:142\n46#4,5:144\n46#4,5:149\n*S KotlinDebug\n*F\n+ 1 LocalArtifactsManager.kt\ncom/intellij/platform/ml/embeddings/services/LocalArtifactsManager\n*L\n47#1:139\n47#1:140,2\n47#1:142,2\n89#1:144,5\n93#1:149,5\n*E\n"})
public final class LocalArtifactsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File root;
    @NotNull
    private final File modelArtifactsRoot;
    @NotNull
    private final CoroutineDispatcher downloadContext;
    private boolean failNotificationShown;
    private boolean downloadCanceled;
    @NotNull
    public static final String SEMANTIC_SEARCH_RESOURCES_DIR = "semantic-search";
    @NotNull
    private static final String MODEL_ARTIFACTS_DIR = "models";
    @NotNull
    private static final String ARCHIVE_NAME = "semantic-text-search.jar";
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "Semantic search";
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public LocalArtifactsManager() {
        void $this$filterTo$iv$iv;
        void it;
        File file;
        File file2 = file = FilesKt.resolve((File)FilesKt.resolve((File)new File(PathManager.getSystemPath()), (String)SEMANTIC_SEARCH_RESOURCES_DIR), (String)LocalArtifactsManager.Companion.getMODEL_VERSION());
        LocalArtifactsManager localArtifactsManager = this;
        boolean $i$a$-also-LocalArtifactsManager$root$22 = false;
        Files.createDirectories(it.toPath(), new FileAttribute[0]);
        localArtifactsManager.root = file;
        this.modelArtifactsRoot = FilesKt.resolve((File)this.root, (String)MODEL_ARTIFACTS_DIR);
        this.downloadContext = Dispatchers.getIO().limitedParallelism(1);
        Path path = this.root.getParentFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable $i$a$-also-LocalArtifactsManager$root$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it2 = (Path)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)PathsKt.getName((Path)it2), (Object)LocalArtifactsManager.Companion.getMODEL_VERSION()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it3 = (Path)element$iv;
            boolean bl = false;
            PathKt.delete((Path)it3, (boolean)true);
        }
    }

    @NotNull
    public final CustomRootDataLoader getCustomRootDataLoader() {
        Path path = this.modelArtifactsRoot.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return new CustomRootDataLoader(path);
    }

    @RequiresBackgroundThread
    @Nullable
    public final Object downloadArtifactsIfNecessary(@Nullable Project project, boolean retryIfCanceled, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.downloadContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, retryIfCanceled, project, null){
            int label;
            final /* synthetic */ LocalArtifactsManager this$0;
            final /* synthetic */ boolean $retryIfCanceled;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$retryIfCanceled = $retryIfCanceled;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block6: {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object object3;
                            ResultKt.throwOnFailure((Object)object);
                            if (!(this.this$0.checkArtifactsPresent() || ApplicationManager.getApplication().isUnitTestMode() || !this.$retryIfCanceled && LocalArtifactsManager.access$getDownloadCanceled$p(this.this$0))) {
                                LocalArtifactsManager.access$getLogger$cp().debug("Semantic search artifacts are not present, starting the download...");
                                if (this.$project == null) break;
                                this.label = 1;
                                object3 = TasksKt.withBackgroundProgress((Project)this.$project, (String)com.intellij.platform.ml.embeddings.services.LocalArtifactsManager$Companion.access$getARTIFACTS_DOWNLOAD_TASK_NAME(LocalArtifactsManager.Companion), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ LocalArtifactsManager this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<Unit>(this.this$0){
                                                    final /* synthetic */ LocalArtifactsManager this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(0);
                                                    }

                                                    public final void invoke() {
                                                        LocalArtifactsManager.access$downloadArtifacts(this.this$0);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                Object object3;
                                                try {
                                                    void $result;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    object3 = $result;
                                                    return Unit.INSTANCE;
                                                }
                                                catch (CancellationException e) {
                                                    LocalArtifactsManager.access$getLogger$cp().debug("Artifacts downloading was canceled");
                                                    LocalArtifactsManager.access$setDownloadCanceled$p(this.this$0, true);
                                                    throw e;
                                                }
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 == object2) {
                                    return object2;
                                }
                            }
                            break block6;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            break block6;
                        }
                    }
                    LocalArtifactsManager.access$downloadArtifacts(this.this$0);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object downloadArtifactsIfNecessary$default(LocalArtifactsManager localArtifactsManager, Project project, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return localArtifactsManager.downloadArtifactsIfNecessary(project, bl, (Continuation<? super Unit>)continuation);
    }

    @NotNull
    public final String getModelVersion() {
        return LocalArtifactsManager.Companion.getMODEL_VERSION();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkArtifactsPresent() {
        if (!Files.isDirectory(this.modelArtifactsRoot.toPath(), new LinkOption[0])) return false;
        Path path = this.modelArtifactsRoot.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        if (((Collection)PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null)).isEmpty()) return false;
        return true;
    }

    private final void downloadArtifacts() {
        block4: {
            Files.createDirectories(this.root.toPath(), new FileAttribute[0]);
            try {
                Logger logger;
                DownloadableFileService $this$downloadArtifacts_u24lambda_u243 = DownloadableFileService.getInstance();
                boolean bl = false;
                $this$downloadArtifacts_u24lambda_u243.createDownloader(CollectionsKt.listOf((Object)$this$downloadArtifacts_u24lambda_u243.createFileDescription(LocalArtifactsManager.Companion.getMAVEN_ROOT(), ARCHIVE_NAME)), LocalArtifactsManager.Companion.getARTIFACTS_DOWNLOAD_TASK_NAME()).download(this.root);
                Logger $this$debug_u24default$iv = LocalArtifactsManager.logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("Downloaded archive with search artifacts into " + this.root.getAbsoluteFile(), e$iv);
                }
                FilesKt.deleteRecursively((File)this.modelArtifactsRoot);
                this.unpackArtifactsArchive(FilesKt.resolve((File)this.root, (String)ARCHIVE_NAME), this.root);
                $this$debug_u24default$iv = LocalArtifactsManager.logger;
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl3 = false;
                    logger.debug("Extracted model artifacts into the " + this.root.getAbsoluteFile(), e$iv);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to download semantic search artifacts: " + e);
                if (this.failNotificationShown) break block4;
                LocalArtifactsManager.Companion.showDownloadErrorNotification();
                this.failNotificationShown = true;
            }
        }
    }

    private final void unpackArtifactsArchive(File archiveFile, File destination) {
        new Decompressor.Zip(archiveFile).overwrite(false).extract(destination);
        archiveFile.delete();
    }

    public static final /* synthetic */ boolean access$getDownloadCanceled$p(LocalArtifactsManager $this) {
        return $this.downloadCanceled;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$downloadArtifacts(LocalArtifactsManager $this) {
        $this.downloadArtifacts();
    }

    public static final /* synthetic */ void access$setDownloadCanceled$p(LocalArtifactsManager $this, boolean bl) {
        $this.downloadCanceled = bl;
    }

    static {
        Logger logger = Logger.getInstance(LocalArtifactsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LocalArtifactsManager.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\f0\u0004\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/ml/embeddings/services/LocalArtifactsManager$Companion;", "", "()V", "ARCHIVE_NAME", "", "ARTIFACTS_DOWNLOAD_TASK_NAME", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getARTIFACTS_DOWNLOAD_TASK_NAME", "()Ljava/lang/String;", "MAVEN_ROOT", "getMAVEN_ROOT", "MODEL_ARTIFACTS_DIR", "MODEL_VERSION", "getMODEL_VERSION", "NOTIFICATION_GROUP_ID", "SEMANTIC_SEARCH_RESOURCES_DIR", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/platform/ml/embeddings/services/LocalArtifactsManager;", "showDownloadErrorNotification", "", "intellij.platform.ml.embeddings"})
    @SourceDebugExtension(value={"SMAP\nLocalArtifactsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalArtifactsManager.kt\ncom/intellij/platform/ml/embeddings/services/LocalArtifactsManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,137:1\n43#2,3:138\n*S KotlinDebug\n*F\n+ 1 LocalArtifactsManager.kt\ncom/intellij/platform/ml/embeddings/services/LocalArtifactsManager$Companion\n*L\n125#1:138,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getARTIFACTS_DOWNLOAD_TASK_NAME() {
            String string = EmbeddingsBundle.INSTANCE.getMessage("ml.embeddings.artifacts.download.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            return string;
        }

        private final String getMODEL_VERSION() {
            String string = Registry.stringValue((String)"intellij.platform.ml.embeddings.model.version");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
            return string;
        }

        private final String getMAVEN_ROOT() {
            String string = Registry.stringValue((String)"intellij.platform.ml.embeddings.model.artifacts.link");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
            return StringsKt.replace$default((String)string, (String)"%MODEL_VERSION%", (String)this.getMODEL_VERSION(), (boolean)false, (int)4, null);
        }

        @NotNull
        public final LocalArtifactsManager getInstance() {
            boolean $i$f$service = false;
            Class<LocalArtifactsManager> serviceClass$iv = LocalArtifactsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (LocalArtifactsManager)object;
        }

        private final void showDownloadErrorNotification() {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(LocalArtifactsManager.NOTIFICATION_GROUP_ID);
            String string = EmbeddingsBundle.INSTANCE.getMessage("ml.embeddings.notification.model.downloading.failed.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            String string2 = EmbeddingsBundle.INSTANCE.getMessage("ml.embeddings.notification.model.downloading.failed.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

