/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.serialization.xml.KotlinAwareBeanBinding;
import com.intellij.serialization.xml.KotlinxSerializationBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u0010\u000b\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u001c\u0010\u000b\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/settings/local/BindingProducer;", "Lcom/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase;", "()V", "cache", "", "Ljava/lang/Class;", "Lcom/intellij/util/xmlb/Binding;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "createRootBinding", "aClass", "getRootBinding", "originalType", "Ljava/lang/reflect/Type;", "intellij.platform.settings.local"})
final class BindingProducer
extends XmlSerializerImpl.XmlSerializerBase {
    @NotNull
    private final Map<Class<?>, Binding> cache = new HashMap();
    @NotNull
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Binding getRootBinding(@NotNull Class<?> aClass) {
        Binding binding;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Binding binding2 = this.cache.get(aClass);
            binding = binding2;
        }
        finally {
            readLock.unlock();
        }
        Binding binding3 = binding;
        if (binding == null) {
            ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
            readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                Binding binding4 = this.cache.get(aClass);
                if (binding4 != null) {
                    Binding it = binding4;
                    boolean bl2 = false;
                    Binding binding5 = it;
                    return binding5;
                }
                Binding binding6 = this.createRootBinding(aClass);
                binding3 = binding6;
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        return binding3;
    }

    @NotNull
    public Binding getRootBinding(@NotNull Class<?> aClass, @NotNull Type originalType) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        if (!(aClass == originalType)) {
            boolean bl = false;
            String string = "Expect that class " + aClass + " is same as originalType " + originalType;
            throw new IllegalArgumentException(string.toString());
        }
        return this.getRootBinding(aClass);
    }

    private final Binding createRootBinding(Class<?> aClass) {
        Binding binding = XmlSerializerImpl.XmlSerializerBase.createClassBinding(aClass, null, (Type)aClass);
        if (binding == null) {
            binding = aClass.isAnnotationPresent(Serializable.class) ? (Binding)new KotlinxSerializationBinding(aClass) : (Binding)new KotlinAwareBeanBinding(aClass);
        }
        this.cache.put(aClass, binding);
        try {
            binding.init((Type)aClass, XmlSerializerKt.__platformSerializer());
        }
        catch (Throwable e) {
            this.cache.remove(aClass);
            throw e;
        }
        return binding;
    }
}

