/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0016"}, d2={"cborFactory", "Lcom/fasterxml/jackson/dataformat/cbor/CBORFactory;", "getCborFactory", "()Lcom/fasterxml/jackson/dataformat/cbor/CBORFactory;", "decodeCborToXml", "Lorg/jdom/Element;", "input", "", "encodeXmlToCbor", "element", "readAttributes", "", "reader", "Lcom/fasterxml/jackson/dataformat/cbor/CBORParser;", "readElement", "writeAttributes", "attributes", "", "Lorg/jdom/Attribute;", "out", "Lcom/fasterxml/jackson/dataformat/cbor/CBORGenerator;", "writeElement", "intellij.platform.settings.local"})
@SourceDebugExtension(value={"SMAP\nCborXml.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborXml.kt\ncom/intellij/platform/settings/local/CborXmlKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n11#2:127\n*S KotlinDebug\n*F\n+ 1 CborXml.kt\ncom/intellij/platform/settings/local/CborXmlKt\n*L\n66#1:127\n*E\n"})
public final class CborXmlKt {
    @NotNull
    private static final CBORFactory cborFactory;

    @NotNull
    public static final CBORFactory getCborFactory() {
        return cborFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] encodeXmlToCbor(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BufferExposingByteArrayOutputStream b = new BufferExposingByteArrayOutputStream();
        CBORGenerator out = cborFactory.createGenerator((OutputStream)b);
        Closeable closeable = (Closeable)((Object)out);
        Throwable throwable = null;
        try {
            CBORGenerator it = (CBORGenerator)((Object)closeable);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((Object)out));
            CborXmlKt.writeElement(element, out);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = b.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Element decodeCborToXml(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Closeable closeable = (Closeable)((Object)cborFactory.createParser(input));
        Throwable throwable = null;
        try {
            boolean bl;
            CBORParser it = (CBORParser)((Object)closeable);
            boolean bl2 = false;
            boolean bl3 = bl = it.nextToken() == JsonToken.START_OBJECT;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Intrinsics.checkNotNull((Object)((Object)it));
            Element element = CborXmlKt.readElement(it);
            return element;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Element readElement(CBORParser reader) {
        String string = reader.nextFieldName();
        Intrinsics.checkNotNull((Object)string);
        String field = string;
        boolean bl = Intrinsics.areEqual((Object)field, (Object)"t");
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = reader.nextTextValue();
        Intrinsics.checkNotNull((Object)string3);
        Element element = new Element(string3);
        block6: while (true) {
            if ((field = reader.nextFieldName()) == null) {
                boolean bl2;
                boolean bl3 = bl2 = reader.currentToken() == JsonToken.END_OBJECT;
                if (!_Assertions.ENABLED || bl2) break;
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            if (Intrinsics.areEqual((Object)field, (Object)"a")) {
                CborXmlKt.readAttributes(reader, element);
                continue;
            }
            if (Intrinsics.areEqual((Object)field, (Object)"c")) {
                JsonToken token;
                boolean bl4;
                boolean bl5 = bl4 = reader.nextToken() == JsonToken.START_ARRAY;
                if (_Assertions.ENABLED && !bl4) {
                    String string5 = "Assertion failed";
                    throw new AssertionError((Object)string5);
                }
                block7: while (true) {
                    JsonToken jsonToken = token = reader.nextToken();
                    switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                        case 1: {
                            continue block6;
                        }
                        case 2: {
                            element.addContent(CborXmlKt.readElement(reader));
                            continue block7;
                        }
                        case 3: {
                            element.addContent((Content)new Text(reader.getValueAsString()));
                            continue block7;
                        }
                        case 4: {
                            String string6 = reader.nextTextValue();
                            Intrinsics.checkNotNull((Object)string6);
                            element.addContent((Content)new CDATA(string6));
                            continue block7;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Unexpected token: " + token);
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(Element.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unknown property: " + field);
            reader.nextToken();
            reader.skipChildren();
        }
        return element;
    }

    private static final void readAttributes(CBORParser reader, Element element) {
        boolean bl;
        boolean bl2 = bl = reader.nextToken() == JsonToken.START_OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        while (reader.nextToken() != JsonToken.END_OBJECT) {
            String name = reader.getCurrentName();
            String value = reader.nextTextValue();
            element.setAttribute(new Attribute(name, value));
        }
    }

    private static final void writeElement(Element element, CBORGenerator out) {
        out.writeStartObject();
        out.writeStringField("t", element.getName());
        if (element.hasAttributes()) {
            List list = element.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
            CborXmlKt.writeAttributes(list, out);
        }
        List list = element.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        if (!((Collection)list).isEmpty()) {
            out.writeFieldName("c");
            out.writeStartArray();
            for (Content item : element.getContent()) {
                String text2;
                Content content2 = item;
                if (content2 instanceof Element) {
                    Intrinsics.checkNotNull((Object)item);
                    CborXmlKt.writeElement((Element)item, out);
                    continue;
                }
                if (content2 instanceof CDATA) {
                    if (((CDATA)item).getText() == null) continue;
                    out.writeBoolean(false);
                    out.writeString(((CDATA)item).getText());
                    continue;
                }
                if (!(content2 instanceof Text) || (text2 = ((Text)item).getText()) == null || Verifier.isAllXMLWhitespace((String)text2)) continue;
                out.writeString(((Text)item).getText());
            }
            out.writeEndArray();
        }
        out.writeEndObject();
    }

    private static final void writeAttributes(List<? extends Attribute> attributes, CBORGenerator out) {
        out.writeFieldName("a");
        out.writeStartObject(attributes.size());
        for (Attribute attribute2 : attributes) {
            out.writeStringField(attribute2.getName(), attribute2.getValue());
        }
        out.writeEndObject();
    }

    static {
        CBORFactory cBORFactory = new CBORFactory().configure(CBORGenerator.Feature.STRINGREF, true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cBORFactory), (String)"configure(...)");
        cborFactory = cBORFactory;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.END_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.START_OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_FALSE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

