/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.platform.settings.SettingDescriptor;
import com.intellij.platform.settings.local.BindingProducer;
import com.intellij.platform.settings.local.CborXmlKt;
import com.intellij.platform.settings.local.InternalStateStorageServiceKt;
import com.intellij.platform.settings.local.StateStorageBackedByController;
import com.intellij.serialization.xml.KotlinxSerializationBinding;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J \u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J$\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/settings/local/ControllerBackedSaveSessionProducer;", "Lcom/intellij/configurationStore/SaveSessionProducer;", "bindingProducer", "Lcom/intellij/platform/settings/local/BindingProducer;", "storageController", "Lcom/intellij/platform/settings/local/StateStorageBackedByController;", "(Lcom/intellij/platform/settings/local/BindingProducer;Lcom/intellij/platform/settings/local/StateStorageBackedByController;)V", "createSaveSession", "Lcom/intellij/configurationStore/SaveSession;", "put", "", "key", "Lcom/intellij/platform/settings/SettingDescriptor;", "", "value", "putJdomElement", "state", "Lorg/jdom/Element;", "setState", "component", "", "componentName", "", "intellij.platform.settings.local"})
@SourceDebugExtension(value={"SMAP\nStateStorageBackedByController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateStorageBackedByController.kt\ncom/intellij/platform/settings/local/ControllerBackedSaveSessionProducer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,271:1\n9#2:272\n*S KotlinDebug\n*F\n+ 1 StateStorageBackedByController.kt\ncom/intellij/platform/settings/local/ControllerBackedSaveSessionProducer\n*L\n218#1:272\n*E\n"})
final class ControllerBackedSaveSessionProducer
implements SaveSessionProducer {
    @NotNull
    private final BindingProducer bindingProducer;
    @NotNull
    private final StateStorageBackedByController storageController;

    public ControllerBackedSaveSessionProducer(@NotNull BindingProducer bindingProducer, @NotNull StateStorageBackedByController storageController) {
        Intrinsics.checkNotNullParameter((Object)((Object)bindingProducer), (String)"bindingProducer");
        Intrinsics.checkNotNullParameter((Object)storageController, (String)"storageController");
        this.bindingProducer = bindingProducer;
        this.storageController = storageController;
    }

    private final void put(SettingDescriptor<byte[]> key, byte[] value) {
        this.storageController.controller.setItem(key, value);
    }

    public void setState(@Nullable Object component, @NotNull String componentName, @Nullable Object state) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        SettingDescriptor<byte[]> settingDescriptor = this.storageController.createSettingDescriptor$intellij_platform_settings_local(componentName);
        if (state == null) {
            this.put(settingDescriptor, null);
            return;
        }
        Object object = state;
        if (object instanceof Element) {
            this.putJdomElement(settingDescriptor, (Element)state);
        } else if (object instanceof JDOMExternalizable) {
            Element element = new Element("component");
            ((JDOMExternalizable)state).writeExternal(element);
            this.putJdomElement(settingDescriptor, element);
        } else {
            Class<?> aClass = state.getClass();
            Binding beanBinding = this.bindingProducer.getRootBinding(aClass);
            if (beanBinding instanceof KotlinxSerializationBinding) {
                this.put(settingDescriptor, InternalStateStorageServiceKt.getCborFormat().encodeToByteArray((SerializationStrategy)((KotlinxSerializationBinding)beanBinding).serializer, state));
            } else {
                SkipDefaultsSerializationFilter filter2 = XmlSerializer.getJdomSerializer().getDefaultSerializationFilter();
                Intrinsics.checkNotNull((Object)beanBinding, (String)"null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
                Intrinsics.checkNotNull((Object)((BeanBinding)beanBinding).bindings);
                for (NestedBinding binding : ((BeanBinding)beanBinding).bindings) {
                    if (state instanceof SerializationFilter && !((SerializationFilter)state).accepts((Accessor)binding.getAccessor(), state)) continue;
                    Element element = ((BeanBinding)beanBinding).serializePropertyInto(binding, state, null, (SerializationFilter)filter2, true);
                    String string = binding.getAccessor().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.putJdomElement((SettingDescriptor<byte[]>)settingDescriptor.withSubName(string), element);
                }
            }
        }
    }

    private final void putJdomElement(SettingDescriptor<byte[]> key, Element state) {
        if (state == null || state.isEmpty()) {
            return;
        }
        try {
            this.put(key, CborXmlKt.encodeXmlToCbor(state));
        }
        catch (Throwable e) {
            ControllerBackedSaveSessionProducer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ControllerBackedSaveSessionProducer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot serialize value for " + key, e);
        }
    }

    @Nullable
    public SaveSession createSaveSession() {
        return null;
    }
}

