/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.settings.RawSettingSerializerDescriptor;
import com.intellij.platform.settings.SettingSerializerDescriptor;
import com.intellij.platform.settings.SettingValueSerializer;
import com.intellij.platform.settings.local.InternalStateStorageServiceKt;
import com.intellij.platform.settings.local.Measurer;
import com.intellij.platform.settings.local.MvMapManager;
import io.opentelemetry.api.metrics.Meter;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\f\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J=\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u0001H\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/settings/local/InternalStateStorageService;", "", "map", "Lcom/intellij/platform/settings/local/MvMapManager;", "telemetryScopeName", "", "(Lcom/intellij/platform/settings/local/MvMapManager;Ljava/lang/String;)V", "getMeasurer", "Lcom/intellij/platform/settings/local/Measurer;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "setMeasurer", "getValue", "T", "key", "serializer", "Lcom/intellij/platform/settings/SettingSerializerDescriptor;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "(Ljava/lang/String;Lcom/intellij/platform/settings/SettingSerializerDescriptor;Lcom/intellij/openapi/extensions/PluginId;)Ljava/lang/Object;", "setValue", "", "value", "(Ljava/lang/String;Ljava/lang/Object;Lcom/intellij/platform/settings/SettingSerializerDescriptor;Lcom/intellij/openapi/extensions/PluginId;)V", "intellij.platform.settings.local"})
@SourceDebugExtension(value={"SMAP\nInternalStateStorageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalStateStorageService.kt\ncom/intellij/platform/settings/local/InternalStateStorageService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n9#2:128\n9#2:129\n*S KotlinDebug\n*F\n+ 1 InternalStateStorageService.kt\ncom/intellij/platform/settings/local/InternalStateStorageService\n*L\n76#1:128\n100#1:129\n*E\n"})
public final class InternalStateStorageService {
    @JvmField
    @NotNull
    public final MvMapManager map;
    @NotNull
    private final Meter meter;
    @NotNull
    private final Measurer getMeasurer;
    @NotNull
    private final Measurer setMeasurer;

    public InternalStateStorageService(@NotNull MvMapManager map2, @NotNull String telemetryScopeName) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)telemetryScopeName, (String)"telemetryScopeName");
        this.map = map2;
        this.meter = TelemetryManager.Companion.getMeter(new Scope(telemetryScopeName, PlatformScopesKt.PlatformMetrics, false, 4, null));
        this.getMeasurer = new Measurer(this.meter, "get");
        this.setMeasurer = new Measurer(this.meter, "set");
    }

    @Nullable
    public final <T> T getValue(@NotNull String key, @NotNull SettingSerializerDescriptor<T> serializer2, @NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        long start2 = System.nanoTime();
        byte[] bytes = null;
        try {
            Object object;
            if (bytes != null) {
                byte[] it = bytes = this.map.get(key);
                boolean bl = false;
                if (serializer2 == RawSettingSerializerDescriptor.INSTANCE) {
                    Intrinsics.checkNotNull((Object)bytes, (String)"null cannot be cast to non-null type T of com.intellij.platform.settings.local.InternalStateStorageService.getValue$lambda$0");
                    object = bytes;
                } else {
                    object = InternalStateStorageServiceKt.getCborFormat().decodeFromByteArray((DeserializationStrategy)((SettingValueSerializer)serializer2).getSerializer(), bytes);
                }
            } else {
                object = null;
            }
            Object result2 = object;
            this.getMeasurer.add(System.nanoTime() - start2);
            return (T)result2;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            byte[] byArray = bytes;
            String message = "Cannot deserialize value for key " + key + " (size=" + (byArray != null ? Integer.valueOf(byArray.length) : "null");
            try {
                this.map.remove(key);
                if (bytes == null || bytes.length == 0) {
                    message = message + ")";
                } else {
                    String keyForInvestigation = key + ".__corrupted__";
                    this.map.put(keyForInvestigation, bytes);
                    message = message + ", value will be stored under key " + keyForInvestigation + ")";
                }
            }
            catch (Throwable e2) {
                ExceptionsKt.addSuppressed((Throwable)e2, (Throwable)e2);
            }
            InternalStateStorageService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(InternalStateStorageService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new PluginException(message, e, pluginId));
            return null;
        }
    }

    public final <T> void setValue(@NotNull String key, @Nullable T value, @NotNull SettingSerializerDescriptor<T> serializer2, @NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        long start2 = System.nanoTime();
        try {
            if (value == null) {
                this.map.remove(key);
            } else if (serializer2 == RawSettingSerializerDescriptor.INSTANCE) {
                this.map.put(key, (byte[])value);
            } else {
                this.map.put(key, InternalStateStorageServiceKt.getCborFormat().encodeToByteArray((SerializationStrategy)((SettingValueSerializer)serializer2).getSerializer(), value));
            }
            this.setMeasurer.add(System.nanoTime() - start2);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            InternalStateStorageService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(InternalStateStorageService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new PluginException("Cannot set value for key " + key, e, pluginId));
        }
    }
}

