/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.util.ArrayUtilRt;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001d\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/settings/local/ModernStringDataType;", "Lorg/h2/mvstore/type/BasicDataType;", "", "()V", "binarySearch", "", "key", "storageObj", "", "size", "initialGuess", "compare", "a", "b", "createStorage", "", "(I)[Ljava/lang/String;", "getMemory", "obj", "read", "buff", "Ljava/nio/ByteBuffer;", "write", "", "Lorg/h2/mvstore/WriteBuffer;", "s", "intellij.platform.settings.local"})
@ApiStatus.Internal
public final class ModernStringDataType
extends BasicDataType<String> {
    @NotNull
    public static final ModernStringDataType INSTANCE = new ModernStringDataType();

    private ModernStringDataType() {
    }

    @NotNull
    public String[] createStorage(int size2) {
        String[] stringArray;
        if (size2 == 0) {
            stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        } else {
            stringArray = new String[size2];
        }
        return stringArray;
    }

    @Override
    public int compare(@NotNull String a2, @NotNull String b) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a2.compareTo(b);
    }

    @Override
    public int binarySearch(@NotNull String key, @NotNull Object storageObj, int size2, int initialGuess) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)storageObj, (String)"storageObj");
        String[] storage = (String[])storageObj;
        int low = 0;
        int high = size2 - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        while (low <= high) {
            String string = storage[x];
            Intrinsics.checkNotNull((Object)string);
            int compare = key.compareTo(string);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return -(low + 1);
    }

    @Override
    public int getMemory(@NotNull String obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return 24 + 2 * obj.length();
    }

    @Override
    @NotNull
    public String read(@NotNull ByteBuffer buff) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        byte[] bytes = new byte[DataUtils.readVarInt(buff)];
        buff.get(bytes);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(bytes, charset2);
    }

    @Override
    public void write(@NotNull WriteBuffer buff, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] bytes = StringsKt.encodeToByteArray((String)s);
        buff.putVarInt(bytes.length).put(bytes);
    }
}

