/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.settings.local.StoreErrorHandler;
import com.intellij.util.ArrayUtilRt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001aP\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u00122\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u0014"}, d2={"createOrResetMvStore", "Lorg/h2/mvstore/MVStore;", "file", "Ljava/nio/file/Path;", "logSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/diagnostic/Logger;", "getInvalidateMarkerFile", "markAsInvalid", "", "openOrResetMap", "Lorg/h2/mvstore/MVMap;", "K", "V", "store", "name", "", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "tryOpenMvStore", "intellij.platform.settings.local"})
@SourceDebugExtension(value={"SMAP\nMvStoreHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MvStoreHelper.kt\ncom/intellij/platform/settings/local/MvStoreHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class MvStoreHelperKt {
    public static final void markAsInvalid(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Files.exists(file, new LinkOption[0])) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            Files.write(MvStoreHelperKt.getInvalidateMarkerFile(file), ArrayUtilRt.EMPTY_BYTE_ARRAY, openOptionArray);
        }
    }

    @NotNull
    public static final <K, V> MVMap<K, V> openOrResetMap(@NotNull MVStore store2, @NotNull String name, @NotNull MVMap.Builder<K, V> mapBuilder, @NotNull Function0<? extends Logger> logSupplier) {
        Intrinsics.checkNotNullParameter((Object)store2, (String)"store");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mapBuilder, (String)"mapBuilder");
        Intrinsics.checkNotNullParameter(logSupplier, (String)"logSupplier");
        try {
            Object m = store2.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue(m, (String)"openMap(...)");
            return m;
        }
        catch (Throwable e) {
            ((Logger)logSupplier.invoke()).error("Cannot open map " + name + ", map will be removed", e);
            try {
                store2.removeMap(name);
            }
            catch (Throwable e2) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)e2);
            }
            Object m = store2.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue(m, (String)"openMap(...)");
            return m;
        }
    }

    @NotNull
    public static final MVStore createOrResetMvStore(@NotNull Path file, @NotNull Function0<? extends Logger> logSupplier) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(logSupplier, (String)"logSupplier");
        Path markerFile = MvStoreHelperKt.getInvalidateMarkerFile(file);
        if (Files.exists(markerFile, new LinkOption[0])) {
            Files.deleteIfExists(file);
            Files.deleteIfExists(markerFile);
        }
        Path path = file.getParent();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        try {
            return MvStoreHelperKt.tryOpenMvStore(file, logSupplier);
        }
        catch (Throwable e) {
            ((Logger)logSupplier.invoke()).warn("Cannot open cache state storage, will be recreated", e);
            Files.deleteIfExists(file);
            return MvStoreHelperKt.tryOpenMvStore(file, logSupplier);
        }
    }

    private static final Path getInvalidateMarkerFile(Path file) {
        Path path = file.resolveSibling(file.getFileName() + ".invalidated");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    private static final MVStore tryOpenMvStore(Path file, Function0<? extends Logger> logSupplier) {
        StoreErrorHandler storeErrorHandler = new StoreErrorHandler(file, logSupplier);
        MVStore store2 = new MVStore.Builder().fileName(((Object)file.toAbsolutePath()).toString()).backgroundExceptionHandler(storeErrorHandler).autoCommitDisabled().open();
        storeErrorHandler.isStoreOpened = true;
        store2.setVersionsToKeep(0);
        Intrinsics.checkNotNull((Object)store2);
        return store2;
    }
}

