/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.tensor;

import io.kinference.attribute.Attribute;
import io.kinference.core.data.tensor.KITensor;
import io.kinference.core.data.tensor.TensorExtensionsKt;
import io.kinference.core.operators.tensor.ScatterND;
import io.kinference.data.ONNXData;
import io.kinference.graph.Contexts;
import io.kinference.ndarray.arrays.LongNDArray;
import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.NDArrayUtilsKt;
import io.kinference.ndarray.arrays.pointers.LongPointer;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import io.kinference.operator.IOInfo;
import io.kinference.operator.Operator;
import io.kinference.operator.OperatorInfo;
import io.kinference.operator.VersionInfo;
import io.kinference.protobuf.message.TensorProto;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bJF\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\t\"\u0010\b\u0000\u0010\u000e*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\tH\u0096@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lio/kinference/core/operators/tensor/ScatterNDVer11;", "Lio/kinference/core/operators/tensor/ScatterND;", "name", "", "attributes", "", "Lio/kinference/attribute/Attribute;", "", "inputs", "", "outputs", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "apply", "Lio/kinference/core/data/tensor/KITensor;", "D", "Lio/kinference/data/ONNXData;", "contexts", "Lio/kinference/graph/Contexts;", "(Lio/kinference/graph/Contexts;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "inference-core"})
public final class ScatterNDVer11
extends ScatterND {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<IOInfo> INPUTS_INFO;
    @NotNull
    private static final List<IOInfo> OUTPUTS_INFO;
    @NotNull
    private static final VersionInfo VERSION;
    @NotNull
    private static final OperatorInfo INFO;

    public ScatterNDVer11(@NotNull String name, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        super(name, INFO, attributes, inputs, outputs, null);
    }

    @Override
    @Nullable
    public <D extends ONNXData<?, ?>> Object apply(@NotNull Contexts<D> contexts, @NotNull List<KITensor> inputs, @NotNull Continuation<? super List<KITensor>> $completion) {
        KITensor kITensor = inputs.get(0);
        Intrinsics.checkNotNull((Object)kITensor);
        MutableNDArrayCore input = kITensor.getData().toMutable();
        KITensor kITensor2 = inputs.get(1);
        Intrinsics.checkNotNull((Object)kITensor2);
        NDArrayCore nDArrayCore = kITensor2.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.LongNDArray");
        LongNDArray indices = (LongNDArray)nDArrayCore;
        KITensor kITensor3 = inputs.get(2);
        Intrinsics.checkNotNull((Object)kITensor3);
        NDArrayCore updates = kITensor3.getData();
        int kDim = ArraysKt.last((int[])indices.getShape());
        int blockSize = NDArrayUtilsKt.computeBlockSize$default(input, kDim, 0, 2, null);
        int[] srcUpdateOffsets = ScatterNDVer11.Companion.getActualIndices(input, indices, kDim);
        int n = srcUpdateOffsets.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            int offset = srcUpdateOffsets[i];
            int srcOff = i2 * blockSize;
            input.copyFrom(offset, updates, srcOff, srcOff + blockSize);
        }
        return CollectionsKt.listOf((Object)TensorExtensionsKt.asTensor(input, "output"));
    }

    static {
        Object[] objectArray = new IOInfo[]{new IOInfo(0, Operator.Companion.getALL_DATA_TYPES(), "data", false, null, false, true, 48, null), new IOInfo(1, SetsKt.setOf((Object)TensorProto.DataType.INT64), "indices", false, null, false, false, 48, null), new IOInfo(0, Operator.Companion.getALL_DATA_TYPES(), "updates", false, null, false, true, 48, null)};
        INPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        OUTPUTS_INFO = CollectionsKt.listOf((Object)new IOInfo(0, Operator.Companion.getALL_DATA_TYPES(), "output", false, null, false, null, 112, null));
        VERSION = new VersionInfo(11, 16);
        INFO = new OperatorInfo("ScatterND", CollectionsKt.emptyList(), INPUTS_INFO, OUTPUTS_INFO, VERSION, "ai.onnx");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lio/kinference/core/operators/tensor/ScatterNDVer11$Companion;", "", "()V", "INFO", "Lio/kinference/operator/OperatorInfo;", "INPUTS_INFO", "", "Lio/kinference/operator/IOInfo;", "OUTPUTS_INFO", "VERSION", "Lio/kinference/operator/VersionInfo;", "getVERSION$inference_core", "()Lio/kinference/operator/VersionInfo;", "getActualIndices", "", "input", "Lio/kinference/ndarray/arrays/NDArray;", "indices", "Lio/kinference/ndarray/arrays/LongNDArray;", "kDim", "", "inference-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionInfo getVERSION$inference_core() {
            return VERSION;
        }

        private final int[] getActualIndices(NDArray input, LongNDArray indices, int kDim) {
            int[] inputStrides = input.getStrides().getStrides();
            int numBlocks = indices.getLinearSize() / kDim;
            LongPointer indicesPointer = LongTiledArray.pointer$default(indices.getArray(), 0, 1, null);
            int[] nArray = new int[numBlocks];
            for (int i = 0; i < numBlocks; ++i) {
                int n = i;
                int acc = 0;
                int n2 = n;
                int[] nArray2 = nArray;
                for (int i2 = 0; i2 < kDim; ++i2) {
                    acc += (int)indicesPointer.getAndIncrement() * inputStrides[i2];
                }
                nArray2[n2] = acc;
            }
            return nArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

