/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode;

import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode.NotebookEditorModeListener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter;", "Lorg/jetbrains/plugins/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "currentEditorMode", "Lorg/jetbrains/plugins/notebooks/ui/editor/actions/command/mode/NotebookEditorMode;", "caretAdded", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretRemoved", "getCaretAttributes", "Lcom/intellij/openapi/editor/CaretVisualAttributes;", "mode", "handleCarets", "isCaretRowShown", "", "onModeChange", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookEditorMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookEditorMode.kt\norg/jetbrains/plugins/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n9#2:148\n4098#3,11:149\n1855#4,2:160\n1855#4,2:162\n*S KotlinDebug\n*F\n+ 1 NotebookEditorMode.kt\norg/jetbrains/plugins/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter\n*L\n80#1:148\n86#1:149,11\n86#1:160,2\n98#1:162,2\n*E\n"})
public final class NotebookEditorModeListenerAdapter
implements NotebookEditorModeListener,
CaretListener {
    @NotNull
    private final Editor editor;
    @Nullable
    private NotebookEditorMode currentEditorMode;

    public NotebookEditorModeListenerAdapter(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    private final CaretVisualAttributes getCaretAttributes(NotebookEditorMode mode2) {
        CaretVisualAttributes caretVisualAttributes;
        switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: {
                CaretVisualAttributes caretVisualAttributes2 = CaretVisualAttributes.DEFAULT;
                caretVisualAttributes = caretVisualAttributes2;
                Intrinsics.checkNotNullExpressionValue((Object)caretVisualAttributes2, (String)"DEFAULT");
                break;
            }
            case 2: {
                caretVisualAttributes = NotebookEditorModeKt.access$getINVISIBLE_CARET$p();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return caretVisualAttributes;
    }

    private final boolean isCaretRowShown(NotebookEditorMode mode2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void handleCarets(NotebookEditorMode mode2) {
        switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: {
                this.editor.getCaretModel().removeSecondaryCarets();
                break;
            }
            case 2: {
                for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
                    caret.removeSelection();
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onModeChange(@NotNull NotebookEditorMode mode2) {
        void $this$forEach$iv;
        Iterator $this$filterIsInstanceTo$iv$iv;
        MarkupModelEx markupModelEx;
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        boolean modeWasChanged = this.currentEditorMode != mode2;
        this.currentEditorMode = mode2;
        if (this.editor.isDisposed()) {
            NotebookEditorModeListenerAdapter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookEditorModeListenerAdapter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot change notebook mode, Editor is disposed already");
            return;
        }
        Editor $this$onModeChange_u24lambda_u243 = editor = this.editor;
        boolean bl = false;
        MarkupModel markupModel = $this$onModeChange_u24lambda_u243.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx $this$onModeChange_u24lambda_u243_u24lambda_u241 = markupModelEx = (MarkupModelEx)markupModel;
        boolean bl2 = false;
        RangeHighlighter[] rangeHighlighterArray = $this$onModeChange_u24lambda_u243_u24lambda_u241.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object $this$filterIsInstance$iv = rangeHighlighterArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RangeHighlighterEx)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
            boolean bl3 = false;
            LineMarkerRenderer lineMarkerRenderer = it.getLineMarkerRenderer();
            it.setLineMarkerRenderer(null);
            it.setLineMarkerRenderer(lineMarkerRenderer);
        }
        if (modeWasChanged) {
            this.handleCarets(mode2);
            this.editor.getSettings().setCaretRowShown(this.isCaretRowShown(mode2));
        }
        List list = $this$onModeChange_u24lambda_u243.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Caret caret = (Caret)element$iv;
            boolean bl4 = false;
            caret.setVisualAttributes(this.getCaretAttributes(mode2));
        }
        JComponent jComponent = this.editor.getContentComponent();
        jComponent.putClientProperty(ActionUtil.ALLOW_PlAIN_LETTER_SHORTCUTS, switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    public void caretAdded(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NotebookEditorMode notebookEditorMode = this.currentEditorMode;
        if (notebookEditorMode == null) {
            return;
        }
        NotebookEditorMode mode2 = notebookEditorMode;
        Caret caret = event.getCaret();
        if (caret != null) {
            caret.setVisualAttributes(this.getCaretAttributes(mode2));
        }
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookEditorMode.values().length];
            try {
                nArray[NotebookEditorMode.EDIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookEditorMode.COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

