/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.HidingMouseListener;
import org.jetbrains.plugins.notebooks.ui.visualization.JupyterCellBorderButton;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J!\u0010\u001f\u001a\u00020 2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070!2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\"R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "actions", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lkotlin/collections/ArrayList;", "getActions", "()Ljava/util/ArrayList;", "colorsChangeListenerAdapter", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel$ColorsChangeListenerAdapter;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "isCodeCell", "", "()Z", "setCodeCell", "(Z)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCellDelimiterPanel", "backgroundColor", "Ljava/awt/Color;", "cellRoofColor", "getHeight", "", "initialize", "", "", "([Lcom/intellij/openapi/actionSystem/AnAction;Z)V", "ColorsChangeListenerAdapter", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookAboveCellDelimiterPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookAboveCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,150:1\n1282#2,2:151\n1#3:153\n37#4,2:154\n*S KotlinDebug\n*F\n+ 1 NotebookAboveCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel\n*L\n108#1:151,2\n109#1:154,2\n*E\n"})
public final class NotebookAboveCellDelimiterPanel
extends JPanel {
    @NotNull
    private final Editor editor;
    @NotNull
    private final ColorsChangeListenerAdapter colorsChangeListenerAdapter;
    @NotNull
    private final ArrayList<AnAction> actions;
    private boolean isCodeCell;

    public NotebookAboveCellDelimiterPanel(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new GridBagLayout());
        this.editor = editor;
        this.colorsChangeListenerAdapter = new ColorsChangeListenerAdapter();
        this.actions = new ArrayList();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final ArrayList<AnAction> getActions() {
        return this.actions;
    }

    public final boolean isCodeCell() {
        return this.isCodeCell;
    }

    public final void setCodeCell(boolean bl) {
        this.isCodeCell = bl;
    }

    public final void initialize(@NotNull AnAction[] actions2, boolean isCodeCell) {
        Object object;
        List buttons;
        JPanel codeRoofPanel;
        JPanel delimiterPanel;
        JPanel rightPanel;
        JPanel leftPanel;
        block7: {
            Color color;
            Intrinsics.checkNotNullParameter((Object)actions2, (String)"actions");
            if (this.editor.getEditorKind() == EditorKind.DIFF) {
                return;
            }
            CollectionsKt.addAll((Collection)this.actions, (Object[])actions2);
            this.isCodeCell = isCodeCell;
            Color color2 = this.editor.getColorsScheme().getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
            Color backgroundColor = color2;
            if (isCodeCell) {
                NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance(this.editor);
                EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                color = notebookEditorAppearance.getCodeCellBackground(editorColorsScheme);
            } else {
                color = backgroundColor;
            }
            Color cellRoofColor = color;
            leftPanel = this.createCellDelimiterPanel(backgroundColor, cellRoofColor);
            rightPanel = this.createCellDelimiterPanel(backgroundColor, cellRoofColor);
            JLayeredPane centerPanel = new JLayeredPane();
            delimiterPanel = new JPanel();
            delimiterPanel.setBackground(backgroundColor);
            centerPanel.add(delimiterPanel);
            codeRoofPanel = new JPanel();
            codeRoofPanel.setBackground(cellRoofColor);
            centerPanel.add(codeRoofPanel);
            int xOffset = 0;
            buttons = new ArrayList();
            for (AnAction action2 : actions2) {
                Editor editor = this.editor;
                Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                JupyterCellBorderButton button2 = new JupyterCellBorderButton((EditorEx)editor, action2);
                button2.initialize();
                int width = button2.getPreferredSize().width;
                button2.setBounds(xOffset, 0, width, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT());
                xOffset += width;
                Component component = button2;
                Integer n = JLayeredPane.DEFAULT_LAYER;
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
                centerPanel.add(component, ((Number)n).intValue());
                buttons.add(button2);
            }
            centerPanel.setPreferredSize(new Dimension(xOffset, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT()));
            delimiterPanel.setBounds(0, 0, xOffset, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT() / 2);
            codeRoofPanel.setBounds(0, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT() / 2, xOffset, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT() / 2);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.fill = 2;
            this.add((Component)leftPanel, c);
            c.weightx = 0.0;
            c.gridx = 1;
            this.add((Component)centerPanel, c);
            c.gridx = 2;
            c.weightx = 1.0;
            this.add((Component)rightPanel, c);
            MouseListener[] mouseListenerArray = this.getMouseListeners();
            Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
            Object[] $this$firstOrNull$iv = mouseListenerArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MouseListener it = (MouseListener)element$iv;
                boolean bl = false;
                if (!(it instanceof HidingMouseListener)) continue;
                object = element$iv;
                break block7;
            }
            object = null;
        }
        MouseListener mouseListener2 = (MouseListener)object;
        if (mouseListener2 != null) {
            MouseListener p0 = mouseListener2;
            boolean bl = false;
            this.removeMouseListener(p0);
        }
        Collection $this$toTypedArray$iv = buttons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JComponent[] jComponentArray = thisCollection$iv.toArray(new JComponent[0]);
        HidingMouseListener it = new HidingMouseListener(this, Arrays.copyOf(jComponentArray, jComponentArray.length));
        boolean bl = false;
        this.addMouseListener(it);
        for (JComponent button3 : buttons) {
            button3.addMouseListener(it);
        }
        this.addPropertyChangeListener("border", arg_0 -> NotebookAboveCellDelimiterPanel.initialize$lambda$2(this, delimiterPanel, codeRoofPanel, leftPanel, rightPanel, arg_0));
    }

    private final JPanel createCellDelimiterPanel(Color backgroundColor, Color cellRoofColor) {
        JPanel result2 = new JPanel(new BorderLayout());
        JPanel delimiterPanel = new JPanel();
        delimiterPanel.setBackground(backgroundColor);
        delimiterPanel.setPreferredSize(new Dimension(1, 10));
        JPanel roofPanel = new JPanel();
        roofPanel.setBackground(cellRoofColor);
        roofPanel.setPreferredSize(new Dimension(1, 10));
        result2.add((Component)delimiterPanel, "North");
        result2.add((Component)roofPanel, "South");
        return result2;
    }

    @Override
    public int getHeight() {
        return NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT();
    }

    @NotNull
    public final Project getProject() {
        Project project = this.editor.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        return project2;
    }

    private static final void initialize$lambda$2(NotebookAboveCellDelimiterPanel this$0, JPanel $delimiterPanel, JPanel $codeRoofPanel, JPanel $leftPanel, JPanel $rightPanel, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$delimiterPanel, (String)"$delimiterPanel");
        Intrinsics.checkNotNullParameter((Object)$codeRoofPanel, (String)"$codeRoofPanel");
        Intrinsics.checkNotNullParameter((Object)$leftPanel, (String)"$leftPanel");
        Intrinsics.checkNotNullParameter((Object)$rightPanel, (String)"$rightPanel");
        Color color = this$0.editor.getColorsScheme().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        Color newBackgroundColor = color;
        Object[] objectArray = new JPanel[]{$leftPanel, $rightPanel};
        this$0.colorsChangeListenerAdapter.propertyChanged(newBackgroundColor, $delimiterPanel, $codeRoofPanel, CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0002J\u0016\u0010\u0010\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004j\u0002`\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel$ColorsChangeListenerAdapter;", "", "(Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel;)V", "currentColorsPalette", "Lkotlin/Pair;", "Ljava/awt/Color;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/BackgroundColorToCellRoofColor;", "propertyChanged", "", "backgroundColor", "delimiterPanel", "Ljavax/swing/JPanel;", "codeRoofPanel", "cellBordersPanels", "", "recreatePalette", "updateColorsForCellBorderPanels", "intellij.notebooks.ui"})
    public final class ColorsChangeListenerAdapter {
        private Pair<? extends Color, ? extends Color> currentColorsPalette;

        private final void recreatePalette() {
            Color color;
            Color color2 = NotebookAboveCellDelimiterPanel.this.getEditor().getColorsScheme().getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
            Color newBackgroundColor = color2;
            if (NotebookAboveCellDelimiterPanel.this.isCodeCell()) {
                NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance(NotebookAboveCellDelimiterPanel.this.getEditor());
                EditorColorsScheme editorColorsScheme = NotebookAboveCellDelimiterPanel.this.getEditor().getColorsScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                color = notebookEditorAppearance.getCodeCellBackground(editorColorsScheme);
            } else {
                color = newBackgroundColor;
            }
            Color newCellRoofTopColor = color;
            this.currentColorsPalette = TuplesKt.to((Object)newBackgroundColor, (Object)newCellRoofTopColor);
        }

        private final void updateColorsForCellBorderPanels(Iterable<? extends JPanel> cellBordersPanels) {
            for (JPanel jPanel : cellBordersPanels) {
                Component[] componentArray = jPanel.getComponents();
                Intrinsics.checkNotNull((Object)componentArray);
                Component left = componentArray[0];
                Component right = componentArray[1];
                Pair<? extends Color, ? extends Color> pair = this.currentColorsPalette;
                if (pair == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentColorsPalette");
                    pair = null;
                }
                left.setBackground((Color)pair.getFirst());
                Pair<? extends Color, ? extends Color> pair2 = this.currentColorsPalette;
                if (pair2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentColorsPalette");
                    pair2 = null;
                }
                right.setBackground((Color)pair2.getSecond());
            }
        }

        public final void propertyChanged(@NotNull Color backgroundColor, @NotNull JPanel delimiterPanel, @NotNull JPanel codeRoofPanel, @NotNull Iterable<? extends JPanel> cellBordersPanels) {
            Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
            Intrinsics.checkNotNullParameter((Object)delimiterPanel, (String)"delimiterPanel");
            Intrinsics.checkNotNullParameter((Object)codeRoofPanel, (String)"codeRoofPanel");
            Intrinsics.checkNotNullParameter(cellBordersPanels, (String)"cellBordersPanels");
            if (this.currentColorsPalette != null) {
                Pair<? extends Color, ? extends Color> pair = this.currentColorsPalette;
                if (pair == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentColorsPalette");
                    pair = null;
                }
                if (Intrinsics.areEqual((Object)backgroundColor, (Object)pair.getFirst())) {
                    return;
                }
            }
            this.recreatePalette();
            Pair<? extends Color, ? extends Color> pair = this.currentColorsPalette;
            if (pair == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentColorsPalette");
                pair = null;
            }
            delimiterPanel.setBackground((Color)pair.getFirst());
            Pair<? extends Color, ? extends Color> pair2 = this.currentColorsPalette;
            if (pair2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentColorsPalette");
                pair2 = null;
            }
            codeRoofPanel.setBackground((Color)pair2.getSecond());
            this.updateColorsForCellBorderPanels(cellBordersPanels);
        }
    }
}

