/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import java.awt.Dimension;
import java.awt.Toolkit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/DialogUtil;", "", "()V", "calculatePreferredSize", "Ljava/awt/Dimension;", "widthRatio", "", "heightRatio", "sizePreference", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/DialogUtil$SizePreference;", "widthPreference", "heightPreference", "calculateRatioByPreference", "checkRatio", "", "ratio", "name", "", "SizePreference", "intellij.notebooks.visualization"})
public final class DialogUtil {
    @NotNull
    public static final DialogUtil INSTANCE = new DialogUtil();

    private DialogUtil() {
    }

    @NotNull
    public final Dimension calculatePreferredSize(@NotNull SizePreference sizePreference) {
        Intrinsics.checkNotNullParameter((Object)((Object)sizePreference), (String)"sizePreference");
        return this.calculatePreferredSize(sizePreference, sizePreference);
    }

    @NotNull
    public final Dimension calculatePreferredSize(@NotNull SizePreference widthPreference, @NotNull SizePreference heightPreference) {
        Intrinsics.checkNotNullParameter((Object)((Object)widthPreference), (String)"widthPreference");
        Intrinsics.checkNotNullParameter((Object)((Object)heightPreference), (String)"heightPreference");
        double widthRatio = this.calculateRatioByPreference(widthPreference);
        double heightRatio = this.calculateRatioByPreference(heightPreference);
        return this.calculatePreferredSize(widthRatio, heightRatio);
    }

    private final Dimension calculatePreferredSize(double widthRatio, double heightRatio) {
        this.checkRatio(widthRatio, "Width");
        this.checkRatio(heightRatio, "Height");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)((double)screenSize.width * widthRatio);
        int height = (int)((double)screenSize.height * heightRatio);
        return new Dimension(width, height);
    }

    private final void checkRatio(double ratio, String name) {
        if (ratio <= 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException(name + " ratio must fall within the range (0.0; 1.0]. Actual value was " + ratio);
        }
    }

    private final double calculateRatioByPreference(SizePreference sizePreference) {
        return switch (WhenMappings.$EnumSwitchMapping$0[sizePreference.ordinal()]) {
            case 1 -> 0.15;
            case 2 -> 0.25;
            case 3 -> 0.5;
            case 4 -> 0.75;
            case 5 -> 0.85;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/DialogUtil$SizePreference;", "", "(Ljava/lang/String;I)V", "VERY_NARROW", "NARROW", "MODERATE", "WIDE", "VERY_WIDE", "intellij.notebooks.visualization"})
    public static final class SizePreference
    extends Enum<SizePreference> {
        public static final /* enum */ SizePreference VERY_NARROW = new SizePreference();
        public static final /* enum */ SizePreference NARROW = new SizePreference();
        public static final /* enum */ SizePreference MODERATE = new SizePreference();
        public static final /* enum */ SizePreference WIDE = new SizePreference();
        public static final /* enum */ SizePreference VERY_WIDE = new SizePreference();
        private static final /* synthetic */ SizePreference[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SizePreference[] values() {
            return (SizePreference[])$VALUES.clone();
        }

        public static SizePreference valueOf(String value) {
            return Enum.valueOf(SizePreference.class, value);
        }

        @NotNull
        public static EnumEntries<SizePreference> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sizePreferenceArray = new SizePreference[]{SizePreference.VERY_NARROW, SizePreference.NARROW, SizePreference.MODERATE, SizePreference.WIDE, SizePreference.VERY_WIDE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SizePreference.values().length];
            try {
                nArray[SizePreference.VERY_NARROW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizePreference.NARROW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizePreference.MODERATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizePreference.WIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizePreference.VERY_WIDE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

