/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.actions.GitOngoingOperationAction;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSelectRootDialog;
import git4idea.repo.GitRepository;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/actions/GitOperationActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lgit4idea/actions/GitOngoingOperationAction;", "repositoryState", "Lcom/intellij/dvcs/repo/Repository$State;", "(Lcom/intellij/dvcs/repo/Repository$State;)V", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "getOperationName", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "chooseRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "defaultRepo", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getAffectedRepositories", "getMainToolbarIcon", "Ljavax/swing/Icon;", "isEnabled", "", "repository", "update", "intellij.vcs.git"})
public abstract class GitOperationActionBase
extends DumbAwareAction
implements GitOngoingOperationAction {
    @NotNull
    private final Repository.State repositoryState;

    public GitOperationActionBase(@NotNull Repository.State repositoryState) {
        Intrinsics.checkNotNullParameter((Object)repositoryState, (String)"repositoryState");
        this.repositoryState = repositoryState;
    }

    @NotNull
    protected abstract String getOperationName();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(!this.getAffectedRepositories(e.getProject()).isEmpty());
        if (e.getPresentation().isVisible() && Intrinsics.areEqual((Object)e.getPlace(), (Object)"GitMergeRebaseWidgetPlace")) {
            e.getPresentation().setIcon(this.getMainToolbarIcon());
        }
    }

    @Nullable
    public Icon getMainToolbarIcon() {
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        Project project = (Project)object;
        GitRepository defaultRepo = GitBranchUtil.guessRepositoryForOperation(project, e.getDataContext());
        GitRepository repository = this.chooseRepository(project, this.getAffectedRepositories(project), defaultRepo);
        if (repository != null) {
            this.performInBackground(repository);
        }
    }

    @Override
    public boolean isEnabled(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return repository.getState() == this.repositoryState;
    }

    private final Collection<GitRepository> getAffectedRepositories(Project project) {
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Collection<GitRepository> collection = GitUtil.getRepositoriesInState(project, this.repositoryState);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositoriesInState(...)");
        return collection;
    }

    private final GitRepository chooseRepository(Project project, Collection<? extends GitRepository> repositories2, GitRepository defaultRepo) {
        if (repositories2.size() == 1) {
            return (GitRepository)CollectionsKt.single((Iterable)repositories2);
        }
        String string = this.getTemplatePresentation().getText();
        Intrinsics.checkNotNull((Object)string);
        Object[] objectArray = new Object[]{this.getOperationName()};
        String string2 = GitBundle.message("operation.action.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new GitSelectRootDialog(project, string, string2, repositories2, defaultRepo).selectRoot();
    }
}

