/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitLocalBranch;
import git4idea.actions.GitLogSingleCommitAction;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lgit4idea/actions/GitPushUpToCommitAction;", "Lgit4idea/actions/GitLogSingleCommitAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/Hash;", "getSourceReference", "", "hash", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPushUpToCommitAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPushUpToCommitAction.kt\ngit4idea/actions/GitPushUpToCommitAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class GitPushUpToCommitAction
extends GitLogSingleCommitAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        GitLocalBranch currentBranch;
        GitRepository repository;
        CommitId commit;
        VcsLogData logData;
        VcsLogCommitSelection selection;
        Project project;
        block9: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object2 = e.getRequiredData(CommonDataKeys.PROJECT);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getRequiredData(...)");
            project = (Project)object2;
            Object object3 = e.getRequiredData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getRequiredData(...)");
            selection = (VcsLogCommitSelection)object3;
            Object object4 = e.getRequiredData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.intellij.vcs.log.data.VcsLogData");
            logData = (VcsLogData)object4;
            commit = (CommitId)CollectionsKt.first((List)selection.getCommits());
            GitRepository gitRepository = this.getRepositoryForRoot(project, commit.getRoot());
            Intrinsics.checkNotNull((Object)gitRepository);
            repository = gitRepository;
            currentBranch = repository.getCurrentBranch();
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            Hash hash = commit.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            List<String> branches2 = GitCommitEditingActionBase.Companion.findContainingBranches(logData, virtualFile, hash);
            if (branches2.contains("HEAD") && currentBranch != null) {
                object = currentBranch;
            } else {
                for (Object it : (Iterable)branches2) {
                    boolean bl = false;
                    it = repository.getBranches().findLocalBranch((String)it);
                    if (it == null) continue;
                    object = it;
                    break block9;
                }
                object = null;
            }
        }
        GitLocalBranch branch = object;
        GitPushSource referenceToPush = null;
        if (Registry.is((String)"git.push.upto.commit.with.head.reference") && branch != null && Intrinsics.areEqual((Object)branch, (Object)currentBranch)) {
            GitCommitEditingActionBase.MultipleCommitEditingData multipleCommitEditingData = new GitCommitEditingActionBase.MultipleCommitEditingData(repository, selection, logData);
            String string = GitBundle.message("push.up.to.commit.allowed.progress.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String description2 = GitCommitEditingActionBase.Companion.checkHeadLinearHistory(multipleCommitEditingData, string);
            if (description2 != null) {
                Messages.showErrorDialog((Project)project, (String)description2, (String)GitBundle.message("push.upto.here.failed.dialog.title", new Object[0]));
                return;
            }
            Hash hash = commit.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            String sourceReference = this.getSourceReference(repository, hash);
            String string2 = sourceReference;
            if (string2 == null) {
                String string3 = commit.getHash().asString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            }
            GitPushSource gitPushSource = GitPushSource.createRef(branch, string2);
            Intrinsics.checkNotNullExpressionValue((Object)gitPushSource, (String)"createRef(...)");
            referenceToPush = gitPushSource;
        } else if (branch != null) {
            GitPushSource gitPushSource = GitPushSource.createRef(branch, commit.getHash().asString());
            Intrinsics.checkNotNullExpressionValue((Object)gitPushSource, (String)"createRef(...)");
            referenceToPush = gitPushSource;
        } else {
            GitPushSource gitPushSource = GitPushSource.createDetached(commit.getHash().asString());
            Intrinsics.checkNotNullExpressionValue((Object)gitPushSource, (String)"createDetached(...)");
            referenceToPush = gitPushSource;
        }
        new VcsPushDialog(repository.getProject(), (Collection)CollectionsKt.listOf((Object)repository), CollectionsKt.listOf((Object)repository), (Repository)repository, (PushSource)referenceToPush).show();
    }

    protected void actionPerformed(@NotNull GitRepository repository, @NotNull Hash commit) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
    }

    private final String getSourceReference(GitRepository repository, Hash hash) {
        Ref.ObjectRef reference = new Ref.ObjectRef();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitPushUpToCommitAction.getSourceReference$lambda$2(repository, hash, reference), GitBundle.message("push.up.to.commit.getting.reference.progress.title", new Object[0]), true, repository.getProject());
        return (String)reference.element;
    }

    private static final void getSourceReference$lambda$2(GitRepository $repository, Hash $hash, Ref.ObjectRef $reference) {
        block0: {
            Integer count;
            Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
            Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
            Intrinsics.checkNotNullParameter((Object)$reference, (String)"$reference");
            String string = GitHistoryUtils.getNumberOfCommitsBetween($repository, $hash.asString(), "HEAD");
            Integer n = count = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            $reference.element = count > 0 ? "HEAD^" + count : "HEAD";
        }
    }
}

