/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.CacheableAnnotationProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.annotate.GitAnnotationProviderKt;
import git4idea.annotate.GitAnnotationService;
import git4idea.annotate.GitFileAnnotation;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryProvider;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.StringScanner;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitAnnotationProvider
implements AnnotationProviderEx,
CacheableAnnotationProvider {
    @NonNls
    private static final String SUBJECT_KEY = "summary";
    @NonNls
    private static final String FILENAME_KEY = "filename";
    @NonNls
    private static final String PREVIOUS_KEY = "previous";
    @NonNls
    private static final String AUTHOR_KEY = "author";
    @NonNls
    private static final String AUTHOR_EMAIL_KEY = "author-mail";
    @NonNls
    private static final String COMMITTER_TIME_KEY = "committer-time";
    @NonNls
    private static final String AUTHOR_TIME_KEY = "author-time";
    private static final Logger LOG = Logger.getInstance(GitAnnotationProvider.class);
    private static final Logger TIME_LOG = Logger.getInstance((String)("#time." + GitAnnotationProvider.class.getName()));
    private final Project myProject;
    @NotNull
    private final VcsHistoryCache myCache;

    public GitAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            GitAnnotationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file2) throws VcsException {
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(1);
        }
        FileAnnotation fileAnnotation = this.annotate(file2, null);
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(2);
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file2, @Nullable VcsFileRevision revision) throws VcsException {
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(3);
        }
        FileAnnotation fileAnnotation = (FileAnnotation)GitAnnotationProvider.logTime(() -> {
            if (file2.isDirectory()) {
                throw new VcsException(GitBundle.message("annotate.cannot.annotate.dir", new Object[0]));
            }
            if (revision == null) {
                Pair<FilePath, VcsRevisionNumber> pair = this.getPathAndRevision(file2);
                return this.annotate((FilePath)pair.first, (VcsRevisionNumber)pair.second, file2);
            }
            FilePath filePath = ((VcsFileRevisionEx)revision).getPath();
            VcsRevisionNumber revisionNumber = revision.getRevisionNumber();
            return this.annotate(filePath, revisionNumber, file2);
        });
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(4);
        }
        return fileAnnotation;
    }

    public String getActionName() {
        return ActionsBundle.message((String)"action.Annotate.with.Blame.text", (Object[])new Object[0]);
    }

    public boolean isAnnotationValid(@NotNull FilePath path, @NotNull VcsRevisionNumber revisionNumber) {
        if (path == null) {
            GitAnnotationProvider.$$$reportNull$$$0(5);
        }
        if (revisionNumber == null) {
            GitAnnotationProvider.$$$reportNull$$$0(6);
        }
        return revisionNumber instanceof GitRevisionNumber && GitContentRevision.getRepositoryIfSubmodule(this.myProject, path) == null;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (path == null) {
            GitAnnotationProvider.$$$reportNull$$$0(7);
        }
        if (revision == null) {
            GitAnnotationProvider.$$$reportNull$$$0(8);
        }
        FileAnnotation fileAnnotation = (FileAnnotation)GitAnnotationProvider.logTime(() -> {
            GitFileRevision fileRevision = new GitFileRevision(this.myProject, path, (GitRevisionNumber)revision);
            VcsVirtualFile file2 = new VcsVirtualFile(path.getPath(), (VcsFileRevision)fileRevision, (VirtualFileSystem)VcsFileSystem.getInstance());
            return this.annotate(path, revision, (VirtualFile)file2);
        });
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(9);
        }
        return fileAnnotation;
    }

    @NotNull
    private GitFileAnnotation annotate(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file2) throws VcsException {
        GitFileAnnotation fileAnnotation;
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(11);
        }
        VirtualFile root = GitUtil.getRootForFile(this.myProject, filePath);
        if (revision != null) {
            fileAnnotation = this.getCached(filePath, revision, file2);
            if (fileAnnotation == null) {
                fileAnnotation = this.doAnnotate(root, filePath, revision, file2);
                this.cache(filePath, revision, fileAnnotation);
            }
        } else {
            fileAnnotation = this.doAnnotate(root, filePath, null, file2);
        }
        if (fileAnnotation.getRevisions() == null) {
            this.loadFileHistoryInBackground(fileAnnotation);
            this.loadCommitMessagesFromLog(root, fileAnnotation);
        }
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(12);
        }
        return gitFileAnnotation;
    }

    @ApiStatus.Experimental
    @Nullable
    public GitFileAnnotation getCached(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file2) {
        Object annotatedData;
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(14);
        }
        if ((annotatedData = this.myCache.getAnnotation(filePath, GitVcs.getKey(), revision)) instanceof CachedData) {
            return this.restoreFromCache(file2, revision, (CachedData)annotatedData);
        }
        return null;
    }

    @ApiStatus.Experimental
    public void cache(@NotNull FilePath filePath, @NotNull VcsRevisionNumber revision, GitFileAnnotation fileAnnotation) {
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(15);
        }
        if (revision == null) {
            GitAnnotationProvider.$$$reportNull$$$0(16);
        }
        this.myCache.putAnnotation(filePath, GitVcs.getKey(), revision, (Object)GitAnnotationProvider.cacheData(fileAnnotation));
    }

    @NotNull
    private GitFileAnnotation doAnnotate(@NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file2) throws VcsException {
        if (root == null) {
            GitAnnotationProvider.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(19);
        }
        if (revision == null) {
            LOG.warn("Computing annotations for implicitly passed HEAD revision");
        }
        GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("computing.annotation", file2.getName()));
        GitFileAnnotation gitFileAnnotation = ((GitAnnotationService)this.myProject.getService(GitAnnotationService.class)).annotate(root, filePath, revision, file2);
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(20);
        }
        return gitFileAnnotation;
    }

    private void loadCommitMessagesFromLog(@NotNull VirtualFile root, @NotNull GitFileAnnotation annotation) {
        VcsLogManager logManager;
        if (root == null) {
            GitAnnotationProvider.$$$reportNull$$$0(21);
        }
        if (annotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(22);
        }
        if ((logManager = VcsProjectLog.getInstance((Project)this.myProject).getLogManager()) == null) {
            return;
        }
        VcsLogData dataManager = logManager.getDataManager();
        IndexDataGetter getter = dataManager.getIndex().getDataGetter();
        if (getter == null) {
            return;
        }
        Set revisions = ContainerUtil.map2Set(annotation.getLines(), it -> it.getRevisionNumber());
        for (GitRevisionNumber revision : revisions) {
            int commitIndex;
            String commitMessage;
            if (annotation.getCommitMessage((VcsRevisionNumber)revision) != null || (commitMessage = getter.getFullMessage(commitIndex = dataManager.getCommitIndex(HashImpl.build((String)revision.asString()), root))) == null) continue;
            annotation.setCommitMessage((VcsRevisionNumber)revision, commitMessage);
        }
    }

    private void loadFileHistoryInBackground(@NotNull GitFileAnnotation fileAnnotation) {
        List fileRevisions;
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(23);
        }
        if ((fileRevisions = (List)BackgroundTaskUtil.computeInBackgroundAndTryWait(() -> {
            VirtualFile file2 = fileAnnotation.getFile();
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
            VcsRevisionNumber currentRevision = fileAnnotation.getCurrentRevision();
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(file2);
            if (repository == null) {
                return null;
            }
            return (List)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)repository, () -> {
                try {
                    if (file2.isInLocalFileSystem() || currentRevision == null) {
                        return this.loadFileHistory(filePath);
                    }
                    return GitFileHistory.collectHistoryForRevision(this.myProject, filePath, currentRevision, new String[0]);
                }
                catch (VcsException e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            });
        }, revisions -> {
            if (revisions == null) {
                return;
            }
            GitFileAnnotation newFileAnnotation = new GitFileAnnotation(fileAnnotation.getProject(), fileAnnotation.getFile(), fileAnnotation.getCurrentRevision(), fileAnnotation.getLines());
            newFileAnnotation.setRevisions((List<VcsFileRevision>)revisions);
            ApplicationManager.getApplication().invokeLater(() -> fileAnnotation.reload(newFileAnnotation), this.myProject.getDisposed());
        }, (long)300L)) != null) {
            fileAnnotation.setRevisions(fileRevisions);
        }
    }

    @NotNull
    private List<VcsFileRevision> loadFileHistory(@NotNull FilePath filePath) throws VcsException {
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(24);
        }
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        GitHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
        VcsAbstractHistorySession cachedSession = this.myCache.getSession(filePath, vcs.getKeyInstanceMethod(), (VcsCacheableHistorySessionFactory)historyProvider, false);
        if (cachedSession != null && !ContainerUtil.isEmpty((Collection)cachedSession.getRevisionList())) {
            List list2 = cachedSession.getRevisionList();
            if (list2 == null) {
                GitAnnotationProvider.$$$reportNull$$$0(25);
            }
            return list2;
        }
        VcsAbstractHistorySession session = historyProvider.createSessionFor(filePath);
        this.myCache.putSession(filePath, null, vcs.getKeyInstanceMethod(), session, (VcsCacheableHistorySessionFactory)historyProvider, true);
        List list3 = session.getRevisionList();
        if (list3 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(26);
        }
        return list3;
    }

    @NotNull
    private static GitFileAnnotation parseAnnotations(@NotNull Project project, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file2, @NotNull VirtualFile root, @NotNull String output) throws VcsException {
        if (project == null) {
            GitAnnotationProvider.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(28);
        }
        if (root == null) {
            GitAnnotationProvider.$$$reportNull$$$0(29);
        }
        if (output == null) {
            GitAnnotationProvider.$$$reportNull$$$0(30);
        }
        HashSetInterner pathInterner = new HashSetInterner();
        if (StringUtil.isEmpty((String)output)) {
            LOG.warn("Git annotations are empty for file " + file2.getPath() + " in revision " + revision);
        }
        VcsUserRegistry userRegistry = (VcsUserRegistry)project.getService(VcsUserRegistry.class);
        try {
            ArrayList<GitFileAnnotation.LineInfo> lines = new ArrayList<GitFileAnnotation.LineInfo>();
            HashMap<String, GitFileAnnotation.CommitInfo> commits2 = new HashMap<String, GitFileAnnotation.CommitInfo>();
            StringScanner s = new StringScanner(output);
            while (s.hasMoreData()) {
                String commitHash = s.spaceToken();
                if (commitHash.equals(GitRevisionNumber.NOT_COMMITTED_HASH)) {
                    commitHash = null;
                }
                String s0 = s.spaceToken();
                int originalLineNum = Integer.parseInt(s0);
                String s1 = s.spaceToken();
                int lineNum = Integer.parseInt(s1);
                s.nextLine();
                GitFileAnnotation.CommitInfo commit = (GitFileAnnotation.CommitInfo)commits2.get(commitHash);
                if (commit != null || commitHash == null) {
                    while (s.hasMoreData() && !s.startsWith('\t')) {
                        s.nextLine();
                    }
                } else {
                    Date committerDate = null;
                    FilePath filePath = null;
                    String subject = null;
                    String authorName = null;
                    String authorEmail = null;
                    Date authorDate = null;
                    String previousRevision = null;
                    FilePath previousFilePath = null;
                    while (s.hasMoreData() && !s.startsWith('\t')) {
                        int index;
                        String key = s.spaceToken();
                        String value = s.line();
                        if (SUBJECT_KEY.equals(key)) {
                            subject = value;
                            continue;
                        }
                        if (AUTHOR_KEY.equals(key)) {
                            authorName = value;
                            continue;
                        }
                        if (AUTHOR_TIME_KEY.equals(key)) {
                            authorDate = GitUtil.parseTimestamp(value);
                            continue;
                        }
                        if (COMMITTER_TIME_KEY.equals(key)) {
                            committerDate = GitUtil.parseTimestamp(value);
                            continue;
                        }
                        if (FILENAME_KEY.equals(key)) {
                            filePath = VcsUtil.getFilePath((VirtualFile)root, (String)value);
                            continue;
                        }
                        if (AUTHOR_EMAIL_KEY.equals(key)) {
                            authorEmail = value;
                            if (!authorEmail.startsWith("<") || !authorEmail.endsWith(">")) continue;
                            authorEmail = authorEmail.substring(1, authorEmail.length() - 1);
                            continue;
                        }
                        if (!PREVIOUS_KEY.equals(key) || (index = value.indexOf(32)) == -1) continue;
                        previousRevision = value.substring(0, index);
                        previousFilePath = VcsUtil.getFilePath((VirtualFile)root, (String)value.substring(index + 1));
                    }
                    if (authorDate == null || committerDate == null || filePath == null || authorName == null || authorEmail == null || subject == null) {
                        throw new VcsException(GitBundle.message("annotate.output.lack.data", lineNum));
                    }
                    GitRevisionNumber revisionNumber = new GitRevisionNumber(commitHash);
                    VcsUser author = userRegistry.createUser(authorName, authorEmail);
                    GitRevisionNumber previousRevisionNumber = previousRevision != null ? new GitRevisionNumber(previousRevision) : null;
                    filePath = (FilePath)pathInterner.intern(filePath);
                    if (previousFilePath != null) {
                        previousFilePath = (FilePath)pathInterner.intern(previousFilePath);
                    }
                    commit = new GitFileAnnotation.CommitInfo(project, revisionNumber, filePath, committerDate, authorDate, author, subject, previousRevisionNumber, previousFilePath);
                    commits2.put(commitHash, commit);
                }
                s.nextLine();
                int expectedLineNum = lines.size() + 1;
                if (lineNum != expectedLineNum) {
                    throw new VcsException(GitBundle.message("annotate.line.mismatch.exception", lineNum, expectedLineNum));
                }
                GitFileAnnotation.LineInfo lineInfo = new GitFileAnnotation.LineInfo(commit, lineNum, originalLineNum);
                lines.add(lineInfo);
            }
            return new GitFileAnnotation(project, file2, revision, lines);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Couldn't parse annotation: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output.txt", output)});
            throw new VcsException((Throwable)e);
        }
    }

    public void populateCache(@NotNull VirtualFile file2) throws VcsException {
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(31);
        }
        Pair<FilePath, VcsRevisionNumber> pair = this.getPathAndRevision(file2);
        FilePath filePath = (FilePath)pair.first;
        VcsRevisionNumber revision = (VcsRevisionNumber)pair.second;
        if (revision == null) {
            return;
        }
        Object annotatedData = this.myCache.getAnnotation(filePath, GitVcs.getKey(), revision);
        if (annotatedData instanceof CachedData) {
            return;
        }
        VirtualFile root = GitUtil.getRootForFile(this.myProject, filePath);
        GitFileAnnotation fileAnnotation = (GitFileAnnotation)((Object)GitAnnotationProvider.logTime(() -> this.doAnnotate(root, filePath, revision, file2)));
        this.cache(filePath, revision, fileAnnotation);
    }

    @Nullable
    public FileAnnotation getFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(32);
        }
        return GitAnnotationProviderKt.getAnnotationFromCache(this.myProject, file2);
    }

    @NotNull
    private GitFileAnnotation restoreFromCache(@NotNull VirtualFile file2, @Nullable VcsRevisionNumber revisionNumber, @NotNull CachedData data2) {
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(33);
        }
        if (data2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(34);
        }
        return new GitFileAnnotation(this.myProject, file2, revisionNumber, data2.lines);
    }

    @NotNull
    private Pair<FilePath, VcsRevisionNumber> getPathAndRevision(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(35);
        }
        FilePath filePath = VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)VcsUtil.getFilePath((VirtualFile)file2));
        VcsRevisionNumber currentRevision = this.getCurrentRevision(file2);
        VcsRevisionNumber lastRevision = this.getLastRevision(filePath, currentRevision);
        Pair pair = Pair.create((Object)filePath, (Object)lastRevision);
        if (pair == null) {
            GitAnnotationProvider.$$$reportNull$$$0(36);
        }
        return pair;
    }

    @Nullable
    private VcsRevisionNumber getLastRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber currentRevision) {
        VcsRevisionNumber cachedLastRevision;
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(37);
        }
        VcsKey gitKey = GitVcs.getKey();
        if (currentRevision != null && (cachedLastRevision = this.myCache.getLastRevision(filePath, gitKey, currentRevision)) != null) {
            return cachedLastRevision;
        }
        try {
            VcsRevisionNumber lastRevision = GitHistoryUtils.getCurrentRevision(this.myProject, filePath, "HEAD");
            if (currentRevision != null && lastRevision != null) {
                this.myCache.putLastRevision(filePath, gitKey, currentRevision, lastRevision);
            }
            return lastRevision;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private VcsRevisionNumber getCurrentRevision(@NotNull VirtualFile file2) {
        GitRepository repository;
        if (file2 == null) {
            GitAnnotationProvider.$$$reportNull$$$0(38);
        }
        if ((repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(file2)) == null) {
            return null;
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision == null) {
            return null;
        }
        return new GitRevisionNumber(currentRevision);
    }

    private static void setProgressIndicatorText(@NlsContexts.ProgressText @Nullable String text2) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(text2);
        }
    }

    @NotNull
    private static CachedData cacheData(@NotNull GitFileAnnotation annotation) {
        if (annotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(39);
        }
        return new CachedData(annotation.getLines());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T logTime(ThrowableComputable<T, VcsException> computable) throws VcsException {
        long start = -1L;
        try {
            if (TIME_LOG.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (start > -1L) {
                TIME_LOG.debug("Git annotations took " + (System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 9, 12, 20, 25, 26, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: 
            case 19: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 20: 
            case 25: 
            case 26: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/annotate/GitAnnotationProvider";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 17: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/annotate/GitAnnotationProvider";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doAnnotate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileHistory";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathAndRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 20: 
            case 25: 
            case 26: 
            case 36: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationValid";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadCommitMessagesFromLog";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadFileHistoryInBackground";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadFileHistory";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "populateCache";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFromCache";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "restoreFromCache";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPathAndRevision";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLastRevision";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "cacheData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 9, 12, 20, 25, 26, 36 -> new IllegalStateException(string);
        };
    }

    static class CachedData {
        public final List<GitFileAnnotation.LineInfo> lines;

        CachedData(List<GitFileAnnotation.LineInfo> lines) {
            this.lines = lines;
        }
    }

    private static class DefaultGitAnnotationProvider
    implements GitRawAnnotationProvider {
        private static final String ID = "default";

        private DefaultGitAnnotationProvider() {
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public GitFileAnnotation annotate(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file2) throws VcsException {
            if (project == null) {
                DefaultGitAnnotationProvider.$$$reportNull$$$0(0);
            }
            if (root == null) {
                DefaultGitAnnotationProvider.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                DefaultGitAnnotationProvider.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                DefaultGitAnnotationProvider.$$$reportNull$$$0(3);
            }
            GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.BLAME);
            h.setStdoutSuppressed(true);
            h.addParameters("--porcelain", "-l", "-t");
            h.addParameters("--encoding=UTF-8");
            GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
            if (settings.isIgnoreWhitespaces()) {
                h.addParameters("-w");
            }
            if (settings.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER) {
                h.addParameters("-M");
            } else if (settings.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER) {
                h.addParameters("-C");
            }
            if (revision == null) {
                h.addParameters("HEAD");
            } else {
                h.addParameters(revision.asString());
            }
            h.endOptions();
            h.addRelativePaths(filePath);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting " + h.printableCommandLine());
            }
            String output = new String(h.run(), StandardCharsets.UTF_8);
            GitFileAnnotation gitFileAnnotation = GitAnnotationProvider.parseAnnotations(project, revision, file2, root, output);
            if (gitFileAnnotation == null) {
                DefaultGitAnnotationProvider.$$$reportNull$$$0(4);
            }
            return gitFileAnnotation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/annotate/GitAnnotationProvider$DefaultGitAnnotationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/annotate/GitAnnotationProvider$DefaultGitAnnotationProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "annotate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "annotate";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Experimental
    public static interface GitRawAnnotationProvider {
        public static final ProjectExtensionPointName<GitRawAnnotationProvider> EP_NAME = new ProjectExtensionPointName("Git4Idea.gitRawAnnotationProvider");

        @NotNull
        @NonNls
        public String getId();

        @Nullable
        public GitFileAnnotation annotate(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull FilePath var3, @Nullable VcsRevisionNumber var4, @NotNull VirtualFile var5) throws VcsException;

        default public GitFileAnnotation annotate(@NotNull VirtualFile file2, @Nullable VcsFileRevision revision) {
            if (file2 == null) {
                GitRawAnnotationProvider.$$$reportNull$$$0(0);
            }
            return null;
        }

        public static boolean isDefault(@NotNull String providerId) {
            if (providerId == null) {
                GitRawAnnotationProvider.$$$reportNull$$$0(1);
            }
            return providerId.equals("default");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providerId";
                    break;
                }
            }
            objectArray2[1] = "git4idea/annotate/GitAnnotationProvider$GitRawAnnotationProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "annotate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDefault";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

