/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.DefaultGitLogFullRecordBuilder;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryProvider;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0016J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lgit4idea/history/GitLogHistoryHandler;", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "supportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getSupportedVcs", "()Lcom/intellij/openapi/vcs/VcsKey;", "collectHistory", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "getHistoryFast", "", "Lcom/intellij/openapi/vcs/history/VcsFileRevisionEx;", "commitCount", "", "getRename", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler$Rename;", "beforeHash", "afterHash", "Companion", "RenamesCollector", "intellij.vcs.git"})
public class GitLogHistoryHandler
implements VcsLogFileHistoryHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsKey supportedVcs;
    @NotNull
    private static final Logger LOG;

    public GitLogHistoryHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        this.supportedVcs = vcsKey;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return this.supportedVcs;
    }

    @NotNull
    public List<VcsFileRevisionEx> getHistoryFast(@NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable Hash hash, int commitCount) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        GitLogParser<GitLogFullRecord> parser = GitFileHistory.Companion.createLogParser$intellij_vcs_git(this.project);
        GitLineHandler handler = new GitLineHandler(this.project, root, GitCommand.LOG);
        handler.setStdoutSuppressed(true);
        String[] stringArray = new String[5];
        stringArray[0] = "--name-status";
        stringArray[1] = parser.getPretty();
        stringArray[2] = "--encoding=UTF-8";
        Object object = hash;
        if (object == null || (object = object.asString()) == null) {
            object = GitRevisionNumber.HEAD.asString();
        }
        stringArray[3] = object;
        stringArray[4] = "--max-count=" + commitCount;
        handler.addParameters(stringArray);
        handler.endOptions();
        stringArray = new FilePath[]{filePath};
        handler.addRelativePaths((FilePath[])stringArray);
        List result2 = new ArrayList();
        GitLogOutputSplitter<Object> splitter2 = new GitLogOutputSplitter<Object>(handler, parser, arg_0 -> GitLogHistoryHandler.getHistoryFast$lambda$0((Function1)new Function1<GitLogFullRecord, Unit>((List<VcsFileRevisionEx>)result2, this, root, filePath){
            final /* synthetic */ List<VcsFileRevisionEx> $result;
            final /* synthetic */ GitLogHistoryHandler this$0;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ FilePath $filePath;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                this.$root = $root;
                this.$filePath = $filePath;
                super(1);
            }

            public final void invoke(GitLogFullRecord record) {
                Project project = GitLogHistoryHandler.access$getProject$p(this.this$0);
                Intrinsics.checkNotNull((Object)record);
                this.$result.add(GitFileHistory.Companion.createGitFileRevision$intellij_vcs_git(project, this.$root, record, this.$filePath));
            }
        }, arg_0));
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        splitter2.reportErrors();
        return result2;
    }

    public void collectHistory(@NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable Hash hash, @NotNull Function1<? super VcsFileRevision, Unit> consumer2) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        String[] stringArray = GitHistoryProvider.getHistoryLimitArgs(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getHistoryLimitArgs(...)");
        String[] args = stringArray;
        Hash hash2 = hash;
        ShortVcsRevisionNumber revisionNumber = hash2 != null ? (ShortVcsRevisionNumber)VcsLogUtil.convertToRevisionNumber((Hash)hash2) : (ShortVcsRevisionNumber)GitRevisionNumber.HEAD;
        Intrinsics.checkNotNull((Object)revisionNumber);
        new GitFileHistory(this.project, root, filePath, (VcsRevisionNumber)revisionNumber, true).load$intellij_vcs_git(consumer2, Arrays.copyOf(args, args.length));
    }

    @Nullable
    public VcsLogFileHistoryHandler.Rename getRename(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Hash beforeHash, @NotNull Hash afterHash) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)beforeHash, (String)"beforeHash");
        Intrinsics.checkNotNullParameter((Object)afterHash, (String)"afterHash");
        String string = beforeHash.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String string2 = afterHash.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        VcsFileStatusInfo vcsFileStatusInfo = Companion.getRename$intellij_vcs_git(this.project, root, string, string2, filePath);
        if (vcsFileStatusInfo == null) {
            return null;
        }
        VcsFileStatusInfo info = vcsFileStatusInfo;
        FilePath filePath2 = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getFirstPath()), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
        FilePath firstPath = filePath2;
        FilePath filePath3 = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getSecondPath()), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath3, (String)"getFilePath(...)");
        FilePath secondPath = filePath3;
        return new VcsLogFileHistoryHandler.Rename(firstPath, secondPath, beforeHash, afterHash);
    }

    private static final void getHistoryFast$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(GitLogHistoryHandler $this) {
        return $this.project;
    }

    static {
        Logger logger = Logger.getInstance(GitLogHistoryHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u000b\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/history/GitLogHistoryHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getRename", "Lcom/intellij/vcs/log/impl/VcsFileStatusInfo;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "beforeHash", "", "Lcom/intellij/openapi/util/NlsSafe;", "afterHash", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getRename$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VcsFileStatusInfo getRename$intellij_vcs_git(@NotNull Project project, @NotNull VirtualFile root, @NotNull String beforeHash, @NotNull String afterHash, @NotNull FilePath filePath) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)beforeHash, (String)"beforeHash");
            Intrinsics.checkNotNullParameter((Object)afterHash, (String)"afterHash");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.DIFF);
            h.setWithMediator(false);
            h.setStdoutSuppressed(true);
            String[] stringArray = new String[]{"-M", "--diff-filter=R", "--name-status", "--encoding=UTF-8", "--follow", beforeHash + ".." + afterHash};
            h.addParameters(stringArray);
            h.endOptions();
            stringArray = new FilePath[]{filePath};
            h.addRelativePaths((FilePath[])stringArray);
            String string = h.printableCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"printableCommandLine(...)");
            RenamesCollector renamesCollector = new RenamesCollector(string);
            h.addLineListener(renamesCollector.getLineListener());
            Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
            return renamesCollector.getSingleRename();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/history/GitLogHistoryHandler$RenamesCollector;", "Lgit4idea/history/DefaultGitLogFullRecordBuilder;", "commandLine", "", "(Ljava/lang/String;)V", "unexpectedStatusReported", "", "addPath", "", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "firstPath", "secondPath", "getLineListener", "Lgit4idea/commands/GitLineHandlerListener;", "getSingleRename", "Lcom/intellij/vcs/log/impl/VcsFileStatusInfo;", "intellij.vcs.git"})
    private static final class RenamesCollector
    extends DefaultGitLogFullRecordBuilder {
        @NotNull
        private final String commandLine;
        private boolean unexpectedStatusReported;

        public RenamesCollector(@NotNull String commandLine) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            this.commandLine = commandLine;
        }

        @Override
        public void addPath(@NotNull Change.Type type, @NotNull String firstPath, @Nullable String secondPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)firstPath, (String)"firstPath");
            if (type == Change.Type.MOVED) {
                super.addPath(type, firstPath, secondPath);
            } else if (!this.unexpectedStatusReported) {
                this.unexpectedStatusReported = true;
                LOG.error("Unexpected change " + type + " " + firstPath + " " + secondPath + " in the output of [" + this.commandLine + "]");
            }
        }

        @NotNull
        public final GitLineHandlerListener getLineListener() {
            GitLogParser.PathsParser parser = new GitLogParser.PathsParser(GitLogParser.NameStatus.STATUS, this);
            return (arg_0, arg_1) -> RenamesCollector.getLineListener$lambda$0(parser, arg_0, arg_1);
        }

        @Nullable
        public final VcsFileStatusInfo getSingleRename() {
            VcsFileStatusInfo info;
            if (this.getStatuses$intellij_vcs_git().size() > 1) {
                LOG.error("Unexpected multiple renames found. Command [" + this.commandLine + "].\nOutput [" + this.getStatuses$intellij_vcs_git() + "].");
            }
            VcsFileStatusInfo vcsFileStatusInfo = info = (VcsFileStatusInfo)CollectionsKt.singleOrNull(this.getStatuses$intellij_vcs_git());
            if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getSecondPath() : null) != null) {
                return info;
            }
            return null;
        }

        private static final void getLineListener$lambda$0(GitLogParser.PathsParser $parser, String line, Key outputType) {
            Intrinsics.checkNotNullParameter((Object)$parser, (String)"$parser");
            if (Intrinsics.areEqual((Object)outputType, (Object)ProcessOutputTypes.STDOUT)) {
                $parser.parseLine(line);
            }
        }
    }
}

