/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusPresentation;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import git4idea.GitIcons;
import git4idea.commit.signature.GitCommitSignature;
import git4idea.i18n.GitBundle;
import git4idea.log.GitCommitSignatureColumnService;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014R\u001e\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lgit4idea/log/GitCommitSignatureStatusProvider;", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider$WithColumn;", "Lgit4idea/commit/signature/GitCommitSignature;", "()V", "columnName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getColumnName", "()Ljava/lang/String;", "id", "getId", "isColumnEnabledByDefault", "", "()Z", "getExternalStatusColumnService", "Lgit4idea/log/GitCommitSignatureColumnService;", "getPresentation", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation$Signature;", "project", "Lcom/intellij/openapi/project/Project;", "status", "getStubStatus", "Lgit4idea/commit/signature/GitCommitSignature$NoSignature;", "Companion", "GitCommitSignatureStatusPresentation", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitSignatureStatusProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitSignatureStatusProvider.kt\ngit4idea/log/GitCommitSignatureStatusProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,99:1\n43#2,3:100\n*S KotlinDebug\n*F\n+ 1 GitCommitSignatureStatusProvider.kt\ngit4idea/log/GitCommitSignatureStatusProvider\n*L\n33#1:100,3\n*E\n"})
public final class GitCommitSignatureStatusProvider
extends VcsCommitExternalStatusProvider.WithColumn<GitCommitSignature> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final boolean isColumnEnabledByDefault;
    @NotNull
    private final String columnName;
    @NotNull
    private static final String ID = "Git.CommitSignature";

    public GitCommitSignatureStatusProvider() {
        this.id = ID;
        String string = GitBundle.message("column.name.commit.signature", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.columnName = string;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    protected boolean isColumnEnabledByDefault() {
        return this.isColumnEnabledByDefault;
    }

    @NotNull
    protected String getColumnName() {
        return this.columnName;
    }

    @NotNull
    public VcsCommitExternalStatusPresentation.Signature getPresentation(@NotNull Project project, @NotNull GitCommitSignature status) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return new GitCommitSignatureStatusPresentation(status);
    }

    @NotNull
    protected GitCommitSignatureColumnService getExternalStatusColumnService() {
        boolean $i$f$service = false;
        Class<GitCommitSignatureColumnService> serviceClass$iv = GitCommitSignatureColumnService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (GitCommitSignatureColumnService)((Object)object);
    }

    @NotNull
    protected GitCommitSignature.NoSignature getStubStatus() {
        return GitCommitSignature.NoSignature.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/log/GitCommitSignatureStatusProvider$Companion;", "", "()V", "ID", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0011\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lgit4idea/log/GitCommitSignatureStatusProvider$GitCommitSignatureStatusPresentation;", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation$Signature;", "signature", "Lgit4idea/commit/signature/GitCommitSignature;", "(Lgit4idea/commit/signature/GitCommitSignature;)V", "description", "Lcom/intellij/openapi/util/text/HtmlChunk;", "getDescription", "()Lcom/intellij/openapi/util/text/HtmlChunk;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "text", "", "getText", "()Ljava/lang/String;", "getUnverifiedReason", "Lorg/jetbrains/annotations/Nls;", "reason", "Lgit4idea/commit/signature/GitCommitSignature$VerificationFailureReason;", "intellij.vcs.git"})
    private static final class GitCommitSignatureStatusPresentation
    implements VcsCommitExternalStatusPresentation.Signature {
        @NotNull
        private final GitCommitSignature signature;

        public GitCommitSignatureStatusPresentation(@NotNull GitCommitSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            this.signature = signature;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            GitCommitSignature gitCommitSignature = this.signature;
            if (gitCommitSignature instanceof GitCommitSignature.Verified) {
                Icon icon2 = GitIcons.Verified;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Verified");
            } else if (gitCommitSignature instanceof GitCommitSignature.NotVerified) {
                Icon icon3 = GitIcons.Signed;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Signed");
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.Bad.INSTANCE)) {
                Icon icon4 = GitIcons.Signed;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Signed");
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NoSignature.INSTANCE)) {
                Icon icon5 = EmptyIcon.ICON_16;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"ICON_16");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return icon;
        }

        @NotNull
        public String getText() {
            String string;
            GitCommitSignature gitCommitSignature = this.signature;
            if (gitCommitSignature instanceof GitCommitSignature.Verified) {
                String string2 = GitBundle.message("commit.signature.verified", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else if (gitCommitSignature instanceof GitCommitSignature.NotVerified) {
                String string3 = GitBundle.message("commit.signature.unverified", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.Bad.INSTANCE)) {
                String string4 = GitBundle.message("commit.signature.bad", new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NoSignature.INSTANCE)) {
                String string5 = GitBundle.message("commit.signature.none", new Object[0]);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Nullable
        public HtmlChunk getDescription() {
            HtmlChunk htmlChunk;
            GitCommitSignature gitCommitSignature = this.signature;
            if (gitCommitSignature instanceof GitCommitSignature.Verified) {
                htmlChunk = new HtmlBuilder().append(GitBundle.message("commit.signature.verified", new Object[0])).br().br().append((HtmlChunk)new HtmlBuilder().append(GitBundle.message("commit.signature.fingerprint", new Object[0])).br().append(((GitCommitSignature.Verified)this.signature).getFingerprint()).br().br().append(GitBundle.message("commit.signature.signed.by", new Object[0])).br().append(((GitCommitSignature.Verified)this.signature).getUser()).wrapWith(HtmlChunk.span((String)("color: " + ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground()))))).toFragment();
            } else if (gitCommitSignature instanceof GitCommitSignature.NotVerified) {
                Object[] objectArray = new Object[]{this.getUnverifiedReason(((GitCommitSignature.NotVerified)this.signature).getReason())};
                htmlChunk = new HtmlBuilder().append(GitBundle.message("commit.signature.unverified.with.reason", objectArray)).toFragment();
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.Bad.INSTANCE)) {
                htmlChunk = HtmlChunk.text((String)GitBundle.message("commit.signature.bad", new Object[0]));
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NoSignature.INSTANCE)) {
                htmlChunk = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return htmlChunk;
        }

        private final String getUnverifiedReason(GitCommitSignature.VerificationFailureReason reason) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
                case 1: {
                    String string2 = GitBundle.message("commit.signature.unverified.reason.unknown", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    break;
                }
                case 2: {
                    String string3 = GitBundle.message("commit.signature.unverified.reason.expired", new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    break;
                }
                case 3: {
                    String string4 = GitBundle.message("commit.signature.unverified.reason.expired.key", new Object[0]);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    break;
                }
                case 4: {
                    String string5 = GitBundle.message("commit.signature.unverified.reason.revoked.key", new Object[0]);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    break;
                }
                case 5: {
                    String string6 = GitBundle.message("commit.signature.unverified.reason.cannot.verify", new Object[0]);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GitCommitSignature.VerificationFailureReason.values().length];
                try {
                    nArray[GitCommitSignature.VerificationFailureReason.UNKNOWN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GitCommitSignature.VerificationFailureReason.EXPIRED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GitCommitSignature.VerificationFailureReason.EXPIRED_KEY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GitCommitSignature.VerificationFailureReason.REVOKED_KEY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GitCommitSignature.VerificationFailureReason.CANNOT_VERIFY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

