/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log.drop;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitCommitEditingNotificationsKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.GitLogCommitDetailsLoaderKt;
import git4idea.rebase.log.GitMultipleCommitEditingAction;
import git4idea.rebase.log.drop.GitDropOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/log/drop/GitDropLogAction;", "Lgit4idea/rebase/log/GitMultipleCommitEditingAction;", "()V", "actionPerformedAfterChecks", "", "commitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "askForConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "selectionSize", "", "getFailureTitle", "", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDropLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDropLogAction.kt\ngit4idea/rebase/log/drop/GitDropLogAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,74:1\n43#2,3:75\n*S KotlinDebug\n*F\n+ 1 GitDropLogAction.kt\ngit4idea/rebase/log/drop/GitDropLogAction\n*L\n28#1:75,3\n*E\n"})
public final class GitDropLogAction
extends GitMultipleCommitEditingAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_COMMITS_IN_NOTIFICATION = 10;
    @NotNull
    public static final String DROP_COMMIT_HELP_ID = "reference.VersionControl.Git.DropCommit";

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Object[] objectArray = new Object[]{VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)commitEditingData.getSelection())};
        e.getPresentation().setText(GitBundle.message("rebase.log.drop.action.custom.text", objectArray));
    }

    @Override
    protected void actionPerformedAfterChecks(@NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        boolean canDrop;
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Project project = commitEditingData.getProject();
        int selectionSize = VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)commitEditingData.getSelection());
        boolean $i$f$service = false;
        Class<GitVcsApplicationSettings> serviceClass$iv = GitVcsApplicationSettings.class;
        Object[] objectArray = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (objectArray == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        boolean bl = canDrop = !((GitVcsApplicationSettings)objectArray).isShowDropCommitDialog() || this.askForConfirmation(project, selectionSize);
        if (!canDrop) {
            return;
        }
        List<VcsCommitMetadata> commitDetails = GitLogCommitDetailsLoaderKt.getOrLoadDetails(project, commitEditingData.getLogData(), commitEditingData.getSelection());
        objectArray = new Object[]{commitDetails.size()};
        String string = GitBundle.message("rebase.log.drop.progress.indicator.title", objectArray);
        new Task.Backgroundable(project, commitEditingData, commitDetails, string){
            final /* synthetic */ GitCommitEditingActionBase.MultipleCommitEditingData $commitEditingData;
            final /* synthetic */ List<VcsCommitMetadata> $commitDetails;
            {
                this.$commitEditingData = $commitEditingData;
                this.$commitDetails = $commitDetails;
                super($project, $super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult operationResult = new GitDropOperation(this.$commitEditingData.getRepository()).execute(this.$commitDetails);
                if (operationResult instanceof GitCommitEditingOperationResult.Complete) {
                    HtmlBuilder htmlBuilder;
                    Collection<HtmlChunk> collection;
                    void $this$mapTo$iv$iv;
                    HtmlBuilder $this$map$iv;
                    Object[] objectArray = new Object[]{this.$commitDetails.size()};
                    String string = GitBundle.message("rebase.log.drop.success.notification.title", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String notificationTitle = string;
                    Iterable iterable = CollectionsKt.take((Iterable)this.$commitDetails, (int)10);
                    HtmlChunk htmlChunk = (HtmlChunk)HtmlChunk.br();
                    HtmlBuilder htmlBuilder2 = new HtmlBuilder();
                    boolean $i$f$map = false;
                    void var8_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(HtmlChunk.text((String)("\"" + StringUtil.shortenTextWithEllipsis((String)it.getSubject(), (int)40, (int)0) + "\"")));
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = htmlBuilder2.appendWithSeparators(htmlChunk, (Iterable)collection);
                    boolean condition$iv = this.$commitDetails.size() > 10;
                    boolean $i$f$applyIf = false;
                    if (condition$iv) {
                        void $this$run_u24lambda_u241 = $this$applyIf$iv;
                        boolean bl = false;
                        htmlBuilder = $this$run_u24lambda_u241.br().append("...");
                    } else {
                        htmlBuilder = $this$applyIf$iv;
                    }
                    String string2 = htmlBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String notificationContent = string2;
                    GitCommitEditingOperationResult.Complete complete = (GitCommitEditingOperationResult.Complete)operationResult;
                    String string3 = GitBundle.message("rebase.log.drop.undo.progress.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    String string4 = GitBundle.message("rebase.log.drop.undo.impossible.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    String string5 = GitBundle.message("rebase.log.drop.undo.failed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    GitCommitEditingNotificationsKt.notifySuccess(complete, notificationTitle, notificationContent, string3, string4, string5);
                }
            }
        }.queue();
    }

    private final boolean askForConfirmation(Project project, int selectionSize) {
        Object[] objectArray = new Object[]{selectionSize};
        String string = GitBundle.message("rebase.log.drop.action.confirmation.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray = new Object[]{selectionSize};
        String string2 = GitBundle.message("rebase.log.drop.action.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(string, string2).asWarning()).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                boolean $i$f$service = false;
                Class<GitVcsApplicationSettings> serviceClass$iv = GitVcsApplicationSettings.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                ((GitVcsApplicationSettings)object).setShowDropCommitDialog(!isSelected);
            }
        })).help(DROP_COMMIT_HELP_ID)).ask(project);
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message("rebase.log.drop.action.failure.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/drop/GitDropLogAction$Companion;", "", "()V", "DROP_COMMIT_HELP_ID", "", "MAX_COMMITS_IN_NOTIFICATION", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

