/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitShelveChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitChangesSaver.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final String myStashMessage;
    @NotNull
    private final GitSaveChangesPolicy mySaveMethod;
    protected GitConflictResolver.Params myParams;

    @NotNull
    public static GitChangesSaver getSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull @Nls String stashMessage, @NotNull GitSaveChangesPolicy saveMethod) {
        if (project == null) {
            GitChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitChangesSaver.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            GitChangesSaver.$$$reportNull$$$0(2);
        }
        if (stashMessage == null) {
            GitChangesSaver.$$$reportNull$$$0(3);
        }
        if (saveMethod == null) {
            GitChangesSaver.$$$reportNull$$$0(4);
        }
        if (saveMethod == GitSaveChangesPolicy.SHELVE) {
            return new GitShelveChangesSaver(project, git, progressIndicator, stashMessage);
        }
        return new GitStashChangesSaver(project, git, progressIndicator, stashMessage);
    }

    protected GitChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull GitSaveChangesPolicy saveMethod, @NotNull String stashMessage) {
        if (project == null) {
            GitChangesSaver.$$$reportNull$$$0(5);
        }
        if (git == null) {
            GitChangesSaver.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            GitChangesSaver.$$$reportNull$$$0(7);
        }
        if (saveMethod == null) {
            GitChangesSaver.$$$reportNull$$$0(8);
        }
        if (stashMessage == null) {
            GitChangesSaver.$$$reportNull$$$0(9);
        }
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = indicator;
        this.mySaveMethod = saveMethod;
        this.myStashMessage = stashMessage;
    }

    public void saveLocalChanges(@Nullable Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null || rootsToSave.isEmpty()) {
            return;
        }
        this.save(rootsToSave);
    }

    public void notifyLocalChangesAreNotRestored() {
        if (this.wereChangesSaved()) {
            LOG.info("Update is incomplete, changes are not restored");
            VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(GitBundle.message("restore.notification.failed.title", new Object[0]), this.getSaveMethod().selectBundleMessage(GitBundle.message("restore.notification.failed.stash.message", new Object[0]), GitBundle.message("restore.notification.failed.shelf.message", new Object[0])), NotificationType.WARNING).setDisplayId("git.local.changes.not.restored").addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("restore.notification.failed.show.changes.action", new Object[0]), () -> this.showSavedChanges())).notify(this.myProject);
        }
    }

    public void setConflictResolverParams(GitConflictResolver.Params params) {
        this.myParams = params;
    }

    protected abstract void save(Collection<? extends VirtualFile> var1) throws VcsException;

    public abstract void load();

    public abstract boolean wereChangesSaved();

    @NotNull
    public GitSaveChangesPolicy getSaveMethod() {
        GitSaveChangesPolicy gitSaveChangesPolicy = this.mySaveMethod;
        if (gitSaveChangesPolicy == null) {
            GitChangesSaver.$$$reportNull$$$0(10);
        }
        return gitSaveChangesPolicy;
    }

    public abstract void showSavedChanges();

    @NotNull
    protected static String getConflictRightPanelTitle() {
        String string = GitBundle.message("save.load.conflict.dialog.diff.right.title", new Object[0]);
        if (string == null) {
            GitChangesSaver.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    protected static String getConflictLeftPanelTitle() {
        String string = GitBundle.message("save.load.conflict.dialog.diff.left.title", new Object[0]);
        if (string == null) {
            GitChangesSaver.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "saveMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/stash/GitChangesSaver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/stash/GitChangesSaver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaveMethod";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictRightPanelTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictLeftPanelTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSaver";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

