/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vcs.changes.ui.HoverChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.LabelPainter;
import git4idea.GitReference;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lgit4idea/stash/ui/GitStashBranchComponent;", "Ljavax/swing/JPanel;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "iconCache", "Lcom/intellij/vcs/log/ui/render/LabelIconCache;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/vcs/log/ui/render/LabelIconCache;)V", "labelPainter", "Lcom/intellij/vcs/log/ui/render/LabelPainter;", "rightGap", "", "getRightGap", "()I", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "customise", "", "branchName", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "row", "selected", "", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "g", "Ljava/awt/Graphics;", "StashRefGroup", "intellij.vcs.git"})
public final class GitStashBranchComponent
extends JPanel {
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final LabelPainter labelPainter;

    public GitStashBranchComponent(@NotNull ChangesTree tree2, @NotNull LabelIconCache iconCache) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)iconCache, (String)"iconCache");
        this.tree = tree2;
        this.labelPainter = new LabelPainter((JComponent)this.tree, iconCache);
        this.setOpaque(false);
        this.labelPainter.setOpaque(false);
    }

    @NotNull
    public final ChangesTree getTree() {
        return this.tree;
    }

    private final int getRightGap() {
        return UIUtil.getScrollBarWidth();
    }

    public final void customise(@NotNull String branchName, @NotNull VirtualFile root, int row, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.tree.getProject()).getRepositoryForRootQuick(root);
        Object object = repository;
        boolean isCurrentBranch = Intrinsics.areEqual((Object)(object != null && (object = object.getCurrentBranch()) != null ? ((GitReference)object).getName() : null), (Object)branchName);
        int nodeLocation = TreeUtil.getNodeRowX((JTree)((JTree)this.tree), (int)row) + this.tree.getInsets().left;
        int availableWidth = this.tree.getWidth() - this.getRightGap() - nodeLocation;
        Color color = selected ? UIUtil.getLabelForeground() : (Color)CurrentBranchComponent.TEXT_COLOR;
        Intrinsics.checkNotNull((Object)color);
        Color foreground = color;
        this.labelPainter.customizePainter(HoverChangesTree.Companion.getBackground((Tree)this.tree, row, selected), foreground, selected, availableWidth, CollectionsKt.listOf((Object)new StashRefGroup(branchName, isCurrentBranch)));
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics2D = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g2 = graphics2D;
        this.labelPainter.paint(g2, 0, 0, this.getHeight());
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.labelPainter.getSize();
        dimension.width += this.getRightGap();
        Intrinsics.checkNotNull((Object)dimension);
        return dimension;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001a\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\r\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/stash/ui/GitStashBranchComponent$StashRefGroup;", "Lcom/intellij/vcs/log/RefGroup;", "branchName", "", "Lcom/intellij/openapi/util/NlsSafe;", "isCurrent", "", "(Ljava/lang/String;Z)V", "getColors", "", "Ljava/awt/Color;", "getName", "getRefs", "", "Lcom/intellij/vcs/log/VcsRef;", "isExpanded", "intellij.vcs.git"})
    private static final class StashRefGroup
    implements RefGroup {
        @NotNull
        private final String branchName;
        private final boolean isCurrent;

        public StashRefGroup(@NotNull String branchName, boolean isCurrent) {
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            this.branchName = branchName;
            this.isCurrent = isCurrent;
        }

        @NotNull
        public String getName() {
            return this.branchName;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            return new ArrayList();
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public List<Color> getColors() {
            if (this.isCurrent) {
                Color color = GitRefManager.HEAD.getBackgroundColor();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackgroundColor(...)");
                return CollectionsKt.listOf((Object)color);
            }
            Color color = GitRefManager.LOCAL_BRANCH.getBackgroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackgroundColor(...)");
            return CollectionsKt.listOf((Object)color);
        }
    }
}

