/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.index.GitStageContentProviderKt;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.stash.ui.GitStashContentProviderKt;
import git4idea.stash.ui.GitStashSettingsListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"isStashTabAvailable", "", "isStashTabVisible", "project", "Lcom/intellij/openapi/project/Project;", "isStashesAndShelvesTabEnabled", "setStashesAndShelvesTabEnabled", "", "enabled", "showStashes", "stashToolWindowRegistryOption", "Lcom/intellij/openapi/util/registry/RegistryValue;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProviderKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,203:1\n31#2,2:204\n*S KotlinDebug\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProviderKt\n*L\n181#1:204,2\n*E\n"})
public final class GitStashContentProviderKt {
    @NotNull
    public static final RegistryValue stashToolWindowRegistryOption() {
        RegistryValue registryValue = Registry.get((String)"git.enable.stash.toolwindow");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(...)");
        return registryValue;
    }

    public static final boolean isStashTabAvailable() {
        return GitStashContentProviderKt.stashToolWindowRegistryOption().asBoolean();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStashTabVisible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!GitStashContentProviderKt.isStashTabAvailable()) {
            return false;
        }
        if (GitStashContentProviderKt.isStashesAndShelvesTabEnabled(project)) return true;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (!GitStashTrackerKt.isNotEmpty((GitStashTracker)object)) return false;
        return true;
    }

    public static final boolean isStashesAndShelvesTabEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ShelvedChangesViewManager.hideDefaultShelfTab((Project)project);
    }

    public static final void setStashesAndShelvesTabEnabled(boolean enabled) {
        GitVcsApplicationSettings applicationSettings2 = GitVcsApplicationSettings.getInstance();
        if (enabled == applicationSettings2.isCombinedStashesAndShelvesTabEnabled()) {
            return;
        }
        applicationSettings2.setCombinedStashesAndShelvesTabEnabled(enabled);
        ((GitStashSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GitStashSettingsListener.Companion.getTOPIC())).stashesAndShelvesTabSettingChanged();
    }

    public static final void showStashes(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitStageContentProviderKt.showToolWindowTab(project, "Stash", (Function1<? super JComponent, Unit>)((Function1)showStashes.1.INSTANCE));
    }
}

