/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.update.FixTrackedBranchDialog;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitSubmoduleUpdater;
import git4idea.update.GitUpdateExecutionProcess;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdatedRanges;
import git4idea.update.GitUpdater;
import git4idea.update.HashRange;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitUpdateProcess {
    private static final Logger LOG = Logger.getInstance(GitUpdateProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final List<GitRepository> myRepositories;
    @NotNull
    private final Map<GitRepository, GitSubmodule> mySubmodulesInDetachedHead;
    private final boolean myCheckRebaseOverMergeProblem;
    private final boolean myCheckForTrackedBranchExistence;
    private final UpdatedFiles myUpdatedFiles;
    private final Map<GitRepository, GitBranchPair> myUpdateConfig;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final GitMerger myMerger;
    private final @NotNull Map<GitRepository, @Nls String> mySkippedRoots;
    @Nullable
    private Map<GitRepository, HashRange> myUpdatedRanges;

    public GitUpdateProcess(@NotNull Project project, @Nullable ProgressIndicator progressIndicator, @NotNull Collection<GitRepository> repositories2, @NotNull UpdatedFiles updatedFiles, @Nullable Map<GitRepository, GitBranchPair> updateConfig, boolean checkRebaseOverMergeProblem, boolean checkForTrackedBranchExistence) {
        if (project == null) {
            GitUpdateProcess.$$$reportNull$$$0(0);
        }
        if (repositories2 == null) {
            GitUpdateProcess.$$$reportNull$$$0(1);
        }
        if (updatedFiles == null) {
            GitUpdateProcess.$$$reportNull$$$0(2);
        }
        this.mySkippedRoots = new LinkedHashMap<GitRepository, String>();
        this.myProject = project;
        this.myCheckRebaseOverMergeProblem = checkRebaseOverMergeProblem;
        this.myCheckForTrackedBranchExistence = checkForTrackedBranchExistence;
        this.myGit = Git.getInstance();
        this.myUpdatedFiles = updatedFiles;
        this.myUpdateConfig = updateConfig;
        this.myRepositories = GitUtil.getRepositoryManager(project).sortByDependency(repositories2);
        this.myProgressIndicator = progressIndicator == null ? new EmptyProgressIndicator() : progressIndicator;
        this.myMerger = new GitMerger(this.myProject);
        GitUtil.updateRepositories(repositories2);
        this.mySubmodulesInDetachedHead = new LinkedHashMap<GitRepository, GitSubmodule>();
        for (GitRepository repository : this.myRepositories) {
            GitSubmodule submodule;
            if (repository.isOnBranch() || (submodule = GitSubmoduleKt.asSubmodule(repository)) == null) continue;
            this.mySubmodulesInDetachedHead.put(repository, submodule);
        }
    }

    @NotNull
    public GitUpdateResult update(UpdateMethod updateMethod) {
        GitUpdateResult result2;
        Map<GitRepository, GitBranchPair> trackedBranches;
        LOG.info("update started|" + updateMethod);
        String oldText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(GitBundle.message("update.process.progress.title", new Object[0]));
        if (this.checkRebaseInProgress() || this.isMergeInProgress() || this.areUnmergedFiles()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(3);
            }
            return gitUpdateResult;
        }
        Map<GitRepository, GitBranchPair> map2 = trackedBranches = this.myUpdateConfig != null ? this.myUpdateConfig : this.checkTrackedBranchesConfiguration();
        if (ContainerUtil.isEmpty(trackedBranches)) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(4);
            }
            return gitUpdateResult;
        }
        if (!this.fetchAndNotify(trackedBranches)) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(5);
            }
            return gitUpdateResult;
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)VcsBundle.message((String)"activity.name.update", (Object[])new Object[0]));){
            result2 = this.updateImpl(updateMethod);
        }
        this.myProgressIndicator.setText(oldText);
        GitUpdateResult gitUpdateResult = result2;
        if (gitUpdateResult == null) {
            GitUpdateProcess.$$$reportNull$$$0(6);
        }
        return gitUpdateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GitUpdateResult updateImpl(@NotNull UpdateMethod updateMethod) {
        block25: {
            if (updateMethod == null) {
                GitUpdateProcess.$$$reportNull$$$0(7);
            }
            v0 = trackedBranches = this.myUpdateConfig != null ? this.myUpdateConfig : this.checkTrackedBranchesConfiguration();
            if (trackedBranches == null) {
                v1 = GitUpdateResult.NOT_READY;
                if (v1 == null) {
                    GitUpdateProcess.$$$reportNull$$$0(8);
                }
                return v1;
            }
            try {
                updaters = this.defineUpdaters(updateMethod, trackedBranches);
            }
            catch (VcsException e) {
                GitUpdateProcess.LOG.info((Throwable)e);
                VcsNotifier.getInstance((Project)this.myProject).notifyError("git.update.error", GitBundle.message("notification.title.update.failed", new Object[0]), e.getMessage(), Collections.singleton(e));
                v2 = GitUpdateResult.ERROR;
                if (v2 == null) {
                    GitUpdateProcess.$$$reportNull$$$0(9);
                }
                return v2;
            }
            if (updaters.isEmpty()) {
                v3 = GitUpdateResult.NOTHING_TO_UPDATE;
                if (v3 == null) {
                    GitUpdateProcess.$$$reportNull$$$0(10);
                }
                return v3;
            }
            updatedRanges = GitUpdatedRanges.calcInitialPositions(this.myProject, trackedBranches);
            updaters = this.tryFastForwardMergeForRebaseUpdaters(updaters);
            if (updaters.isEmpty()) {
                var5_6 = GitUpdateResult.SUCCESS;
                v4 = var5_6;
                if (v4 == null) {
                    GitUpdateProcess.$$$reportNull$$$0(11);
                }
                return v4;
            }
            if (this.myCheckRebaseOverMergeProblem && !(problematicRoots = this.findRootsRebasingOverMerge(updaters)).isEmpty()) {
                decision /* !! */  = GitRebaseOverMergeProblem.showDialog();
                if (decision /* !! */  != GitRebaseOverMergeProblem.Decision.MERGE_INSTEAD) {
                    if (decision /* !! */  == GitRebaseOverMergeProblem.Decision.CANCEL_OPERATION) {
                        var7_10 = GitUpdateResult.CANCEL;
                        v5 = var7_10;
                        if (v5 == null) {
                            GitUpdateProcess.$$$reportNull$$$0(12);
                        }
                        return v5;
                    } else {
                        ** GOTO lbl-1000
                    }
                }
                break block25;
            } else lbl-1000:
            // 4 sources

            {
                while (true) {
                    myRootsToSave = new ArrayList<VirtualFile>();
                    GitUpdateProcess.LOG.info("updateImpl: identifying if save is needed...");
                    for (Map.Entry var7_12 : updaters.entrySet()) {
                        repo = (GitRepository)var7_12.getKey();
                        updater = (GitUpdater)var7_12.getValue();
                        if (!updater.isSaveNeeded()) continue;
                        myRootsToSave.add(repo.getRoot());
                        GitUpdateProcess.LOG.info("update| root " + repo + " needs save");
                    }
                    GitUpdateProcess.LOG.info("updateImpl: saving local changes...");
                    incomplete = Ref.create((Object)false);
                    var7_13 = Ref.create();
                    finalUpdaters = updaters;
                    new GitPreservingProcess(this.myProject, this.myGit, myRootsToSave, GitBundle.message("git.update.operation", new Object[0]), GitBundle.message("progress.update.destination.remote", new Object[0]), GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy(), this.myProgressIndicator, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$updateImpl$0(java.util.Map com.intellij.openapi.util.Ref com.intellij.openapi.util.Ref ), ()V)((GitUpdateProcess)this, finalUpdaters, (Ref)incomplete, (Ref)var7_13)).execute((Computable<Boolean>)(Computable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updateImpl$1(com.intellij.openapi.util.Ref com.intellij.openapi.util.Ref ), ()Ljava/lang/Boolean;)((Ref)incomplete, (Ref)var7_13));
                    var9_15 = (GitUpdateResult)ObjectUtils.notNull((Object)((GitUpdateResult)var7_13.get()), (Object)GitUpdateResult.ERROR);
                    v6 = var9_15;
                    if (v6 == null) {
                        GitUpdateProcess.$$$reportNull$$$0(13);
                    }
                    return v6;
                }
            }
            finally {
                this.myUpdatedRanges = updatedRanges.calcCurrentPositions();
            }
        }
        var7_9 = problematicRoots.iterator();
        while (true) lbl-1000:
        // 3 sources

        {
            if (!var7_9.hasNext()) ** continue;
            repo = var7_9.next();
            branchAndTracked = trackedBranches.get(repo);
            if (branchAndTracked == null) {
                GitUpdateProcess.LOG.error("No tracked branch information for root " + repo.getRoot());
                ** continue;
            }
            updaters.put(repo, new GitMergeUpdater(this.myProject, this.myGit, repo, branchAndTracked, this.myProgressIndicator, this.myUpdatedFiles));
        }
    }

    @NotNull
    private Collection<GitRepository> findRootsRebasingOverMerge(@NotNull Map<GitRepository, GitUpdater> updaters) {
        if (updaters == null) {
            GitUpdateProcess.$$$reportNull$$$0(14);
        }
        List list2 = ContainerUtil.mapNotNull(updaters.keySet(), repo -> {
            GitUpdater updater = (GitUpdater)updaters.get(repo);
            if (updater instanceof GitRebaseUpdater) {
                GitBranchPair sourceAndTarget = ((GitRebaseUpdater)updater).getSourceAndTarget();
                String currentRef = sourceAndTarget.getSource().getFullName();
                String baseRef = sourceAndTarget.getTarget().getFullName();
                return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo : null;
            }
            return null;
        });
        if (list2 == null) {
            GitUpdateProcess.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    private Map<GitRepository, GitUpdater> tryFastForwardMergeForRebaseUpdaters(@NotNull Map<GitRepository, GitUpdater> updaters) {
        if (updaters == null) {
            GitUpdateProcess.$$$reportNull$$$0(16);
        }
        LinkedHashMap<GitRepository, GitUpdater> modifiedUpdaters = new LinkedHashMap<GitRepository, GitUpdater>();
        Map changesUnderRoots = LocalChangesUnderRoots.getChangesUnderRoots(GitUtil.getRootsFromRepositories(updaters.keySet()), (Project)this.myProject);
        for (GitRepository repository : updaters.keySet()) {
            GitUpdater updater = updaters.get(repository);
            Collection changes = (Collection)changesUnderRoots.get(repository.getRoot());
            LOG.debug("Changes under root '" + DvcsUtil.getShortRepositoryName((Repository)repository) + "': " + changes);
            if (updater instanceof GitRebaseUpdater) {
                GitRebaseUpdater rebaseUpdater = (GitRebaseUpdater)updater;
                if (changes != null && !changes.isEmpty() && rebaseUpdater.fastForwardMerge()) continue;
            }
            modifiedUpdaters.put(repository, updater);
        }
        LinkedHashMap<GitRepository, GitUpdater> linkedHashMap = modifiedUpdaters;
        if (linkedHashMap == null) {
            GitUpdateProcess.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    @NotNull
    private Map<GitRepository, GitUpdater> defineUpdaters(@NotNull UpdateMethod updateMethod, @NotNull Map<GitRepository, GitBranchPair> trackedBranches) throws VcsException {
        if (updateMethod == null) {
            GitUpdateProcess.$$$reportNull$$$0(18);
        }
        if (trackedBranches == null) {
            GitUpdateProcess.$$$reportNull$$$0(19);
        }
        LinkedHashMap<GitRepository, GitUpdater> updaters = new LinkedHashMap<GitRepository, GitUpdater>();
        for (GitRepository repository : trackedBranches.keySet()) {
            GitBranchPair branchAndTracked = trackedBranches.get(repository);
            GitUpdater updater = GitUpdater.getUpdater(this.myProject, this.myGit, branchAndTracked, repository, this.myProgressIndicator, this.myUpdatedFiles, updateMethod);
            if (!updater.isUpdateNeeded(branchAndTracked)) continue;
            updaters.put(repository, updater);
        }
        for (GitRepository repository : this.mySubmodulesInDetachedHead.keySet()) {
            GitSubmoduleUpdater updater = new GitSubmoduleUpdater(this.myProject, this.myGit, this.mySubmodulesInDetachedHead.get(repository).getParent(), repository, this.myProgressIndicator, this.myUpdatedFiles);
            updaters.put(repository, updater);
        }
        LOG.info("Updaters: " + updaters);
        LinkedHashMap<GitRepository, GitUpdater> linkedHashMap = updaters;
        if (linkedHashMap == null) {
            GitUpdateProcess.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    @NotNull
    public Map<GitRepository, String> getSkippedRoots() {
        Map<GitRepository, String> map2 = this.mySkippedRoots;
        if (map2 == null) {
            GitUpdateProcess.$$$reportNull$$$0(21);
        }
        return map2;
    }

    @Nullable
    public Map<GitRepository, HashRange> getUpdatedRanges() {
        return this.myUpdatedRanges;
    }

    @NotNull
    private static GitUpdateResult joinResults(@Nullable GitUpdateResult compoundResult, GitUpdateResult result2) {
        if (compoundResult == null) {
            GitUpdateResult gitUpdateResult = result2;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(22);
            }
            return gitUpdateResult;
        }
        GitUpdateResult gitUpdateResult = compoundResult.join(result2);
        if (gitUpdateResult == null) {
            GitUpdateProcess.$$$reportNull$$$0(23);
        }
        return gitUpdateResult;
    }

    private boolean fetchAndNotify(@NotNull Map<GitRepository, GitBranchPair> updateConfig) {
        if (updateConfig == null) {
            GitUpdateProcess.$$$reportNull$$$0(24);
        }
        List remotes = ContainerUtil.mapNotNull(updateConfig.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitBranch target = ((GitBranchPair)entry.getValue()).getTarget();
            if (target instanceof GitRemoteBranch) {
                return new Pair((Object)repository, (Object)((GitRemoteBranch)target).getRemote());
            }
            return null;
        });
        return GitFetchSupport.fetchSupport(this.myProject).fetchRemotes(remotes).showNotificationIfFailed(GitBundle.message("notification.title.update.failed", new Object[0]));
    }

    @Nullable
    private Map<GitRepository, GitBranchPair> checkTrackedBranchesConfiguration() {
        LOG.info("checking tracked branch configuration...");
        LinkedHashMap<GitRepository, GitLocalBranch> currentBranches = new LinkedHashMap<GitRepository, GitLocalBranch>();
        ArrayList<GitRepository> detachedHeads = new ArrayList<GitRepository>();
        for (GitRepository repository : this.myRepositories) {
            if (this.mySubmodulesInDetachedHead.containsKey(repository)) {
                LOG.debug("Repository " + repository + " is a submodule in detached HEAD state, not checking its tracked branch");
                continue;
            }
            GitLocalBranch branch = repository.getCurrentBranch();
            if (branch != null) {
                currentBranches.put(repository, branch);
                continue;
            }
            detachedHeads.add(repository);
            LOG.info(String.format("skipping update of [%s] (detached HEAD)", DvcsUtil.getShortRepositoryName((Repository)repository)));
        }
        if (!detachedHeads.isEmpty() && (currentBranches.isEmpty() || this.isSyncControl())) {
            GitUpdateProcess.notifyDetachedHeadError((GitRepository)detachedHeads.get(0));
            return null;
        }
        for (GitRepository repo : detachedHeads) {
            this.mySkippedRoots.put(repo, GitBundle.message("update.skip.root.reason.detached.head", new Object[0]));
        }
        LinkedHashMap<GitRepository, GitBranchPair> trackedBranches = new LinkedHashMap<GitRepository, GitBranchPair>();
        ArrayList<GitRepository> noTrackedBranch = new ArrayList<GitRepository>();
        for (GitRepository repository : currentBranches.keySet()) {
            GitLocalBranch branch;
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, branch = (GitLocalBranch)currentBranches.get(repository));
            if (trackInfo != null) {
                trackedBranches.put(repository, new GitBranchPair(branch, trackInfo.getRemoteBranch()));
                continue;
            }
            noTrackedBranch.add(repository);
            LOG.info(String.format("skipping update of [%s] (no tracked branch for current branch [%s])", DvcsUtil.getShortRepositoryName((Repository)repository), branch));
        }
        if (this.myCheckForTrackedBranchExistence && !noTrackedBranch.isEmpty() && (trackedBranches.isEmpty() || this.isSyncControl())) {
            GitRepository repo = (GitRepository)noTrackedBranch.get(0);
            this.notifyNoTrackedBranchError(repo, (GitLocalBranch)currentBranches.get(repo));
            return null;
        }
        for (GitRepository repo : noTrackedBranch) {
            this.mySkippedRoots.put(repo, GitBundle.message("update.skip.root.reason.no.tracked.branch", new Object[0]));
        }
        return trackedBranches;
    }

    private void notifyNoTrackedBranchError(@NotNull GitRepository repository, @NotNull GitLocalBranch currentBranch) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(25);
        }
        if (currentBranch == null) {
            GitUpdateProcess.$$$reportNull$$$0(26);
        }
        VcsNotifier.getInstance((Project)repository.getProject()).notifyError("git.update.no.tracked.branch.error", GitBundle.message("update.notification.update.error", new Object[0]), GitUpdateProcess.getNoTrackedBranchError(repository, currentBranch.getName()), new NotificationAction[]{NotificationAction.createSimple((String)GitBundle.message("update.notification.choose.upstream.branch", new Object[0]), () -> this.showUpdateDialog(repository))});
    }

    private void showUpdateDialog(@NotNull GitRepository repository) {
        FixTrackedBranchDialog updateDialog;
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(27);
        }
        if ((updateDialog = new FixTrackedBranchDialog(repository.getProject())).showAndGet()) {
            new GitUpdateExecutionProcess(repository.getProject(), this.myRepositories, updateDialog.getUpdateConfig(), updateDialog.getUpdateMethod(), updateDialog.shouldSetAsTrackedBranch()).execute();
        }
    }

    private static void notifyDetachedHeadError(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(28);
        }
        VcsNotifier.getInstance((Project)repository.getProject()).notifyError("git.update.detached.head.error", GitBundle.message("notification.title.can.t.update.no.current.branch", new Object[0]), GitUpdateProcess.getDetachedHeadErrorNotificationContent(repository));
    }

    @VisibleForTesting
    @NlsContexts.NotificationContent
    @NotNull
    static String getDetachedHeadErrorNotificationContent(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(29);
        }
        String string = GitBundle.message("notification.content.detached.state.in.root.checkout.branch", GitUtil.mention(repository));
        if (string == null) {
            GitUpdateProcess.$$$reportNull$$$0(30);
        }
        return string;
    }

    private boolean isSyncControl() {
        return GitVcsSettings.getInstance(this.myProject).getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    @VisibleForTesting
    @NlsContexts.NotificationContent
    @NotNull
    static String getNoTrackedBranchError(@NotNull GitRepository repository, @NotNull @NlsSafe String branchName) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(31);
        }
        if (branchName == null) {
            GitUpdateProcess.$$$reportNull$$$0(32);
        }
        String string = GitBundle.message("notification.content.branch.in.repo.has.no.tracked.branch", GitUIUtil.code(branchName), GitUtil.mention(repository));
        if (string == null) {
            GitUpdateProcess.$$$reportNull$$$0(33);
        }
        return string;
    }

    private boolean isMergeInProgress() {
        LOG.info("isMergeInProgress: checking if there is an unfinished merge process...");
        Collection<VirtualFile> mergingRoots = this.myMerger.getMergingRoots();
        if (mergingRoots.isEmpty()) {
            return false;
        }
        LOG.info("isMergeInProgress: roots with unfinished merge: " + mergingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle(GitBundle.message("update.process.generic.error.title", new Object[0]));
        params.setMergeDescription(GitBundle.message("update.process.error.message.unfinished.merge", new Object[0]));
        return !new GitMergeCommittingConflictResolver(this.myProject, mergingRoots, params, false).merge();
    }

    private boolean areUnmergedFiles() {
        LOG.info("areUnmergedFiles: checking if there are unmerged files...");
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle(GitBundle.message("update.process.generic.error.title", new Object[0]));
        params.setMergeDescription(GitBundle.message("update.process.error.message.unmerged.files", new Object[0]));
        return !new GitMergeCommittingConflictResolver(this.myProject, GitUtil.getRootsFromRepositories(this.myRepositories), params, false).merge();
    }

    private boolean checkRebaseInProgress() {
        LOG.info("checkRebaseInProgress: checking if there is an unfinished rebase process...");
        final List rebasingRoots = ContainerUtil.map(GitRebaseUtils.getRebasingRepositories(this.myProject), repo -> repo.getRoot());
        if (rebasingRoots.isEmpty()) {
            return false;
        }
        LOG.info("checkRebaseInProgress: roots with unfinished rebase: " + rebasingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle(GitBundle.message("update.process.generic.error.title", new Object[0]));
        params.setMergeDescription(GitBundle.message("update.process.error.description.unfinished.rebase", new Object[0]));
        params.setErrorNotificationAdditionalDescription(GitBundle.message("update.process.error.additional.description.unfinished.rebase", new Object[0]));
        params.setReverse(true);
        return !new GitConflictResolver(this.myProject, rebasingRoots, params){

            @Override
            protected boolean proceedIfNothingToMerge() {
                return new GitRebaser(this.myProject, GitUpdateProcess.this.myGit, GitUpdateProcess.this.myProgressIndicator).continueRebase(rebasingRoots);
            }

            @Override
            protected boolean proceedAfterAllMerged() {
                return new GitRebaser(this.myProject, GitUpdateProcess.this.myGit, GitUpdateProcess.this.myProgressIndicator).continueRebase(rebasingRoots);
            }
        }.merge();
    }

    private static /* synthetic */ Boolean lambda$updateImpl$1(Ref incomplete, Ref compoundResult) {
        return (Boolean)incomplete.get() == false && !compoundResult.isNull() && ((GitUpdateResult)((Object)compoundResult.get())).isSuccess();
    }

    private /* synthetic */ void lambda$updateImpl$0(Map finalUpdaters, Ref incomplete, Ref compoundResult) {
        LOG.info("updateImpl: updating...");
        GitRepository currentlyUpdatedRoot = null;
        try {
            for (GitRepository repo : finalUpdaters.keySet()) {
                GitUpdater updater = (GitUpdater)finalUpdaters.get(repo);
                if (updater == null) continue;
                currentlyUpdatedRoot = repo;
                GitUpdateResult res = updater.update();
                LOG.info("updating root " + currentlyUpdatedRoot + " finished: " + res);
                if (res == GitUpdateResult.INCOMPLETE) {
                    incomplete.set((Object)true);
                }
                compoundResult.set((Object)GitUpdateProcess.joinResults((GitUpdateResult)((Object)compoundResult.get()), res));
            }
        }
        catch (VcsException e) {
            String rootName = currentlyUpdatedRoot == null ? "" : DvcsUtil.getShortRepositoryName(currentlyUpdatedRoot);
            LOG.info("Error updating changes for root " + currentlyUpdatedRoot, (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.update.error", GitBundle.message("notification.title.error.updating.root", rootName), GitBundle.message("notification.content.updating.root.failed.with.error", rootName, e.getLocalizedMessage()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 17, 20, 21, 22, 23, 30, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitUpdateProcess";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMethod";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updaters";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackedBranches";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateConfig";
                break;
            }
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitUpdateProcess";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootsRebasingOverMerge";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFastForwardMergeForRebaseUpdaters";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "defineUpdaters";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "joinResults";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetachedHeadErrorNotificationContent";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoTrackedBranchError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 33: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRootsRebasingOverMerge";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryFastForwardMergeForRebaseUpdaters";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "defineUpdaters";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fetchAndNotify";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyNoTrackedBranchError";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showUpdateDialog";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "notifyDetachedHeadError";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDetachedHeadErrorNotificationContent";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNoTrackedBranchError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 17, 20, 21, 22, 23, 30, 33 -> new IllegalStateException(string);
        };
    }
}

