/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class IdentityResolver
implements ValuesOrderResolver {
    private static final Object NULL_MARKER = ObjectUtils.sentinel((String)"IdentityResolver.NULL_MARKER");

    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        if (info == null) {
            IdentityResolver.$$$reportNull$$$0(0);
        }
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        HashMap<TraceElement, List<TraceElement>> direct = new HashMap<TraceElement, List<TraceElement>>();
        HashMap<TraceElement, List<TraceElement>> reverse = new HashMap<TraceElement, List<TraceElement>>();
        Map grouped = ((StreamEx)StreamEx.of(after.keySet()).sorted()).map(after::get).groupingBy(IdentityResolver::extractKey);
        HashMap<Object, Integer> key2Index = new HashMap<Object, Integer>();
        for (TraceElement element : before.values()) {
            Object key = IdentityResolver.extractKey(element);
            List elements2 = (List)grouped.get(key);
            if (elements2 == null || elements2.isEmpty()) {
                direct.put(element, Collections.emptyList());
                continue;
            }
            int nextIndex = key2Index.getOrDefault(key, -1) + 1;
            key2Index.put(key, nextIndex);
            TraceElement afterItem = (TraceElement)elements2.get(nextIndex);
            direct.put(element, Collections.singletonList(afterItem));
            reverse.put(afterItem, Collections.singletonList(element));
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        if (result == null) {
            IdentityResolver.$$$reportNull$$$0(1);
        }
        return result;
    }

    @NotNull
    private static Object extractKey(@NotNull TraceElement element) {
        Object key;
        if (element == null) {
            IdentityResolver.$$$reportNull$$$0(2);
        }
        Object object = (key = TraceUtil.extractKey(element)) == null ? NULL_MARKER : key;
        if (object == null) {
            IdentityResolver.$$$reportNull$$$0(3);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/resolve/IdentityResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/resolve/IdentityResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

