/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.streams.ui.LinkedValuesMapping;
import com.intellij.debugger.streams.ui.TraceController;
import com.intellij.debugger.streams.ui.ValueWithPosition;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/streams/ui/impl/MappingPane;", "Ljavax/swing/JPanel;", "name", "", "fullCallExpression", "beforeValues", "", "Lcom/intellij/debugger/streams/ui/ValueWithPosition;", "mapping", "Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;", "controller", "Lcom/intellij/debugger/streams/ui/TraceController;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;Lcom/intellij/debugger/streams/ui/TraceController;)V", "Companion", "LineColor", "MyDrawPane", "intellij.java.debugger.streams"})
public final class MappingPane
extends JPanel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ValueWithPosition> beforeValues;
    @NotNull
    private final LinkedValuesMapping mapping;
    @NotNull
    private final TraceController controller;
    @NotNull
    private static final LineColor DARCULA_LINE_COLOR;
    @NotNull
    private static final LineColor INTELLIJ_LINE_COLOR;
    @NotNull
    private static final BasicStroke STROKE;

    public MappingPane(@Nls @NotNull String name, @Nls @NotNull String fullCallExpression, @NotNull List<? extends ValueWithPosition> beforeValues, @NotNull LinkedValuesMapping mapping, @NotNull TraceController controller) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fullCallExpression, (String)"fullCallExpression");
        Intrinsics.checkNotNullParameter(beforeValues, (String)"beforeValues");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        super(new BorderLayout());
        this.beforeValues = beforeValues;
        this.mapping = mapping;
        this.controller = controller;
        JBLabel label = new JBLabel(name, 0);
        label.setToolTipText(fullCallExpression);
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)3, (int)0));
        this.add((Component)label, "North");
        this.add((Component)new MyDrawPane(), "Center");
    }

    private static final Color DARCULA_LINE_COLOR$lambda$0() {
        return new Color(92, 92, 92);
    }

    private static final Color INTELLIJ_LINE_COLOR$lambda$1() {
        return new Color(168, 168, 168);
    }

    private static final Color INTELLIJ_LINE_COLOR$lambda$2() {
        return new Color(0, 96, 229);
    }

    private static final Color INTELLIJ_LINE_COLOR$lambda$3() {
        return new Color(204, 204, 204);
    }

    static {
        JBColor jBColor = JBColor.GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
        JBColor jBColor2 = JBColor.BLUE;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"BLUE");
        JBColor jBColor3 = JBColor.lazy(MappingPane::DARCULA_LINE_COLOR$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"lazy(...)");
        DARCULA_LINE_COLOR = new LineColor(jBColor, jBColor2, jBColor3);
        JBColor jBColor4 = JBColor.lazy(MappingPane::INTELLIJ_LINE_COLOR$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"lazy(...)");
        JBColor jBColor5 = JBColor.lazy(MappingPane::INTELLIJ_LINE_COLOR$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor5, (String)"lazy(...)");
        JBColor jBColor6 = JBColor.lazy(MappingPane::INTELLIJ_LINE_COLOR$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor6, (String)"lazy(...)");
        INTELLIJ_LINE_COLOR = new LineColor(jBColor4, jBColor5, jBColor6);
        STROKE = new BasicStroke(JBUIScale.scale((float)1.0f));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/streams/ui/impl/MappingPane$Companion;", "", "()V", "DARCULA_LINE_COLOR", "Lcom/intellij/debugger/streams/ui/impl/MappingPane$LineColor;", "getDARCULA_LINE_COLOR", "()Lcom/intellij/debugger/streams/ui/impl/MappingPane$LineColor;", "INTELLIJ_LINE_COLOR", "getINTELLIJ_LINE_COLOR", "STROKE", "Ljava/awt/BasicStroke;", "getSTROKE", "()Ljava/awt/BasicStroke;", "intellij.java.debugger.streams"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LineColor getDARCULA_LINE_COLOR() {
            return DARCULA_LINE_COLOR;
        }

        @NotNull
        public final LineColor getINTELLIJ_LINE_COLOR() {
            return INTELLIJ_LINE_COLOR;
        }

        @NotNull
        public final BasicStroke getSTROKE() {
            return STROKE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/debugger/streams/ui/impl/MappingPane$LineColor;", "", "regular", "Lcom/intellij/ui/JBColor;", "selected", "inactive", "(Lcom/intellij/ui/JBColor;Lcom/intellij/ui/JBColor;Lcom/intellij/ui/JBColor;)V", "getInactive", "()Lcom/intellij/ui/JBColor;", "getRegular", "getSelected", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.java.debugger.streams"})
    private static final class LineColor {
        @NotNull
        private final JBColor regular;
        @NotNull
        private final JBColor selected;
        @NotNull
        private final JBColor inactive;

        public LineColor(@NotNull JBColor regular, @NotNull JBColor selected, @NotNull JBColor inactive) {
            Intrinsics.checkNotNullParameter((Object)regular, (String)"regular");
            Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
            Intrinsics.checkNotNullParameter((Object)inactive, (String)"inactive");
            this.regular = regular;
            this.selected = selected;
            this.inactive = inactive;
        }

        @NotNull
        public final JBColor getRegular() {
            return this.regular;
        }

        @NotNull
        public final JBColor getSelected() {
            return this.selected;
        }

        @NotNull
        public final JBColor getInactive() {
            return this.inactive;
        }

        @NotNull
        public final JBColor component1() {
            return this.regular;
        }

        @NotNull
        public final JBColor component2() {
            return this.selected;
        }

        @NotNull
        public final JBColor component3() {
            return this.inactive;
        }

        @NotNull
        public final LineColor copy(@NotNull JBColor regular, @NotNull JBColor selected, @NotNull JBColor inactive) {
            Intrinsics.checkNotNullParameter((Object)regular, (String)"regular");
            Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
            Intrinsics.checkNotNullParameter((Object)inactive, (String)"inactive");
            return new LineColor(regular, selected, inactive);
        }

        public static /* synthetic */ LineColor copy$default(LineColor lineColor, JBColor jBColor, JBColor jBColor2, JBColor jBColor3, int n, Object object) {
            if ((n & 1) != 0) {
                jBColor = lineColor.regular;
            }
            if ((n & 2) != 0) {
                jBColor2 = lineColor.selected;
            }
            if ((n & 4) != 0) {
                jBColor3 = lineColor.inactive;
            }
            return lineColor.copy(jBColor, jBColor2, jBColor3);
        }

        @NotNull
        public String toString() {
            return "LineColor(regular=" + this.regular + ", selected=" + this.selected + ", inactive=" + this.inactive + ")";
        }

        public int hashCode() {
            int result = this.regular.hashCode();
            result = result * 31 + this.selected.hashCode();
            result = result * 31 + this.inactive.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineColor)) {
                return false;
            }
            LineColor lineColor = (LineColor)other;
            if (!Intrinsics.areEqual((Object)this.regular, (Object)lineColor.regular)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.selected, (Object)lineColor.selected)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.inactive, (Object)lineColor.inactive);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/debugger/streams/ui/impl/MappingPane$MyDrawPane;", "Ljavax/swing/JPanel;", "(Lcom/intellij/debugger/streams/ui/impl/MappingPane;)V", "drawLines", "", "g", "Ljava/awt/Graphics2D;", "color", "Ljava/awt/Color;", "highlighted", "", "isSelectedExist", "needToDraw", "left", "Lcom/intellij/debugger/streams/ui/ValueWithPosition;", "right", "needToHighlight", "paintComponent", "Ljava/awt/Graphics;", "intellij.java.debugger.streams"})
    private final class MyDrawPane
    extends JPanel {
        @Override
        protected void paintComponent(@Nullable Graphics g) {
            if (g == null) {
                return;
            }
            if (g instanceof Graphics2D) {
                LineColor colors;
                ((Graphics2D)g).setStroke(Companion.getSTROKE());
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                LineColor lineColor = colors = UIUtil.isUnderDarcula() ? Companion.getDARCULA_LINE_COLOR() : Companion.getINTELLIJ_LINE_COLOR();
                if (this.isSelectedExist()) {
                    this.drawLines((Graphics2D)g, (Color)colors.getInactive(), false);
                    this.drawLines((Graphics2D)g, (Color)colors.getSelected(), true);
                } else {
                    this.drawLines((Graphics2D)g, (Color)colors.getRegular(), false);
                }
                config.restore();
            }
        }

        private final boolean isSelectedExist() {
            return MappingPane.this.controller.isSelectionExists();
        }

        private final void drawLines(Graphics2D g, Color color, boolean highlighted) {
            int x1 = this.getX();
            int x2 = this.getX() + this.getWidth();
            g.setColor(color);
            for (ValueWithPosition value : MappingPane.this.beforeValues) {
                List<ValueWithPosition> linkedValues;
                if (MappingPane.this.mapping.getLinkedValues(value) == null) continue;
                for (ValueWithPosition nextValue : linkedValues) {
                    if (!this.needToDraw(value, nextValue) || highlighted != this.needToHighlight(value, nextValue)) continue;
                    int y1 = value.getPosition();
                    int y2 = nextValue.getPosition();
                    g.drawLine(x1, y1, x2, y2);
                }
            }
        }

        private final boolean needToDraw(ValueWithPosition left, ValueWithPosition right) {
            return left.isVisible() || right.isVisible();
        }

        private final boolean needToHighlight(ValueWithPosition left, ValueWithPosition right) {
            return left.isHighlighted() && right.isHighlighted();
        }
    }
}

