/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TtyConnectorAccessor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.block.BlockTerminalView;
import org.jetbrains.plugins.terminal.block.OldPlainTerminalView;
import org.jetbrains.plugins.terminal.block.TerminalContentView;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.BlockTerminalColorPalette;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001<B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007H\u0016J\u0018\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0018\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0011H\u0017J\b\u0010-\u001a\u00020!H\u0016J\b\u0010.\u001a\u00020#H\u0016J\b\u0010/\u001a\u00020#H\u0016J\b\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\u0006\u00104\u001a\u000205H\u0007J\b\u00106\u001a\u00020!H\u0016J\u0010\u00107\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u00108\u001a\u00020!2\u0006\u00109\u001a\u000201H\u0016J\u0010\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/plugins/terminal/block/TerminalWidgetImpl;", "Lcom/intellij/terminal/ui/TerminalWidget;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;Lcom/intellij/openapi/Disposable;)V", "shellCommand", "", "", "getShellCommand", "()Ljava/util/List;", "setShellCommand", "(Ljava/util/List;)V", "termSize", "Lcom/jediterm/core/util/TermSize;", "getTermSize", "()Lcom/jediterm/core/util/TermSize;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "getTerminalTitle", "()Lcom/intellij/terminal/TerminalTitle;", "ttyConnectorAccessor", "Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "getTtyConnectorAccessor", "()Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "view", "Lorg/jetbrains/plugins/terminal/block/TerminalContentView;", "wrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "addNotification", "", "notificationComponent", "Ljavax/swing/JComponent;", "disposable", "addTerminationCallback", "onTerminated", "Ljava/lang/Runnable;", "parentDisposable", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "dispose", "getComponent", "getPreferredFocusableComponent", "hasFocus", "", "initialize", "Ljava/util/concurrent/CompletableFuture;", "options", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "requestFocus", "sendCommandToExecute", "setCursorVisible", "visible", "writePlainMessage", "message", "TerminalPlaceholder", "intellij.terminal"})
public final class TerminalWidgetImpl
implements TerminalWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProvider settings;
    @NotNull
    private final Wrapper wrapper;
    @NotNull
    private final TerminalTitle terminalTitle;
    @NotNull
    private final TtyConnectorAccessor ttyConnectorAccessor;
    @Nullable
    private List<String> shellCommand;
    @NotNull
    private volatile TerminalContentView view;

    public TerminalWidgetImpl(@NotNull Project project, @NotNull JBTerminalSystemSettingsProvider settings, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.settings = settings;
        this.wrapper = new Wrapper();
        this.terminalTitle = new TerminalTitle();
        this.ttyConnectorAccessor = new TtyConnectorAccessor();
        this.view = new TerminalPlaceholder();
        this.wrapper.setContent(this.view.getComponent());
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.view);
    }

    @NotNull
    public TerminalTitle getTerminalTitle() {
        return this.terminalTitle;
    }

    @Nullable
    public TermSize getTermSize() {
        return this.view.getTerminalSize();
    }

    @NotNull
    public TtyConnectorAccessor getTtyConnectorAccessor() {
        return this.ttyConnectorAccessor;
    }

    @Nullable
    public List<String> getShellCommand() {
        return this.shellCommand;
    }

    public void setShellCommand(@Nullable List<String> list) {
        this.shellCommand = list;
    }

    @RequiresEdt(generateAssertion=false)
    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        this.view.connectToTty(ttyConnector, initialTermSize);
        this.getTtyConnectorAccessor().setTtyConnector(ttyConnector);
    }

    @RequiresEdt(generateAssertion=false)
    @NotNull
    public final CompletableFuture<TermSize> initialize(@NotNull ShellStartupOptions options2) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        TerminalContentView oldView = this.view;
        ShellIntegration shellIntegration = options2.getShellIntegration();
        if ((shellIntegration != null ? shellIntegration.getCommandBlockIntegration() : null) != null) {
            BlockTerminalSession session2 = new BlockTerminalSession(this.settings, new BlockTerminalColorPalette(), options2.getShellIntegration());
            Disposer.register((Disposable)((Disposable)this), (Disposable)session2);
            v1 = new BlockTerminalView(this.project, session2, this.settings, this.getTerminalTitle());
        } else {
            v1 = this.view = (TerminalContentView)new OldPlainTerminalView(this.project, this.settings, this.getTerminalTitle());
        }
        if (oldView instanceof TerminalPlaceholder) {
            ((TerminalPlaceholder)oldView).moveTerminationCallbacksTo(this.view);
            ((TerminalPlaceholder)oldView).executePostponedShellCommands(this.view);
        }
        Disposer.dispose((Disposable)oldView);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.view);
        JComponent component2 = this.view.getComponent();
        this.wrapper.setContent(component2);
        this.requestFocus();
        CompletionStage completionStage = TerminalUiUtils.INSTANCE.awaitComponentLayout(component2, this.view).thenApply(arg_0 -> TerminalWidgetImpl.initialize$lambda$0((Function1)new Function1<Unit, TermSize>(this){
            final /* synthetic */ TerminalWidgetImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final TermSize invoke(Unit it) {
                return TerminalWidgetImpl.access$getView$p(this.this$0).getTerminalSize();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    public void writePlainMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public void setCursorVisible(boolean visible) {
    }

    public boolean hasFocus() {
        return this.view.isFocused();
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
    }

    public void addNotification(@NotNull JComponent notificationComponent, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)notificationComponent, (String)"notificationComponent");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
    }

    public void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.view.sendCommandToExecute(shellCommand);
    }

    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.view.addTerminationCallback(onTerminated, parentDisposable);
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.wrapper;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.view.getPreferredFocusableComponent();
    }

    private static final TermSize initialize$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TermSize)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ TerminalContentView access$getView$p(TerminalWidgetImpl $this) {
        return $this.view;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0001J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0001J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/terminal/block/TerminalWidgetImpl$TerminalPlaceholder;", "Lorg/jetbrains/plugins/terminal/block/TerminalContentView;", "()V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "postponedShellCommands", "", "", "postponedTerminationCallbackInfos", "Lkotlin/Pair;", "Ljava/lang/Runnable;", "Lcom/intellij/openapi/Disposable;", "preferredFocusableComponent", "getPreferredFocusableComponent", "addTerminationCallback", "", "onTerminated", "parentDisposable", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "dispose", "executePostponedShellCommands", "destView", "getTerminalSize", "isFocused", "", "moveTerminationCallbacksTo", "sendCommandToExecute", "shellCommand", "intellij.terminal"})
    private static final class TerminalPlaceholder
    implements TerminalContentView {
        @NotNull
        private final List<Pair<Runnable, Disposable>> postponedTerminationCallbackInfos = new CopyOnWriteArrayList();
        @NotNull
        private final List<String> postponedShellCommands = new CopyOnWriteArrayList();
        @NotNull
        private final JComponent component = new JPanel(){
            {
                this.setBackground((Color)TerminalUi.defaultBackground$default(TerminalUi.INSTANCE, null, 1, null));
            }
        };
        @NotNull
        private final JComponent preferredFocusableComponent = this.getComponent();

        @Override
        @NotNull
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        @NotNull
        public JComponent getPreferredFocusableComponent() {
            return this.preferredFocusableComponent;
        }

        @Override
        public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
            Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
            Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
            throw new IllegalStateException("Unexpected method call".toString());
        }

        @Override
        @Nullable
        public TermSize getTerminalSize() {
            return null;
        }

        @Override
        public boolean isFocused() {
            return false;
        }

        @Override
        public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.postponedTerminationCallbackInfos.add((Pair<Runnable, Disposable>)new Pair((Object)onTerminated, (Object)parentDisposable));
        }

        @Override
        public void sendCommandToExecute(@NotNull String shellCommand) {
            Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
            this.postponedShellCommands.add(shellCommand);
        }

        public final void moveTerminationCallbacksTo(@NotNull TerminalContentView destView) {
            Intrinsics.checkNotNullParameter((Object)destView, (String)"destView");
            for (Pair<Runnable, Disposable> info : this.postponedTerminationCallbackInfos) {
                destView.addTerminationCallback((Runnable)info.getFirst(), (Disposable)info.getSecond());
            }
            this.postponedTerminationCallbackInfos.clear();
        }

        public final void executePostponedShellCommands(@NotNull TerminalContentView destView) {
            Intrinsics.checkNotNullParameter((Object)destView, (String)"destView");
            for (String shellCommand : this.postponedShellCommands) {
                destView.sendCommandToExecute(shellCommand);
            }
            this.postponedShellCommands.clear();
        }

        public void dispose() {
            this.postponedTerminationCallbackInfos.clear();
        }
    }
}

