/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingGroupBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingItem;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.block.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalUsageData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\tH\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0094\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/terminal/block/feedback/BlockTerminalFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lorg/jetbrains/plugins/terminal/block/feedback/BlockTerminalUsageData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "(Lcom/intellij/openapi/project/Project;Z)V", "myBlocks", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "myFeedbackReportId", "", "getMyFeedbackReportId", "()Ljava/lang/String;", "myShowFeedbackSystemInfoDialog", "Lkotlin/Function0;", "", "getMyShowFeedbackSystemInfoDialog$annotations", "()V", "getMyShowFeedbackSystemInfoDialog", "()Lkotlin/jvm/functions/Function0;", "mySystemInfoData", "getMySystemInfoData", "()Lorg/jetbrains/plugins/terminal/block/feedback/BlockTerminalUsageData;", "mySystemInfoData$delegate", "Lkotlin/Lazy;", "myTitle", "getMyTitle", "createRatingItems", "Lcom/intellij/platform/feedback/dialog/uiBlocks/RatingItem;", "intellij.terminal"})
public final class BlockTerminalFeedbackDialog
extends BlockBasedFeedbackDialog<BlockTerminalUsageData> {
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final Lazy mySystemInfoData$delegate;
    @NotNull
    private final Function0<Unit> myShowFeedbackSystemInfoDialog;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public BlockTerminalFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, forTest);
        this.myFeedbackReportId = "new_terminal";
        String string = TerminalBundle.message("feedback.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myTitle = string;
        this.mySystemInfoData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BlockTerminalUsageData>(forTest, this, project){
            final /* synthetic */ boolean $forTest;
            final /* synthetic */ BlockTerminalFeedbackDialog this$0;
            final /* synthetic */ Project $project;
            {
                this.$forTest = $forTest;
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final BlockTerminalUsageData invoke() {
                String string;
                TerminalUsageLocalStorage usageStorage = TerminalUsageLocalStorage.Companion.getInstance();
                String rawMostUsedShell = usageStorage.getMostUsedShell();
                if (rawMostUsedShell == null && this.$forTest) {
                    BlockTerminalFeedbackDialog $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BlockTerminalFeedbackDialog.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("No information about most used shell, because no commands were executed in the terminal");
                    string = "none";
                } else {
                    String string2 = rawMostUsedShell;
                    string = string2;
                    Intrinsics.checkNotNull((Object)string2);
                }
                String mostUsedShell = string;
                return new BlockTerminalUsageData(mostUsedShell, usageStorage.getExecutedCommandsNumber(), BlockTerminalFeedbackSurveyKt.getFeedbackMoment(this.$project), CommonFeedbackSystemData.Companion.getCurrentData());
            }
        }));
        this.myShowFeedbackSystemInfoDialog = (Function0)new Function0<Unit>(this){
            final /* synthetic */ BlockTerminalFeedbackDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)BlockTerminalFeedbackDialog.access$getMyProject(this.this$0), (CommonFeedbackSystemData)this.this$0.getMySystemInfoData().getSystemInfo(), (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ BlockTerminalFeedbackDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$showFeedbackSystemInfoDialog) {
                        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
                        String string = TerminalBundle.message("feedback.system.info.shell", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$showFeedbackSystemInfoDialog.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ BlockTerminalFeedbackDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(this.this$0.getMySystemInfoData().getMostUsedShell());
                            }
                        });
                        String string2 = TerminalBundle.message("feedback.system.info.commands.number", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        $this$showFeedbackSystemInfoDialog.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ BlockTerminalFeedbackDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(String.valueOf(this.this$0.getMySystemInfoData().getExecutedCommandsNumber()));
                            }
                        });
                        String string3 = TerminalBundle.message("feedback.system.info.moment", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                        $this$showFeedbackSystemInfoDialog.row(string3, (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ BlockTerminalFeedbackDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(this.this$0.getMySystemInfoData().getFeedbackMoment().toString());
                            }
                        });
                    }
                }));
            }
        };
        Object[] objectArray = new FeedbackBlock[4];
        String string2 = TerminalBundle.message("feedback.dialog.header", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[0] = new TopLabelBlock(string2);
        String string3 = TerminalBundle.message("feedback.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[1] = new DescriptionBlock(string3);
        String string4 = TerminalBundle.message("feedback.dialog.rating.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        RatingGroupBlock ratingGroupBlock = new RatingGroupBlock(string4, this.createRatingItems());
        String string5 = TerminalBundle.message("feedback.dialog.rating.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[2] = ratingGroupBlock.setHint(string5).setRandomOrder(true);
        String string6 = TerminalBundle.message("feedback.dialog.other", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        TextAreaBlock textAreaBlock = new TextAreaBlock(string6, "other");
        String string7 = TerminalBundle.message("feedback.dialog.other.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        objectArray[3] = textAreaBlock.setPlaceholder(string7);
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    protected BlockTerminalUsageData getMySystemInfoData() {
        Lazy lazy = this.mySystemInfoData$delegate;
        return (BlockTerminalUsageData)lazy.getValue();
    }

    @NotNull
    protected Function0<Unit> getMyShowFeedbackSystemInfoDialog() {
        return this.myShowFeedbackSystemInfoDialog;
    }

    protected static /* synthetic */ void getMyShowFeedbackSystemInfoDialog$annotations() {
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    private final List<RatingItem> createRatingItems() {
        Object[] objectArray = new RatingItem[3];
        String string = TerminalBundle.message("feedback.dialog.rating.interface", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = new RatingItem(string, "interface");
        String string2 = TerminalBundle.message("feedback.dialog.rating.feature.set", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = new RatingItem(string2, "feature_set");
        String string3 = TerminalBundle.message("feedback.dialog.rating.performance", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[2] = new RatingItem(string3, "performance");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ Project access$getMyProject(BlockTerminalFeedbackDialog $this) {
        return $this.getMyProject();
    }
}

