/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.TerminalLine;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.session.StyleRange;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/OutputBuilder;", "", "commandEndMarker", "", "(Ljava/lang/String;)V", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pendingNewLines", "", "styles", "", "Lorg/jetbrains/plugins/terminal/block/session/StyleRange;", "addLine", "", "line", "Lcom/jediterm/terminal/model/TerminalLine;", "addLines", "linesBuffer", "Lcom/jediterm/terminal/model/LinesBuffer;", "addTextChunk", "text", "style", "Lcom/jediterm/terminal/TextStyle;", "build", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "findSuffixStartIndIgnoringLF", "suffix", "intellij.terminal"})
final class OutputBuilder {
    @Nullable
    private final String commandEndMarker;
    @NotNull
    private final StringBuilder output;
    @NotNull
    private final List<StyleRange> styles;
    private int pendingNewLines;

    public OutputBuilder(@Nullable String commandEndMarker) {
        this.commandEndMarker = commandEndMarker;
        this.output = new StringBuilder();
        this.styles = new ArrayList();
    }

    public final void addLines(@NotNull LinesBuffer linesBuffer) {
        Intrinsics.checkNotNullParameter((Object)linesBuffer, (String)"linesBuffer");
        int n = linesBuffer.getLineCount();
        for (int i = 0; i < n; ++i) {
            TerminalLine terminalLine = linesBuffer.getLine(i);
            Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"getLine(...)");
            this.addLine(terminalLine);
        }
    }

    private final void addLine(TerminalLine line) {
        line.forEachEntry(arg_0 -> OutputBuilder.addLine$lambda$0(this, arg_0));
        if (!line.isWrapped()) {
            int n = this.pendingNewLines;
            this.pendingNewLines = n + 1;
        }
    }

    private final void addTextChunk(String text, TextStyle style) {
        if (((CharSequence)text).length() > 0) {
            int n = this.pendingNewLines;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.output.append('\n');
            }
            this.pendingNewLines = 0;
            int startOffset = this.output.length();
            this.output.append(text);
            if (!Intrinsics.areEqual((Object)style, (Object)TextStyle.EMPTY)) {
                this.styles.add(new StyleRange(startOffset, startOffset + text.length(), style));
            }
        }
    }

    @NotNull
    public final StyledCommandOutput build() {
        String string = this.output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String text = string;
        if (this.commandEndMarker != null) {
            String trimmedText = ((Object)StringsKt.trimEnd((CharSequence)text)).toString();
            boolean commandEndMarkerFound = StringsKt.endsWith$default((String)trimmedText, (String)this.commandEndMarker, (boolean)false, (int)2, null);
            if (commandEndMarkerFound) {
                String outputText = StringsKt.dropLast((String)trimmedText, (int)this.commandEndMarker.length());
                return new StyledCommandOutput(outputText, true, this.styles);
            }
            int suffixStartInd = this.findSuffixStartIndIgnoringLF(trimmedText, this.commandEndMarker);
            if (suffixStartInd >= 0) {
                String string2 = trimmedText.substring(0, suffixStartInd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String commandText = string2;
                return new StyledCommandOutput(commandText, true, this.styles);
            }
        }
        return new StyledCommandOutput(text, false, this.styles);
    }

    private final int findSuffixStartIndIgnoringLF(String text, String suffix) {
        if (!(((CharSequence)suffix).length() > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (text.length() < suffix.length()) {
            return -1;
        }
        int textInd = text.length();
        for (int suffixInd = suffix.length() - 1; -1 < suffixInd; --suffixInd) {
            --textInd;
            while (textInd >= 0 && text.charAt(textInd) == '\n') {
                --textInd;
            }
            if (textInd >= 0 && text.charAt(textInd) == suffix.charAt(suffixInd)) continue;
            return -1;
        }
        return textInd;
    }

    private static final void addLine$lambda$0(OutputBuilder this$0, TerminalLine.TextEntry entry) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CharBuffer charBuffer = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
        if (((CharSequence)charBuffer).length() > 0 && !entry.isNul()) {
            CharBuffer charBuffer2 = entry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charBuffer2, (String)"getText(...)");
            String string = TerminalUiUtilsKt.normalize(charBuffer2);
            TextStyle textStyle = entry.getStyle();
            Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"getStyle(...)");
            this$0.addTextChunk(string, textStyle);
        }
    }
}

